/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dbinterface.h2.queries.alters;

import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.alters.ModifyColumnType;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.dbinterface.h2.queries.AbstractUpdate;

public class ModifyColumnTypeImpl
extends AbstractUpdate
implements ModifyColumnType {
    private Table table;
    private SimpleAttribute column;
    private Type newType;
    private boolean useCast = true;
    private String query = "ALTER TABLE <%TABLE%> ALTER COLUMN <%COLNAME%> TYPE <%TYPE%> <%USING%>";

    @Override
    public SimpleTable execute(DBSession session) throws Exception {
        session.executeUpdate(this.getExpression());
        if (SimpleTable.class.getName().compareTo(this.table.getClass().getName()) == 0) {
            SimpleTable tmpTable = (SimpleTable)this.table;
            tmpTable.initializeFieldMapping();
            return tmpTable;
        }
        SimpleTable table = new SimpleTable(this.table.getTable());
        table.initializeCount();
        return table;
    }

    @Override
    public String getExpression() {
        String toReturn = this.query.replace("<%TABLE%>", this.table.getTable()).replace("<%COLNAME%>", this.column.getAttribute()).replace("<%TYPE%>", this.newType.getTypeDefinition());
        if (this.newType.getType().getSpecificFunction() != null && this.useCast) {
            return toReturn.replace("<%USING%>", "USING " + this.newType.getType().getSpecificFunction() + "(" + this.column.getAttribute() + ")");
        }
        return toReturn.replace("<%USING%>", "");
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumn(SimpleAttribute column) {
        this.column = column;
    }

    public void setNewType(Type newType) {
        this.newType = newType;
    }

    public void setUseCast(boolean useCast) {
        this.useCast = useCast;
    }
}

