/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dbinterface.h2.queries;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Map;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Insert;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.types.Cast;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.dbinterface.h2.queries.AbstractUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertValues
extends AbstractUpdate
implements Insert {
    private String query = " INSERT INTO <%NAME%> (<%FIELDS%>) VALUES (<%ENTRIES%>)";
    private static final Logger logger = LoggerFactory.getLogger(InsertValues.class);
    private SimpleTable table;
    private PreparedStatement preparedStatement;
    private Object[] insertValues;

    public void setTable(SimpleTable table) {
        this.table = table;
    }

    @Override
    public SimpleTable execute(DBSession session) throws Exception {
        if (this.insertValues.length != this.table.getFieldsMapping().values().size()) {
            throw new Exception("the number of values does not correspond to the table entries(" + this.insertValues.length + "!=" + this.table.getFieldsMapping().values().size() + ")");
        }
        String entries = "";
        String fields = "";
        ArrayList typeList = new ArrayList();
        ArrayList<Object> valuesList = new ArrayList<Object>();
        int k = 0;
        for (Map.Entry entry : this.table.getFieldsMapping().entrySet()) {
            if (!((Type)entry.getValue()).isAutoincrement()) {
                fields = fields + (String)entry.getKey() + ",";
                entries = entries + "?,";
                typeList.add(entry.getValue());
                valuesList.add(this.insertValues[k]);
            }
            ++k;
        }
        fields = fields.substring(0, fields.length() - 1);
        entries = entries.substring(0, entries.length() - 1);
        this.preparedStatement = session.getPreparedStatement(this.query.replace("<%NAME%>", this.table.getTableName()).replace("<%ENTRIES%>", entries).replace("<%FIELDS%>", fields));
        for (int i = 1; i <= typeList.size(); ++i) {
            Object value = valuesList.get(i - 1) != null && valuesList.get(i - 1).getClass().getName().compareTo(((Type)typeList.get(i - 1)).getType().getJavaClass().getName()) != 0 ? Cast.apply(valuesList.get(i - 1).getClass(), (Type)((Type)typeList.get(i - 1)), valuesList.get(i - 1)) : valuesList.get(i - 1);
            if (value == null) {
                this.preparedStatement.setNull(i, 0);
                continue;
            }
            Method m = PreparedStatement.class.getMethod(((Type)typeList.get(i - 1)).getType().getReflectionMethodSet(), Integer.TYPE, ((Type)typeList.get(i - 1)).getType().getJavaClass());
            try {
                m.invoke((Object)this.preparedStatement, i, value);
                continue;
            }
            catch (InvocationTargetException e) {
                logger.error("error inserting value");
            }
        }
        this.preparedStatement.execute();
        return this.table;
    }

    @Override
    public String getExpression() {
        return this.preparedStatement.toString();
    }

    public void setInsertValues(Object ... insertValue) {
        this.insertValues = insertValue;
    }
}

