/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.DefaultFileContent;
import org.apache.commons.vfs2.provider.SmpFileSystem;
import org.apache.commons.vfs2.provider.UriParser;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;

public class SmpFileObject
extends AbstractFileObject {
    private final Log log = LogFactory.getLog(SmpFileObject.class);
    private final SmpFileSystem smpFs;
    private final String relPath;
    private final String wholeLink;

    protected SmpFileObject(AbstractFileName name, SmpFileSystem fileSystem, FileName rootName) throws FileSystemException {
        super(name, (AbstractFileSystem)fileSystem);
        this.smpFs = fileSystem;
        String relPath = UriParser.decode((String)rootName.getRelativeName((FileName)name));
        this.wholeLink = name.toString();
        this.relPath = ".".equals(relPath) ? null : relPath;
        try {
            this.doGetContentSize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public URL getURL() throws FileSystemException {
        Handler.activateProtocol();
        URL returnedUrl = null;
        try {
            returnedUrl = new URL(this.wholeLink);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return returnedUrl;
    }

    protected FileType doGetType() throws Exception {
        return FileType.FILE;
    }

    protected String[] doListChildren() throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doGetContentSize() throws Exception {
        URLConnection conn = null;
        try {
            this.log.debug((Object)("doGetContentSize - connecting to " + this.wholeLink));
            conn = new URL(this.wholeLink).openConnection();
            conn.getInputStream();
            long len = conn.getContentLength();
            this.log.debug((Object)("doGetContentSize - content length " + len));
            long l = len;
            return l;
        }
        catch (Exception e) {
            long l = -1L;
            return l;
        }
        finally {
            if (conn != null) {
                conn.getInputStream().close();
            }
        }
    }

    public void sleepFiveSec() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected FileContent doCreateFileContent() throws FileSystemException {
        return new DefaultFileContent((AbstractFileObject)this, this.getFileContentInfoFactory());
    }

    protected InputStream doGetInputStream() throws Exception {
        Handler.activateProtocol();
        URL returnedUrl = null;
        try {
            returnedUrl = new URL(this.wholeLink);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        URLConnection uc = null;
        InputStream in = null;
        try {
            uc = returnedUrl.openConnection();
            in = uc.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return in;
    }

    protected OutputStream doGetOutputStream(boolean append) throws Exception {
        Handler.activateProtocol();
        URL returnedUrl = null;
        try {
            returnedUrl = new URL(this.wholeLink);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        URLConnection uc = null;
        OutputStream out = null;
        try {
            uc = returnedUrl.openConnection();
            out = uc.getOutputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out;
    }
}

