/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ensemble.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.test.regression.Regressor;

public class Workspace {
    private String executionId;
    private String executionsRoot;
    private String inputSubpath;
    private String binariesSubpath;
    private String outputSubpath;

    public Workspace(String executionId) {
        this.executionId = executionId;
    }

    private File getExecutionsRoot() {
        AlgorithmConfiguration config = Regressor.getConfig();
        return new File(config.getConfigPath());
    }

    public void setExecutionsRoot(String executionsRoot) {
        this.executionsRoot = executionsRoot;
    }

    public File getRoot() {
        return new File(this.executionsRoot, this.executionId);
    }

    public File getInputLocation() {
        return new File(this.getRoot(), this.inputSubpath);
    }

    public File getBinariesLocation() {
        return new File(this.getRoot(), this.binariesSubpath);
    }

    public File getOutputLocation() {
        return new File(this.getRoot(), this.outputSubpath);
    }

    public void destroy() throws IOException {
        AnalysisLogger.getLogger().info((Object)("Removing execution directory '" + this.getRoot() + "'"));
        FileUtils.deleteDirectory((File)this.getRoot());
        AnalysisLogger.getLogger().info((Object)"Removed.");
    }

    public void ensureStructureExists() {
        this.ensureDirectory(this.getExecutionsRoot());
        this.ensureDirectory(this.getRoot());
        this.ensureDirectory(this.getInputLocation());
        this.ensureDirectory(this.getBinariesLocation());
        this.ensureDirectory(this.getOutputLocation());
    }

    private void ensureDirectory(File dir) {
        AnalysisLogger.getLogger().debug((Object)("Creating directory: '" + dir.getAbsolutePath() + "'"));
        if (!dir.exists()) {
            boolean result = false;
            try {
                dir.mkdir();
                result = true;
            }
            catch (SecurityException se) {
                AnalysisLogger.getLogger().error((Object)("Unable to create directory '" + dir.getAbsolutePath() + "'"));
            }
            if (result) {
                AnalysisLogger.getLogger().debug((Object)("Created directory '" + dir.getAbsolutePath() + "'"));
            }
        } else {
            AnalysisLogger.getLogger().debug((Object)("Directory '" + dir.getAbsolutePath() + "' already exists. Skiping."));
        }
    }

    public void setBinariesLocation(String binariesLocation) {
        this.binariesSubpath = binariesLocation;
    }

    public void setOutputLocation(String outputLocation) {
        this.outputSubpath = outputLocation;
    }

    public void setInputLocation(String inputLocation) {
        this.inputSubpath = inputLocation;
    }

    public void exec(String command, String subpath, String logfilename) {
        AnalysisLogger.getLogger().info((Object)String.format("Executing command '%s'", command));
        ProcessBuilder builder = new ProcessBuilder(command.split(" "));
        if (subpath == null) {
            builder.directory(this.getRoot());
        } else {
            builder.directory(new File(this.getRoot(), subpath));
        }
        if (logfilename != null) {
            File logFile = new File(this.getRoot(), logfilename);
            builder.redirectErrorStream(true);
            builder.redirectOutput(logFile);
            AnalysisLogger.getLogger().info((Object)String.format("  writing stdout and stderr to '%s'", logFile.getPath()));
        }
        try {
            Process process = builder.start();
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            AnalysisLogger.getLogger().error((Object)e);
        }
        AnalysisLogger.getLogger().info((Object)"Execution complete.");
    }
}

