/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend.operation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.gcube.contentmanagement.blobstorage.resource.MemoryType;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Move;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoIOManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoOperationManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanagement.blobstorage.transport.backend.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveOperator
extends Move {
    Logger logger = LoggerFactory.getLogger(MoveOperator.class);

    public MoveOperator(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    @Override
    public String execute(MongoIOManager mongoPrimaryInstance, MemoryType memoryType, MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        String source = sourcePath;
        String destination = destinationPath;
        resource.setLocalPath(sourcePath);
        String dir = resource.getRemoteDir();
        String name = resource.getName();
        String destinationId = null;
        String sourceId = null;
        this.logger.info("move operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        this.logger.debug("MOVE OPERATION operation defined: " + (Object)((Object)resource.getOperationDefinition().getOperation()));
        if (source != null && !source.isEmpty() && destination != null && !destination.isEmpty()) {
            BasicDBObject sourcePathMetaCollection = mongoPrimaryInstance.findMetaCollectionObject(source);
            if (sourcePathMetaCollection != null) {
                sourceId = sourcePathMetaCollection.get("_id").toString();
                sourcePathMetaCollection = this.setCommonFields(sourcePathMetaCollection, resource, OperationDefinition.OPERATION.MOVE);
                BasicDBObject queryDestPath = new BasicDBObject();
                queryDestPath.put("filename", destinationPath);
                DBCollection metaCollectionInstance = null;
                metaCollectionInstance = memoryType != MemoryType.VOLATILE ? mongoPrimaryInstance.getMetaDataCollection(mongoPrimaryInstance.getConnectionDB(MongoOperationManager.getPrimaryCollectionName(), true)) : mongoPrimaryInstance.getMetaDataCollection(mongoPrimaryInstance.getConnectionDB(MongoOperationManager.getPrimaryCollectionName(), false));
                DBObject destPathMetaCollection = mongoPrimaryInstance.executeQuery(metaCollectionInstance, queryDestPath);
                BasicDBObject querySourcePath = new BasicDBObject();
                querySourcePath.put("filename", sourcePath);
                BasicDBObject updateQuery = new BasicDBObject();
                updateQuery.put("$set", sourcePathMetaCollection);
                if (memoryType != MemoryType.VOLATILE) {
                    metaCollectionInstance.update(querySourcePath, updateQuery, false, true, MongoIOManager.DEFAULT_WRITE_TYPE);
                } else {
                    metaCollectionInstance.update(querySourcePath, updateQuery, false, true);
                }
                if (destPathMetaCollection != null) {
                    destinationId = destPathMetaCollection.get("_id").toString();
                }
                if (destPathMetaCollection != null && destinationId != null && !destinationId.equals(sourceId)) {
                    mongoPrimaryInstance.printObject(destPathMetaCollection);
                    destinationId = destPathMetaCollection.get("_id").toString();
                    this.logger.info("file in destination path already present with id : " + destinationId);
                    GridFS gfs = mongoPrimaryInstance.getGfs(MongoOperationManager.getPrimaryCollectionName(), true);
                    GridFSDBFile fNewFSPath = gfs.findOne(queryDestPath);
                    mongoPrimaryInstance.checkAndRemove(fNewFSPath, resource);
                    this.logger.debug("Changing filename metadata from:" + sourcePathMetaCollection.get("filename") + "\n  to: " + destinationPath);
                    this.logger.debug("original objects:\n  ");
                    this.logger.debug("source object: ");
                    mongoPrimaryInstance.printObject(sourcePathMetaCollection);
                    this.logger.info("destination object: ");
                    mongoPrimaryInstance.printObject(destPathMetaCollection);
                    mongoPrimaryInstance.buildDirTree(mongoPrimaryInstance.getMetaDataCollection(mongoPrimaryInstance.getConnectionDB(MongoOperationManager.getPrimaryCollectionName(), true)), dir);
                    sourcePathMetaCollection = new BasicDBObject();
                    sourcePathMetaCollection.put("$set", new BasicDBObject().append("dir", dir).append("filename", destinationPath).append("name", name).append("owner", resource.getOwner()));
                    this.logger.info("new object merged ");
                    mongoPrimaryInstance.printObject(sourcePathMetaCollection);
                    if (memoryType != MemoryType.VOLATILE) {
                        metaCollectionInstance.update(querySourcePath, sourcePathMetaCollection, false, true, MongoIOManager.DEFAULT_WRITE_TYPE);
                    } else {
                        metaCollectionInstance.update(querySourcePath, sourcePathMetaCollection, false, true);
                    }
                    this.logger.info("update metadata done ");
                    this.logger.info("check update ");
                    DBObject newDestPathMetaCollection = mongoPrimaryInstance.executeQuery(metaCollectionInstance, queryDestPath);
                    mongoPrimaryInstance.printObject(newDestPathMetaCollection);
                } else if (destinationId != null && destinationId.equals(sourceId)) {
                    this.logger.warn("the destination id and the source id are the same id. skip operation. ");
                } else {
                    queryDestPath = new BasicDBObject();
                    queryDestPath.put("dir", destination);
                    DBObject folder = metaCollectionInstance.findOne(queryDestPath);
                    if (folder != null) {
                        destination = this.appendFileSeparator(destination);
                        sourcePathMetaCollection = mongoPrimaryInstance.setGenericMoveProperties(resource, destination + name, destination, name, sourcePathMetaCollection);
                        destinationId = sourcePathMetaCollection.get("_id").toString();
                        mongoPrimaryInstance.buildDirTree(metaCollectionInstance, destination);
                    } else {
                        if (destination.lastIndexOf("/") == destination.length() - 1) {
                            sourcePathMetaCollection = mongoPrimaryInstance.setGenericMoveProperties(resource, destination + name, destination, name, sourcePathMetaCollection);
                            destinationId = sourcePathMetaCollection.get("_id").toString();
                            mongoPrimaryInstance.buildDirTree(metaCollectionInstance, destination);
                        } else {
                            String newName = destination.substring(destination.lastIndexOf("/") + 1);
                            sourcePathMetaCollection = mongoPrimaryInstance.setGenericMoveProperties(resource, destination, dir, newName, sourcePathMetaCollection);
                            destinationId = sourcePathMetaCollection.get("_id").toString();
                            mongoPrimaryInstance.buildDirTree(metaCollectionInstance, dir);
                        }
                        queryDestPath = new BasicDBObject();
                        queryDestPath.put("filename", sourcePath);
                        updateQuery = new BasicDBObject();
                        updateQuery.put("$set", sourcePathMetaCollection);
                        if (memoryType != MemoryType.VOLATILE) {
                            metaCollectionInstance.update(queryDestPath, updateQuery, true, true, MongoIOManager.DEFAULT_WRITE_TYPE);
                        } else {
                            metaCollectionInstance.update(queryDestPath, updateQuery, true, true);
                        }
                    }
                }
                mongoPrimaryInstance.close();
                return destinationId;
            }
            mongoPrimaryInstance.close();
            throw new RemoteBackendException(" the source path is wrong. There isn't a file at this path: " + source);
        }
        mongoPrimaryInstance.close();
        throw new IllegalArgumentException("parameters not completed, source: " + source + ", destination: " + destination);
    }

    private BasicDBObject setCommonFields(BasicDBObject f, MyFile resource, OperationDefinition.OPERATION op) {
        String owner = resource.getOwner();
        if (op == null) {
            op = resource.getOperationDefinition().getOperation();
        }
        this.logger.info("set last operation: " + (Object)((Object)op));
        String from = null;
        if (op.toString().equalsIgnoreCase(OperationDefinition.OPERATION.MOVE.toString())) {
            from = resource.getLocalPath();
        }
        String address = null;
        try {
            address = InetAddress.getLocalHost().getCanonicalHostName().toString();
            f.put("callerIP", address);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (from == null) {
            f.append("lastAccess", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z")).append("lastUser", owner).append("lastOperation", op.toString()).append("callerIP", address);
        } else {
            f.append("lastAccess", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z")).append("lastUser", owner).append("lastOperation", op.toString()).append("callerIP", address).append("from", from);
        }
        return f;
    }
}

