/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.impl;

import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.service.impl.Resource;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class RemoteResourceDestination
extends Resource {
    public RemoteResourceDestination(MyFile file, ServiceEngine engine) {
        super(file, engine);
    }

    public String to(String path) throws RemoteBackendException {
        this.logger.info("file gCube parameter before: " + (Object)((Object)this.file.getGcubeAccessType()) + " " + this.file.getGcubeScope());
        this.file = this.setGenericProperties(this.engine.getContext(), this.engine.owner, path, "remote");
        this.file.setRemotePath(path);
        this.file.setOwner(this.engine.owner);
        this.setMyFile(this.file);
        if (path != null && ObjectId.isValid(path)) {
            this.getMyFile().setRemoteResource(OperationDefinition.REMOTE_RESOURCE.ID);
            this.getMyFile().setId2(path);
        } else {
            this.getMyFile().setRemoteResource(OperationDefinition.REMOTE_RESOURCE.PATH);
        }
        this.engine.service.setResource(this.getMyFile());
        String bucketName = null;
        this.logger.info("file gCube parameter after: " + (Object)((Object)this.file.getGcubeAccessType()) + " " + this.file.getGcubeScope());
        bucketName = this.getRemoteObject(this.getMyFile(), this.engine.primaryBackend, this.engine.volatileBackend).toString();
        return bucketName;
    }
}

