/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.impl;

import com.mongodb.MongoException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.resource.StorageObject;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.DirectoryBucket;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.DirectoryEntity;
import org.gcube.contentmanagement.blobstorage.service.impl.Resource;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class RemoteResource
extends Resource {
    private static final String BACKEND_STRING_SEPARATOR = "%";

    public RemoteResource(MyFile file, ServiceEngine engine) {
        super(file, engine);
        this.logger.info("file gCube parameter costructor: " + file.getGcubeAccessType() + " " + file.getGcubeScope());
    }

    public String RFile(String path) throws RemoteBackendException {
        this.logger.info("file gCube parameter before: " + this.file.getGcubeAccessType() + " " + this.file.getGcubeScope());
        this.file = this.setGenericProperties(this.engine.getContext(), this.engine.owner, path, "remote");
        this.file.setRemotePath(path);
        this.file.setOwner(this.engine.owner);
        this.getMyFile().setRemoteResource(OperationDefinition.REMOTE_RESOURCE.PATH);
        this.setMyFile(this.file);
        this.engine.service.setResource(this.getMyFile());
        String id = null;
        this.logger.info("file gCube parameter after: " + this.file.getGcubeAccessType() + " " + this.file.getGcubeScope());
        try {
            if (this.file.getInputStream() != null || this.file.getOutputStream() != null || this.file.getLocalPath() != null || this.file.getRemotePath() != null) {
                id = (String)this.engine.service.startOperation(this.file, this.file.getRemotePath(), this.engine.owner, this.engine.server, false, this.engine.getContext(), this.engine.isReplaceOption());
            } else {
                this.logger.error("parameters incompatible ");
            }
        }
        catch (Exception t) {
            this.logger.error("get()", t.getCause());
            t.printStackTrace();
            throw new RemoteBackendException(" Error in " + this.engine.currentOperation + " operation: " + t.getMessage(), t.getCause());
        }
        return id;
    }

    public String RFile(String path, boolean backendTypeReturned) throws RemoteBackendException {
        this.logger.info("file gCube parameter before: " + this.file.getGcubeAccessType() + " " + this.file.getGcubeScope());
        this.file = this.setGenericProperties(this.engine.getContext(), this.engine.owner, path, "remote");
        this.file.setRemotePath(path);
        this.file.setOwner(this.engine.owner);
        this.getMyFile().setRemoteResource(OperationDefinition.REMOTE_RESOURCE.PATH);
        this.setMyFile(this.file);
        this.engine.service.setResource(this.getMyFile());
        String id = null;
        this.logger.info("file gCube parameter after: " + this.file.getGcubeAccessType() + " " + this.file.getGcubeScope());
        try {
            if (this.file.getInputStream() != null || this.file.getOutputStream() != null || this.file.getLocalPath() != null || this.file.getRemotePath() != null) {
                id = (String)this.engine.service.startOperation(this.file, this.file.getRemotePath(), this.engine.owner, this.engine.server, false, this.engine.getContext(), this.engine.isReplaceOption());
            } else {
                this.logger.error("parameters incompatible ");
            }
        }
        catch (Throwable t) {
            this.logger.error("get()", t.getCause());
            throw new RemoteBackendException(" Error in " + this.engine.currentOperation + " operation: " + t.getMessage(), t.getCause());
        }
        if (backendTypeReturned) {
            return id + BACKEND_STRING_SEPARATOR + this.engine.getBackendType();
        }
        return id;
    }

    @Deprecated
    public String RFileById(String id) throws RemoteBackendException {
        this.getMyFile().setRemoteResource(OperationDefinition.REMOTE_RESOURCE.ID);
        this.getMyFile().setOwner(this.engine.owner);
        this.engine.service.setResource(this.getMyFile());
        String idReturned = null;
        try {
            if (!(this.engine.getCurrentOperation().equalsIgnoreCase("getUrl") || this.engine.getCurrentOperation().equalsIgnoreCase("upload") || this.engine.getCurrentOperation().equalsIgnoreCase("download") || this.engine.getCurrentOperation().equalsIgnoreCase("remove") || this.engine.getCurrentOperation().equalsIgnoreCase("unlock") || this.engine.getCurrentOperation().equalsIgnoreCase("lock"))) {
                throw new IllegalArgumentException("Input Parameters incompatible");
            }
            idReturned = (String)this.engine.service.startOperation(this.getMyFile(), id, this.engine.owner, this.engine.server, false, "", this.engine.isReplaceOption());
        }
        catch (Throwable t) {
            this.logger.error("get()", t.getCause());
            throw new RemoteBackendException(" Error in " + this.engine.currentOperation + " operation: " + t.getMessage(), t.getCause());
        }
        return idReturned;
    }

    @Deprecated
    public String RFileById(String id, boolean backendTypeReturned) throws RemoteBackendException {
        this.getMyFile().setRemoteResource(OperationDefinition.REMOTE_RESOURCE.ID);
        this.getMyFile().setOwner(this.engine.owner);
        this.engine.service.setResource(this.getMyFile());
        String idReturned = null;
        try {
            if (!(this.engine.getCurrentOperation().equalsIgnoreCase("getUrl") || this.engine.getCurrentOperation().equalsIgnoreCase("upload") || this.engine.getCurrentOperation().equalsIgnoreCase("download") || this.engine.getCurrentOperation().equalsIgnoreCase("remove") || this.engine.getCurrentOperation().equalsIgnoreCase("unlock") || this.engine.getCurrentOperation().equalsIgnoreCase("lock"))) {
                throw new IllegalArgumentException("Input Parameters incompatible");
            }
            idReturned = (String)this.engine.service.startOperation(this.getMyFile(), id, this.engine.owner, this.engine.server, false, "", this.engine.isReplaceOption());
        }
        catch (Throwable t) {
            this.logger.error("get()", t.getCause());
            throw new RemoteBackendException(" Error in " + this.engine.currentOperation + " operation ", t.getCause());
        }
        if (backendTypeReturned) {
            return id + BACKEND_STRING_SEPARATOR + this.engine.getBackendType();
        }
        return idReturned;
    }

    public List<StorageObject> RDir(String dir) {
        this.getMyFile().setRemoteResource(OperationDefinition.REMOTE_RESOURCE.DIR);
        this.getMyFile().setOwner(this.engine.owner);
        if (this.engine.getCurrentOperation().equalsIgnoreCase("showdir")) {
            dir = new BucketCoding().bucketDirCoding(dir, this.engine.getContext());
            TransportManagerFactory tmf = new TransportManagerFactory(this.engine.server, this.engine.getBackendUser(), this.engine.getBackendPassword());
            TransportManager tm = tmf.getTransport(this.engine.getBackendType());
            Map mapDirs = null;
            try {
                mapDirs = tm.getValues(this.getMyFile(), dir, DirectoryEntity.class);
            }
            catch (MongoException e) {
                e.printStackTrace();
            }
            List dirs = null;
            if (mapDirs != null) {
                dirs = this.engine.addObjectsDirBucket(mapDirs);
            }
            if (dirs == null) {
                dirs = Collections.emptyList();
            }
            return dirs;
        }
        if (this.engine.getCurrentOperation().equalsIgnoreCase("removedir")) {
            if (dir != null && this.engine.owner != null) {
                DirectoryBucket dirBuc = new DirectoryBucket(this.engine.server, this.engine.getBackendUser(), this.engine.getBackendPassword(), dir, this.engine.owner);
                String bucketName = null;
                if (!"mongo".equalsIgnoreCase("mongo")) {
                    bucketName = dirBuc.removeDirBucket(this.getMyFile(), dir, this.engine.getContext(), this.engine.getBackendType());
                } else {
                    TransportManagerFactory tmf = new TransportManagerFactory(this.engine.server, this.engine.getBackendUser(), this.engine.getBackendPassword());
                    TransportManager tm = tmf.getTransport("mongo");
                    dir = new BucketCoding().bucketFileCoding(dir, this.engine.getContext());
                    try {
                        tm.removeDir(dir, this.getMyFile());
                    }
                    catch (UnknownHostException e) {
                        e.printStackTrace();
                    }
                    catch (MongoException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                this.logger.error("REMOVE Operation not valid:\n\t specify a valid bucketID or an author and a path on the cluster ");
            }
            return null;
        }
        throw new IllegalArgumentException("The method RDir is not applicable for the operation selected");
    }
}

