/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.impl;

import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.service.impl.Resource;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class RemoteResourceInfo
extends Resource {
    private String serviceName;
    private String ownerGcube;
    private String gcubeScope;
    private String gcubeAccessType;
    private String gcubeMemoryType;

    public RemoteResourceInfo(MyFile file, ServiceEngine engine) {
        super(file, engine);
    }

    public long RFile(String path) throws RemoteBackendException {
        this.file = this.setGenericProperties(this.engine.getContext(), this.engine.owner, path, "remote");
        this.file.setRemotePath(path);
        this.file.setOwner(this.engine.owner);
        this.getMyFile().setRemoteResource(OperationDefinition.REMOTE_RESOURCE.PATH);
        this.setMyFile(this.file);
        this.engine.service.setResource(this.getMyFile());
        Object info = null;
        try {
            if (this.file.getInputStream() != null || this.file.getOutputStream() != null || this.file.getLocalPath() != null || this.file.getRemotePath() != null) {
                info = (String)this.engine.service.startOperation(this.file, this.file.getRemotePath(), this.engine.owner, this.engine.server, false, this.engine.getContext(), this.engine.isReplaceOption());
            } else {
                this.logger.error("parameters incompatible ");
            }
        }
        catch (Throwable t) {
            this.logger.error("get()", t.getCause());
            throw new RemoteBackendException(" Error in " + this.engine.currentOperation + " operation: " + t.getMessage(), t.getCause());
        }
        if (info != null) {
            return Long.parseLong(info.toString());
        }
        return -1L;
    }

    public long RFileById(String id) throws RemoteBackendException {
        this.getMyFile().setRemoteResource(OperationDefinition.REMOTE_RESOURCE.ID);
        this.engine.service.setResource(this.getMyFile());
        Object info = null;
        try {
            if (!this.engine.getCurrentOperation().equalsIgnoreCase("download")) {
                throw new IllegalArgumentException("Input Parameters incompatible");
            }
            info = this.engine.service.startOperation(this.getMyFile(), id, this.engine.owner, this.engine.server, false, "", this.engine.isReplaceOption());
        }
        catch (Throwable t) {
            this.logger.error("get()", t.getCause());
            throw new RemoteBackendException(" Error in " + this.engine.currentOperation + " operation: " + t.getMessage(), t.getCause());
        }
        if (info != null) {
            return Long.parseLong(info.toString());
        }
        return -1L;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getOwnerGcube() {
        return this.ownerGcube;
    }

    public void setOwnerGcube(String ownerGcube) {
        this.ownerGcube = ownerGcube;
    }

    public String getGcubeScope() {
        return this.gcubeScope;
    }

    public void setGcubeScope(String gcubeScope) {
        this.gcubeScope = gcubeScope;
    }

    public String getGcubeAccessType() {
        return this.gcubeAccessType;
    }

    public void setGcubeAccessType(String gcubeAccessType) {
        this.gcubeAccessType = gcubeAccessType;
    }

    public String getGcubeMemoryType() {
        return this.gcubeMemoryType;
    }

    public void setGcubeMemoryType(String gcubeMemoryType) {
        this.gcubeMemoryType = gcubeMemoryType;
    }
}

