/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoOptions;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoURI {
    public static final String MONGODB_PREFIX = "mongodb://";
    final String _username;
    final char[] _password;
    final List<String> _hosts;
    final String _database;
    final String _collection;
    final MongoOptions _options = new MongoOptions();
    final String _uri;
    static final Logger LOGGER = Logger.getLogger("com.mongodb.MongoURI");

    public MongoURI(String uri) {
        String optionsPart;
        String nsPart;
        String serverPart;
        this._uri = uri;
        if (!uri.startsWith(MONGODB_PREFIX)) {
            throw new IllegalArgumentException("uri needs to start with mongodb://");
        }
        int idx = (uri = uri.substring(MONGODB_PREFIX.length())).lastIndexOf("/");
        if (idx < 0) {
            serverPart = uri;
            nsPart = null;
            optionsPart = null;
        } else {
            serverPart = uri.substring(0, idx);
            nsPart = uri.substring(idx + 1);
            if ((idx = nsPart.indexOf("?")) >= 0) {
                optionsPart = nsPart.substring(idx + 1);
                nsPart = nsPart.substring(0, idx);
            } else {
                optionsPart = null;
            }
        }
        LinkedList<String> all = new LinkedList<String>();
        int idx2 = serverPart.indexOf("@");
        if (idx2 > 0) {
            String authPart = serverPart.substring(0, idx2);
            serverPart = serverPart.substring(idx2 + 1);
            idx2 = authPart.indexOf(":");
            this._username = authPart.substring(0, idx2);
            this._password = authPart.substring(idx2 + 1).toCharArray();
        } else {
            this._username = null;
            this._password = null;
        }
        for (String s : serverPart.split(",")) {
            all.add(s);
        }
        this._hosts = Collections.unmodifiableList(all);
        if (nsPart != null) {
            idx = nsPart.indexOf(".");
            if (idx < 0) {
                this._database = nsPart;
                this._collection = null;
            } else {
                this._database = nsPart.substring(0, idx);
                this._collection = nsPart.substring(idx + 1);
            }
        } else {
            this._database = null;
            this._collection = null;
        }
        if (optionsPart != null && optionsPart.length() > 0) {
            this.parseOptions(optionsPart);
        }
    }

    private void parseOptions(String optionsPart) {
        for (String _part : optionsPart.split("&|;")) {
            int idx = _part.indexOf("=");
            if (idx < 0) continue;
            String key = _part.substring(0, idx).toLowerCase();
            String value = _part.substring(idx + 1);
            if (key.equals("maxpoolsize")) {
                this._options.connectionsPerHost = Integer.parseInt(value);
                continue;
            }
            if (key.equals("minpoolsize")) {
                LOGGER.warning("Currently No support in Java driver for Min Pool Size.");
                continue;
            }
            if (key.equals("waitqueuemultiple")) {
                this._options.threadsAllowedToBlockForConnectionMultiplier = Integer.parseInt(value);
                continue;
            }
            if (key.equals("waitqueuetimeoutms")) {
                this._options.maxWaitTime = Integer.parseInt(value);
                continue;
            }
            if (key.equals("connecttimeoutms")) {
                this._options.connectTimeout = Integer.parseInt(value);
                continue;
            }
            if (key.equals("sockettimeoutms")) {
                this._options.socketTimeout = Integer.parseInt(value);
                continue;
            }
            if (key.equals("autoconnectretry")) {
                this._options.autoConnectRetry = this._parseBoolean(value);
                continue;
            }
            if (key.equals("slaveok")) {
                this._options.slaveOk = this._parseBoolean(value);
                continue;
            }
            if (key.equals("safe")) {
                this._options.safe = this._parseBoolean(value);
                continue;
            }
            if (key.equals("w")) {
                this._options.w = Integer.parseInt(value);
                continue;
            }
            if (key.equals("wtimeout")) {
                this._options.wtimeout = Integer.parseInt(value);
                continue;
            }
            if (key.equals("fsync")) {
                this._options.fsync = this._parseBoolean(value);
                continue;
            }
            LOGGER.warning("Unknown or Unsupported Option '" + value + "'");
        }
    }

    boolean _parseBoolean(String _in) {
        String in = _in.trim();
        return in != null && !in.isEmpty() && (in.equals("1") || in.toLowerCase().equals("true") || in.toLowerCase().equals("yes"));
    }

    public String getUsername() {
        return this._username;
    }

    public char[] getPassword() {
        return this._password;
    }

    public List<String> getHosts() {
        return this._hosts;
    }

    public String getDatabase() {
        return this._database;
    }

    public String getCollection() {
        return this._collection;
    }

    public MongoOptions getOptions() {
        return this._options;
    }

    public Mongo connect() throws MongoException, UnknownHostException {
        return new Mongo(this);
    }

    public DB connectDB() throws MongoException, UnknownHostException {
        return this.connect().getDB(this._database);
    }

    public DB connectDB(Mongo m) {
        return m.getDB(this._database);
    }

    public DBCollection connectCollection(DB db) {
        return db.getCollection(this._collection);
    }

    public DBCollection connectCollection(Mongo m) {
        return this.connectDB(m).getCollection(this._collection);
    }

    public String toString() {
        return this._uri;
    }
}

