/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.impl;

import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.service.impl.Resource;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class RemoteResourceComplexInfo
extends Resource {
    private String serviceName;
    private String serviceClass;
    private String ownerGcube;
    private String gcubeScope;
    private String gcubeAccessType;
    private String gcubeMemoryType;

    public RemoteResourceComplexInfo(MyFile file, ServiceEngine engine) {
        super(file, engine);
    }

    public MyFile RFile(String path) throws RemoteBackendException {
        this.setMyFile(this.setGenericProperties(this.engine.getContext(), this.engine.owner, path, "remote"));
        this.getMyFile().setRemotePath(path);
        this.getMyFile().setRemoteResource(OperationDefinition.REMOTE_RESOURCE.PATH);
        this.engine.service.setResource(this.getMyFile());
        try {
            if (this.file.getInputStream() != null || this.file.getOutputStream() != null || this.file.getLocalPath() != null || this.file.getRemotePath() != null) {
                this.engine.service.startOperation(this.file, this.file.getRemotePath(), this.engine.owner, this.engine.server, false, this.engine.getContext(), this.engine.isReplaceOption());
            } else {
                this.logger.error("parameters incompatible ");
            }
        }
        catch (Throwable t) {
            this.logger.error("get()", t.getCause());
            throw new RemoteBackendException(" Error in " + this.engine.currentOperation + " operation ", t.getCause());
        }
        return this.getMyFile();
    }
}

