/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.FileWriter2;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.IOServiceProviderWriter;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.iosp.netcdf3.N3header;
import ucar.nc2.iosp.netcdf3.N3iosp;
import ucar.nc2.iosp.netcdf3.N3raf;
import ucar.nc2.write.Nc4Chunking;
import ucar.unidata.io.RandomAccessFile;

public class NetcdfFileWriter
implements Closeable {
    private static Logger log = LoggerFactory.getLogger(NetcdfFileWriter.class);
    private static Set<DataType> validN3types = EnumSet.of(DataType.BYTE, new DataType[]{DataType.CHAR, DataType.SHORT, DataType.INT, DataType.DOUBLE, DataType.FLOAT});
    private final String location;
    private IOServiceProviderWriter spiw;
    private boolean defineMode;
    private NetcdfFile ncfile;
    private Version version;
    private boolean isNewFile;
    private boolean isLargeFile;
    private boolean fill;
    private int extraHeader;
    private long preallocateSize;
    private Map<String, String> varRenameMap = new HashMap<String, String>();

    public static NetcdfFileWriter openExisting(String location) throws IOException {
        return new NetcdfFileWriter(null, location, true, null);
    }

    public static NetcdfFileWriter createNew(Version version, String location) throws IOException {
        return new NetcdfFileWriter(version, location, false, null);
    }

    public static NetcdfFileWriter createNew(Version version, String location, Nc4Chunking chunker) throws IOException {
        return new NetcdfFileWriter(version, location, false, chunker);
    }

    protected NetcdfFileWriter(Version version, String location, boolean isExisting, Nc4Chunking chunker) throws IOException {
        RandomAccessFile raf = null;
        if (isExisting) {
            raf = new RandomAccessFile(location, "rw");
            try {
                if (H5header.isValidFile(raf)) {
                    if (version != null && !version.isNetdf4format()) {
                        throw new IllegalArgumentException(location + " must be netcdf-4 file");
                    }
                    version = Version.netcdf4;
                }
                if (N3header.isValidFile(raf)) {
                    if (version != null && version != Version.netcdf3) {
                        throw new IllegalArgumentException(location + " must be netcdf-3 file");
                    }
                    version = Version.netcdf3;
                }
                raf.close();
                throw new IllegalArgumentException(location + " must be netcdf-3 or netcdf-4 file");
            }
            catch (IOException ioe) {
                raf.close();
                throw ioe;
            }
        } else {
            if (version == null) {
                version = Version.netcdf3;
            }
            this.isNewFile = true;
        }
        this.version = version;
        this.location = location;
        if (version.useJniIosp()) {
            IOServiceProviderWriter spi;
            try {
                Class<?> iospClass = this.getClass().getClassLoader().loadClass("ucar.nc2.jni.netcdf.Nc4Iosp");
                Constructor<?> ctor = iospClass.getConstructor(Version.class);
                spi = (IOServiceProviderWriter)ctor.newInstance(new Object[]{version});
                Method method = iospClass.getMethod("setChunker", Nc4Chunking.class);
                method.invoke((Object)spi, chunker);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("ucar.nc2.jni.netcdf.Nc4Iosp failed, cannot use version " + (Object)((Object)version), e);
            }
            this.spiw = spi;
        } else {
            this.spiw = new N3raf();
        }
        this.ncfile = new NetcdfFile(this.spiw, location);
        if (isExisting) {
            this.spiw.openForWriting(raf, this.ncfile, null);
        } else {
            this.defineMode = true;
        }
    }

    public void setFill(boolean fill) {
        this.fill = fill;
        this.spiw.setFill(fill);
    }

    public void setLength(long size) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        this.preallocateSize = size;
    }

    public void setLargeFile(boolean isLargeFile) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        this.isLargeFile = isLargeFile;
    }

    public void setExtraHeaderBytes(int extraHeaderBytes) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        this.extraHeader = extraHeaderBytes;
    }

    public boolean isDefineMode() {
        return this.defineMode;
    }

    public NetcdfFile getNetcdfFile() {
        if (this.defineMode) {
            throw new IllegalStateException("Must leave define mode first");
        }
        return this.ncfile;
    }

    public Version getVersion() {
        return this.version;
    }

    public Variable findVariable(String fullNameEscaped) {
        return this.ncfile.findVariable(fullNameEscaped);
    }

    public Attribute findGlobalAttribute(String attName) {
        return this.ncfile.getRootGroup().findAttribute(attName);
    }

    public Dimension addDimension(Group g, String dimName, int length) {
        return this.addDimension(g, dimName, length, true, false, false);
    }

    public Dimension addUnlimitedDimension(String dimName) {
        return this.addDimension(null, dimName, 0, true, true, false);
    }

    public Dimension addDimension(Group g, String dimName, int length, boolean isShared, boolean isUnlimited, boolean isVariableLength) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (!this.isValidObjectName(dimName)) {
            throw new IllegalArgumentException("illegal dimension name " + dimName);
        }
        Dimension dim = new Dimension(dimName, length, isShared, isUnlimited, isVariableLength);
        this.ncfile.addDimension(g, dim);
        return dim;
    }

    public boolean hasDimension(Group g, String dimName) {
        if (g == null) {
            g = this.ncfile.getRootGroup();
        }
        return g.findDimension(dimName) != null;
    }

    private String makeValidObjectName(String name) {
        if (!this.isValidObjectName(name)) {
            String nname = this.createValidObjectName(name);
            log.warn("illegal object name= " + name + " change to " + name);
            return nname;
        }
        return name;
    }

    private boolean isValidObjectName(String name) {
        return N3iosp.isValidNetcdfObjectName(name);
    }

    private boolean isValidDataType(DataType dt) {
        return this.version.isExtendedModel() || validN3types.contains((Object)dt);
    }

    private String createValidObjectName(String name) {
        return N3iosp.makeValidNetcdfObjectName(name);
    }

    public Dimension renameDimension(Group g, String oldName, String newName) {
        Dimension dim;
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (!this.isValidObjectName(newName)) {
            throw new IllegalArgumentException("illegal dimension name " + newName);
        }
        if (g == null) {
            g = this.ncfile.getRootGroup();
        }
        if (null != (dim = g.findDimension(oldName))) {
            dim.setName(newName);
        }
        return dim;
    }

    public Group addGroup(Group parent, String name) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (parent == null) {
            return this.ncfile.getRootGroup();
        }
        Group result = new Group(this.ncfile, parent, name);
        parent.addGroup(result);
        return result;
    }

    public Attribute addGroupAttribute(Group g, Attribute att) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (!this.isValidObjectName(att.getShortName())) {
            String attName = this.createValidObjectName(att.getShortName());
            log.warn("illegal attribute name= " + att.getShortName() + " change to " + attName);
            att = new Attribute(attName, att.getValues());
        }
        return this.ncfile.addAttribute(g, att);
    }

    public EnumTypedef addTypedef(Group g, EnumTypedef td) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (!this.version.isExtendedModel()) {
            throw new IllegalArgumentException("Enum type only supported in extended model, this version is=" + (Object)((Object)this.version));
        }
        g.addEnumeration(td);
        return td;
    }

    public Attribute deleteGroupAttribute(Group g, String attName) {
        Attribute att;
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (g == null) {
            g = this.ncfile.getRootGroup();
        }
        if (null == (att = g.findAttribute(attName))) {
            return null;
        }
        g.remove(att);
        return att;
    }

    public Attribute renameGlobalAttribute(Group g, String oldName, String newName) {
        Attribute att;
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (!this.isValidObjectName(newName)) {
            String newnewName = this.createValidObjectName(newName);
            log.warn("illegal attribute name= " + newName + " change to " + newnewName);
            newName = newnewName;
        }
        if (g == null) {
            g = this.ncfile.getRootGroup();
        }
        if (null == (att = g.findAttribute(oldName))) {
            return null;
        }
        g.remove(att);
        att = new Attribute(newName, att.getValues());
        g.addAttribute(att);
        return att;
    }

    public Variable addVariable(Group g, String shortName, DataType dataType, String dimString) {
        Group parent = g == null ? this.ncfile.getRootGroup() : g;
        return this.addVariable(g, null, shortName, dataType, Dimension.makeDimensionsList(parent, dimString));
    }

    public Variable addVariable(Group g, String shortName, DataType dataType, List<Dimension> dims) {
        Variable oldVar;
        if (g == null) {
            g = this.ncfile.getRootGroup();
        }
        if ((oldVar = g.findVariable(shortName)) != null) {
            return null;
        }
        return this.addVariable(g, null, shortName, dataType, dims);
    }

    public Variable addVariable(Group g, Structure parent, String shortName, DataType dataType, List<Dimension> dims) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        shortName = this.makeValidObjectName(shortName);
        if (!this.isValidDataType(dataType)) {
            throw new IllegalArgumentException("illegal dataType: " + (Object)((Object)dataType) + " not supported in netcdf-3");
        }
        if (!this.version.isExtendedModel()) {
            for (int i = 0; i < dims.size(); ++i) {
                Dimension d = dims.get(i);
                if (!d.isUnlimited() || i == 0) continue;
                throw new IllegalArgumentException("Unlimited dimension " + d.getShortName() + " must be first (outermost) in netcdf-3 ");
            }
        }
        Variable v = dataType == DataType.STRUCTURE ? new Structure(this.ncfile, g, parent, shortName) : new Variable(this.ncfile, g, parent, shortName);
        v.setDataType(dataType);
        v.setDimensions(dims);
        long size = v.getSize() * (long)v.getElementSize();
        if (this.version == Version.netcdf3 && size > 0xFFFFFFFCL) {
            throw new IllegalArgumentException("Variable size in bytes " + size + " may not exceed " + 0xFFFFFFFCL);
        }
        this.ncfile.addVariable(g, v);
        return v;
    }

    public Structure addStructure(Group g, Structure org, String shortName, List<Dimension> dims) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        shortName = this.makeValidObjectName(shortName);
        if (!this.version.isExtendedModel()) {
            throw new IllegalArgumentException("Structure type only supported in extended model, version=" + (Object)((Object)this.version));
        }
        Structure s = new Structure(this.ncfile, g, null, shortName);
        s.setDimensions(dims);
        for (Variable m : org.getVariables()) {
            Variable nest = new Variable(this.ncfile, g, s, m.getShortName());
            nest.setDataType(m.getDataType());
            nest.setDimensions(m.getDimensions());
            s.addMemberVariable(nest);
        }
        this.ncfile.addVariable(g, s);
        return s;
    }

    public Variable addStructureMember(Structure s, String shortName, DataType dtype, String dims) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        shortName = this.makeValidObjectName(shortName);
        if (!this.version.isExtendedModel()) {
            throw new IllegalArgumentException("Structure type only supported in extended model, version=" + (Object)((Object)this.version));
        }
        Variable m = new Variable(this.ncfile, null, s, shortName, dtype, dims);
        return s.addMemberVariable(m);
    }

    public Variable addStringVariable(Group g, Variable stringVar, List<Dimension> dims) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (!N3iosp.isValidNetcdfObjectName(stringVar.getShortName())) {
            throw new IllegalArgumentException("illegal netCDF-3 variable name: " + stringVar.getShortName());
        }
        int max_strlen = 0;
        try {
            Array data = stringVar.read();
            IndexIterator ii = data.getIndexIterator();
            while (ii.hasNext()) {
                String s = (String)ii.getObjectNext();
                max_strlen = Math.max(max_strlen, s.length());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            String err = "No data found for Variable " + stringVar.getShortName() + ". Cannot determine the lentgh of the new CHAR variable.";
            log.error(err);
            System.out.println(err);
        }
        return this.addStringVariable(g, stringVar.getShortName(), dims, max_strlen);
    }

    public Variable addStringVariable(Group g, String shortName, List<Dimension> dims, int max_strlen) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        shortName = this.makeValidObjectName(shortName);
        Variable v = new Variable(this.ncfile, g, null, shortName);
        v.setDataType(DataType.CHAR);
        Dimension d = this.addDimension(g, shortName + "_strlen", max_strlen);
        ArrayList<Dimension> sdims = new ArrayList<Dimension>(dims);
        sdims.add(d);
        v.setDimensions(sdims);
        this.ncfile.addVariable(g, v);
        return v;
    }

    public Variable renameVariable(String oldName, String newName) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        Variable v = this.ncfile.findVariable(oldName);
        if (null != v) {
            String fullOldNameEscaped = v.getFullNameEscaped();
            v.setName(newName);
            this.varRenameMap.put(v.getFullNameEscaped(), fullOldNameEscaped);
        }
        return v;
    }

    public boolean addVariableAttribute(Variable v, Attribute att) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (!this.isValidObjectName(att.getShortName())) {
            String attName = this.createValidObjectName(att.getShortName());
            log.warn("illegal netCDF-3 attribute name= " + att.getShortName() + " change to " + attName);
            att = new Attribute(attName, att.getValues());
        }
        v.addAttribute(att);
        return true;
    }

    public Attribute deleteVariableAttribute(Variable v, String attName) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        Attribute att = v.findAttribute(attName);
        if (null == att) {
            return null;
        }
        v.remove(att);
        return att;
    }

    public Attribute renameVariableAttribute(Variable v, String attName, String newName) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        Attribute att = v.findAttribute(attName);
        if (null == att) {
            return null;
        }
        v.remove(att);
        att = new Attribute(newName, att.getValues());
        v.addAttribute(att);
        return att;
    }

    public void updateAttribute(Variable v2, Attribute att) throws IOException {
        if (this.defineMode) {
            throw new UnsupportedOperationException("in define mode");
        }
        this.spiw.updateAttribute(v2, att);
    }

    public void create() throws IOException {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (!this.isNewFile) {
            throw new UnsupportedOperationException("can only call create on a new file");
        }
        this.ncfile.finish();
        this.spiw.setFill(this.fill);
        this.spiw.create(this.location, this.ncfile, this.extraHeader, this.preallocateSize, this.isLargeFile);
        this.defineMode = false;
    }

    public boolean setRedefineMode(boolean redefineMode) throws IOException {
        if (redefineMode && !this.defineMode) {
            this.defineMode = true;
        } else if (!redefineMode && this.defineMode) {
            this.defineMode = false;
            this.ncfile.finish();
            boolean ok = this.spiw.rewriteHeader(this.isLargeFile);
            if (!ok) {
                this.rewrite();
            }
            return !ok;
        }
        return false;
    }

    private void rewrite() throws IOException {
        boolean ok;
        this.spiw.flush();
        this.spiw.close();
        File prevFile = new File(this.location);
        if (!prevFile.exists()) {
            return;
        }
        File tmpFile = new File(this.location + ".tmp");
        if (tmpFile.exists() && !(ok = tmpFile.delete())) {
            log.warn("rewrite unable to delete {}", (Object)tmpFile.getPath());
        }
        if (!prevFile.renameTo(tmpFile)) {
            System.out.println(prevFile.getPath() + " prevFile.exists " + prevFile.exists() + " canRead = " + prevFile.canRead());
            System.out.println(tmpFile.getPath() + " tmpFile.exists " + tmpFile.exists() + " canWrite " + tmpFile.canWrite());
            throw new RuntimeException("Cant rename " + prevFile.getAbsolutePath() + " to " + tmpFile.getAbsolutePath());
        }
        NetcdfFile oldFile = NetcdfFile.open(tmpFile.getPath());
        this.spiw.create(this.location, this.ncfile, this.extraHeader, this.preallocateSize, this.isLargeFile);
        this.spiw.setFill(this.fill);
        FileWriter2 fileWriter2 = new FileWriter2(this);
        for (Variable v : this.ncfile.getVariables()) {
            String oldVarName = v.getFullName();
            Variable oldVar = oldFile.findVariable(oldVarName);
            if (oldVar != null) {
                fileWriter2.copyAll(oldVar, v);
                continue;
            }
            if (this.varRenameMap.containsKey(oldVarName)) {
                String realOldVarName = this.varRenameMap.get(oldVarName);
                oldVar = oldFile.findVariable(realOldVarName);
                if (oldVar == null) continue;
                fileWriter2.copyAll(oldVar, v);
                continue;
            }
            String message = "Cannot find variable " + oldVarName + " to copy to new file.";
            log.warn(message);
            System.out.println(message);
        }
        oldFile.close();
        if (!tmpFile.delete()) {
            throw new RuntimeException("Cant delete " + tmpFile.getAbsolutePath());
        }
    }

    public Structure addRecordStructure() {
        if (this.version != Version.netcdf3) {
            return null;
        }
        boolean ok = (Boolean)this.ncfile.sendIospMessage("AddRecordStructure");
        if (!ok) {
            throw new IllegalStateException("can't add record variable");
        }
        return (Structure)this.ncfile.findVariable("record");
    }

    public void write(Variable v, Array values) throws IOException, InvalidRangeException {
        if (this.ncfile != v.getNetcdfFile()) {
            throw new IllegalArgumentException("Variable is not owned by this writer.");
        }
        this.write(v, new int[values.getRank()], values);
    }

    public void write(Variable v, int[] origin, Array values) throws IOException, InvalidRangeException {
        if (this.defineMode) {
            throw new UnsupportedOperationException("in define mode");
        }
        this.spiw.writeData(v, new Section(origin, values.getShape()), values);
        v.invalidateCache();
    }

    public void writeStringData(Variable v, Array values) throws IOException, InvalidRangeException {
        this.writeStringData(v, new int[values.getRank()], values);
    }

    public void writeStringData(Variable v, int[] origin, Array values) throws IOException, InvalidRangeException {
        if (values.getElementType() != String.class) {
            throw new IllegalArgumentException("Must be ArrayObject of String ");
        }
        if (v.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("variable " + v.getFullName() + " is not type CHAR");
        }
        int rank = v.getRank();
        int strlen = v.getShape(rank - 1);
        ArrayChar cvalues = ArrayChar.makeFromStringArray((ArrayObject)values, strlen);
        int[] corigin = new int[rank];
        System.arraycopy(origin, 0, corigin, 0, rank - 1);
        this.write(v, corigin, cvalues);
    }

    public int appendStructureData(Structure s, StructureData sdata) throws IOException, InvalidRangeException {
        return this.spiw.appendStructureData(s, sdata);
    }

    public void flush() throws IOException {
        this.spiw.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.spiw != null) {
            this.setRedefineMode(false);
            this.flush();
            this.spiw.close();
            this.spiw = null;
        }
    }

    public void abort() throws IOException {
        if (this.spiw != null) {
            this.spiw.close();
            this.spiw = null;
        }
    }

    public static enum Version {
        netcdf3(".nc"),
        netcdf4(".nc4"),
        netcdf4_classic(".nc"),
        netcdf3c(".nc"),
        netcdf3c64(".nc"),
        ncstream(".ncs");

        private String suffix;

        private Version(String suffix) {
            this.suffix = suffix;
        }

        public boolean isNetdf4format() {
            return this == netcdf4 || this == netcdf4_classic;
        }

        public boolean isExtendedModel() {
            return this == netcdf4 || this == ncstream;
        }

        public boolean useJniIosp() {
            return this != netcdf3 && this != ncstream;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

