/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.DatasetNode;
import thredds.client.catalog.builder.AccessBuilder;
import thredds.client.catalog.builder.DatasetBuilder;

public class CatalogRef
extends Dataset {
    private final String xlink;
    private boolean isRead;

    public CatalogRef(DatasetNode parent, String name, String xlink, Map<String, Object> flds, List<AccessBuilder> accessBuilders, List<DatasetBuilder> datasetBuilders) {
        super(parent, name, flds, accessBuilders, datasetBuilders);
        this.xlink = xlink;
    }

    public String getXlinkHref() {
        return this.xlink;
    }

    public boolean isRead() {
        return this.isRead;
    }

    public void setRead(boolean isRead) {
        this.isRead = isRead;
    }

    public Boolean useRemoteCatalogService() {
        return (Boolean)this.flds.get("UseRemoteCatalogService");
    }

    public URI getURI() {
        try {
            Catalog parent = this.getParentCatalog();
            if (parent != null) {
                return parent.resolveUri(this.xlink);
            }
        }
        catch (URISyntaxException e) {
            return null;
        }
        return null;
    }
}

