/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.library.model;

import org.gcube.data.transfer.library.faults.InvalidSourceException;
import org.gcube.data.transfer.library.model.Source;
import org.gcube.data.transfer.library.utils.StorageUtils;

public class StorageSource
extends Source<String> {
    private String id = null;

    public StorageSource(String id) throws InvalidSourceException {
        if (id == null) {
            throw new InvalidSourceException("Storage id cannot be null");
        }
        this.id = id;
    }

    @Override
    public boolean validate() throws InvalidSourceException {
        try {
            if (!StorageUtils.checkStorageId(this.id)) {
                throw new Exception("Not valid");
            }
        }
        catch (Exception e) {
            throw new InvalidSourceException("Invalid storage ID " + this.id);
        }
        return true;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void clean() {
    }

    @Override
    public String getTheSource() {
        return this.id;
    }
}

