/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.stubs.jaxws.handlers;

import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.gcube.common.clients.stubs.jaxws.GCoreService;
import org.gcube.common.clients.stubs.jaxws.handlers.CallHandler;
import org.gcube.common.clients.stubs.jaxws.handlers.HandlerRegistry;

public class GCoreJAXWSHandler
implements SOAPHandler<SOAPMessageContext> {
    private final GCoreService<?> target;

    public GCoreJAXWSHandler(GCoreService<?> target) {
        this.target = target;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        Boolean outbound = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outbound.booleanValue()) {
            try {
                SOAPHeader header = context.getMessage().getSOAPPart().getEnvelope().getHeader();
                if (header == null) {
                    header = context.getMessage().getSOAPPart().getEnvelope().addHeader();
                }
                for (CallHandler handler : HandlerRegistry.handlers()) {
                    handler.handleRequest(this.target, header, context);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("cannot configure outgoing message", e);
            }
        }
        try {
            for (CallHandler handler : HandlerRegistry.handlers()) {
                handler.handleResponse(this.target, context);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("cannot configure outgoing message", e);
        }
        return true;
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }
}

