/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Element;
import thredds.client.catalog.Catalog;
import thredds.inventory.MFile;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.CDM;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.DatasetConstructor;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.AggregationOuterDimension;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.xml.Parse;

public class AggregationExisting
extends AggregationOuterDimension {
    public static int countCacheUse = 0;

    public AggregationExisting(NetcdfDataset ncd, String dimName, String recheckS) {
        super(ncd, dimName, Aggregation.Type.joinExisting, recheckS);
    }

    @Override
    protected void buildNetcdfDataset(CancelTask cancelTask) throws IOException {
        Aggregation.Dataset typicalDataset = this.getTypicalDataset();
        NetcdfFile typical = typicalDataset.acquireFile(null);
        DatasetConstructor.transferDataset(typical, this.ncDataset, null);
        String dimName = this.getDimensionName();
        AggregationOuterDimension.CoordValueVar coordCacheVar = null;
        if (this.type != Aggregation.Type.joinExistingOne) {
            Variable tcv = typical.findVariable(dimName);
            if (tcv != null) {
                coordCacheVar = new AggregationOuterDimension.CoordValueVar(this, dimName, tcv.getDataType(), tcv.getUnitsString());
            } else {
                VariableDS fake = new VariableDS(this.ncDataset, null, null, dimName, DataType.INT, dimName, null, null);
                this.ncDataset.addVariable(null, fake);
            }
        } else {
            coordCacheVar = new AggregationOuterDimension.CoordValueVar(this, dimName, DataType.STRING, "");
        }
        if (coordCacheVar != null) {
            this.cacheList.add(coordCacheVar);
        }
        this.persistRead();
        this.buildCoords(cancelTask);
        Dimension aggDim = new Dimension(dimName, this.getTotalCoords());
        this.ncDataset.removeDimension(null, dimName);
        this.ncDataset.addDimension(null, aggDim);
        this.promoteGlobalAttributes((AggregationOuterDimension.DatasetOuterDimension)typicalDataset);
        for (Variable v : typical.getVariables()) {
            String outerName;
            if (v.getRank() < 1 || !dimName.equals(outerName = v.getDimension(0).makeFullName())) continue;
            Group newGroup = DatasetConstructor.findGroup(this.ncDataset, v.getParentGroup());
            VariableDS vagg = new VariableDS(this.ncDataset, newGroup, null, v.getShortName(), v.getDataType(), v.getDimensionsString(), null, null);
            vagg.setProxyReader(this);
            DatasetConstructor.transferVariableAttributes(v, vagg);
            newGroup.removeVariable(v.getShortName());
            newGroup.addVariable(vagg);
            this.aggVars.add(vagg);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        VariableDS joinAggCoord = (VariableDS)this.ncDataset.findVariable(dimName);
        if (joinAggCoord == null && this.type == Aggregation.Type.joinExisting) {
            typicalDataset.close(typical);
            throw new IllegalArgumentException("No existing coordinate variable for joinExisting on " + this.getLocation());
        }
        if (this.type == Aggregation.Type.joinExistingOne) {
            if (joinAggCoord != null) {
                this.ncDataset.getRootGroup().removeVariable(joinAggCoord.getShortName());
            }
            joinAggCoord = new VariableDS(this.ncDataset, null, null, dimName, DataType.STRING, dimName, null, null);
            joinAggCoord.setProxyReader(this);
            this.ncDataset.getRootGroup().addVariable(joinAggCoord);
            this.aggVars.add(joinAggCoord);
            joinAggCoord.addAttribute(new Attribute("_CoordinateAxisType", "Time"));
            joinAggCoord.addAttribute(new Attribute("long_name", "time coordinate"));
            joinAggCoord.addAttribute(new Attribute("standard_name", "time"));
        }
        if (this.timeUnitsChange) {
            this.readTimeCoordinates(joinAggCoord, cancelTask);
        }
        joinAggCoord.setSPobject(coordCacheVar);
        this.persistRead();
        this.setDatasetAcquireProxy(typicalDataset, this.ncDataset);
        typicalDataset.close(typical);
        if (debugInvocation) {
            System.out.println(this.ncDataset.getLocation() + " invocation count = " + AggregationOuterDimension.invocation);
        }
        this.ncDataset.finish();
    }

    @Override
    protected void rebuildDataset() throws IOException {
        super.rebuildDataset();
        if (this.timeUnitsChange) {
            VariableDS joinAggCoord = (VariableDS)this.ncDataset.getRootGroup().findVariable(this.dimName);
            this.readTimeCoordinates(joinAggCoord, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readTimeCoordinates(VariableDS timeAxis, CancelTask cancelTask) throws IOException {
        ArrayList<CalendarDate> dateList = new ArrayList<CalendarDate>();
        String timeUnits = null;
        for (Aggregation.Dataset dataset : this.getDatasets()) {
            NetcdfFile ncfile = null;
            try {
                ncfile = dataset.acquireFile(cancelTask);
                Variable v = ncfile.findVariable(timeAxis.getFullNameEscaped());
                if (v == null) {
                    logger.warn("readTimeCoordinates: variable = " + timeAxis.getFullName() + " not found in file " + dataset.getLocation());
                    return;
                }
                VariableDS vds = v instanceof VariableDS ? (VariableDS)v : new VariableDS(null, v, true);
                CoordinateAxis1DTime timeCoordVar = CoordinateAxis1DTime.factory(this.ncDataset, vds, null);
                dateList.addAll(timeCoordVar.getCalendarDates());
                if (timeUnits == null) {
                    timeUnits = v.getUnitsString();
                }
            }
            finally {
                dataset.close(ncfile);
            }
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        assert (timeUnits != null);
        int[] shape = timeAxis.getShape();
        int ntimes = shape[0];
        assert (ntimes == dateList.size());
        DataType coordType = timeAxis.getDataType() == DataType.STRING ? DataType.STRING : DataType.DOUBLE;
        Array timeCoordVals = Array.factory(coordType, shape);
        IndexIterator ii = timeCoordVals.getIndexIterator();
        if (timeAxis.getDataType() == DataType.STRING) {
            for (CalendarDate date : dateList) {
                ii.setObjectNext(date.toString());
            }
        } else {
            DateUnit du;
            timeAxis.setDataType(DataType.DOUBLE);
            try {
                du = new DateUnit(timeUnits);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            timeAxis.addAttribute(new Attribute("units", timeUnits));
            for (CalendarDate date : dateList) {
                double val2 = du.makeValue(date.toDate());
                ii.setDoubleNext(val2);
            }
        }
        timeAxis.setCachedData(timeCoordVals, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistWrite() throws IOException {
        File cacheFile;
        if (diskCache2 == null) {
            return;
        }
        String cacheName = this.getCacheName();
        if (cacheName == null) {
            return;
        }
        if (cacheName.startsWith("file:")) {
            cacheName = cacheName.substring(5);
        }
        if ((cacheFile = diskCache2.getCacheFile(cacheName)) == null) {
            throw new IllegalStateException();
        }
        if (!this.cacheDirty && cacheFile.exists()) {
            return;
        }
        try (AbstractInterruptibleChannel channel = null;){
            FileLock lock;
            File dir = cacheFile.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                logger.error("Cant make cache directory= " + cacheFile);
            }
            FileOutputStream fos = new FileOutputStream(cacheFile);
            channel = fos.getChannel();
            try {
                lock = ((FileChannel)channel).tryLock();
            }
            catch (OverlappingFileLockException e) {
                if (channel != null) {
                    channel.close();
                }
                return;
            }
            if (lock == null) {
                return;
            }
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)fos, CDM.utf8Charset));
            out.print("<?xml version='1.0' encoding='UTF-8'?>\n");
            out.print("<aggregation xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2' version='3' ");
            out.print("type='" + (Object)((Object)this.type) + "' ");
            if (this.dimName != null) {
                out.print("dimName='" + this.dimName + "' ");
            }
            if (this.datasetManager.getRecheck() != null) {
                out.print("recheckEvery='" + this.datasetManager.getRecheck() + "' ");
            }
            out.print(">\n");
            List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
            for (Aggregation.Dataset dataset : nestedDatasets) {
                AggregationOuterDimension.DatasetOuterDimension dod = (AggregationOuterDimension.DatasetOuterDimension)dataset;
                if (dod.getId() == null) {
                    logger.warn("id is null");
                }
                out.print("  <netcdf id='" + dod.getId() + "' ");
                out.print("ncoords='" + dod.getNcoords(null) + "' >\n");
                for (AggregationOuterDimension.CacheVar pv : this.cacheList) {
                    Array data = pv.getData(dod.getId());
                    if (data == null) continue;
                    out.print("    <cache varName='" + pv.varName + "' >");
                    NCdumpW.printArray(data, out);
                    out.print("</cache>\n");
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(" wrote array = " + pv.varName + " nelems= " + data.getSize() + " for " + dataset.getLocation());
                }
                out.print("  </netcdf>\n");
            }
            out.print("</aggregation>\n");
            out.close();
            long time = this.datasetManager.getLastScanned();
            if (time == 0L) {
                time = System.currentTimeMillis();
            }
            if (!cacheFile.setLastModified(time)) {
                logger.warn("FAIL to set lastModified on {}", (Object)cacheFile.getPath());
            }
            this.cacheDirty = false;
            if (logger.isDebugEnabled()) {
                logger.debug("Aggregation persisted = " + cacheFile.getPath() + " lastModified= " + new Date(this.datasetManager.getLastScanned()));
            }
        }
    }

    @Override
    protected void persistRead() {
        Element aggElem;
        File cacheFile;
        if (diskCache2 == null) {
            return;
        }
        String cacheName = this.getCacheName();
        if (cacheName == null) {
            return;
        }
        if (cacheName.startsWith("file:")) {
            cacheName = cacheName.substring(5);
        }
        if ((cacheFile = diskCache2.getCacheFile(cacheName)) == null) {
            throw new IllegalStateException();
        }
        if (!cacheFile.exists()) {
            return;
        }
        long lastWritten = cacheFile.lastModified();
        if (logger.isDebugEnabled()) {
            logger.debug(" Try to Read cache {} " + cacheFile.getPath());
        }
        try {
            aggElem = Parse.readRootElement("file:" + cacheFile.getPath());
        }
        catch (IOException e) {
            if (debugCache) {
                System.out.println(" No cache for " + cacheName + " - " + e.getMessage());
            }
            return;
        }
        String version = aggElem.getAttributeValue("version");
        if (version == null || !version.equals("3")) {
            return;
        }
        HashMap<String, Aggregation.Dataset> map = new HashMap<String, Aggregation.Dataset>();
        for (Aggregation.Dataset ds : this.getDatasets()) {
            map.put(ds.getId(), ds);
        }
        List<Element> ncList = aggElem.getChildren("netcdf", Catalog.ncmlNS);
        for (Element netcdfElemNested : ncList) {
            MFile mfile;
            String id = netcdfElemNested.getAttributeValue("id");
            AggregationOuterDimension.DatasetOuterDimension dod = (AggregationOuterDimension.DatasetOuterDimension)map.get(id);
            if (null == dod) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug(" have cache but no dataset= {}", (Object)id);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug(" use cache for dataset= {}", (Object)id);
            }
            if ((mfile = dod.getMFile()) != null && mfile.getLastModified() > lastWritten) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug(" dataset was changed= {}", (Object)mfile);
                continue;
            }
            if (dod.ncoord == 0) {
                String ncoordsS = netcdfElemNested.getAttributeValue("ncoords");
                try {
                    dod.ncoord = Integer.parseInt(ncoordsS);
                    if (logger.isDebugEnabled()) {
                        logger.debug(" Read the cache; ncoords = {}", (Object)dod.ncoord);
                    }
                }
                catch (NumberFormatException e) {
                    logger.error("bad ncoord attribute on dataset=" + id);
                }
            }
            List<Element> cacheElemList = netcdfElemNested.getChildren("cache", Catalog.ncmlNS);
            for (Element cacheElemNested : cacheElemList) {
                String varName = cacheElemNested.getAttributeValue("varName");
                AggregationOuterDimension.CacheVar pv = this.findCacheVariable(varName);
                if (pv != null) {
                    String sdata = cacheElemNested.getText();
                    if (sdata.length() == 0) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug(" read data for var = " + varName + " size= " + sdata.length());
                    }
                    String[] vals = sdata.split(" ");
                    try {
                        Array data = Array.makeArray(pv.dtype, vals);
                        pv.putData(id, data);
                        ++countCacheUse;
                    }
                    catch (Exception e) {
                        logger.warn("Error reading cached data ", (Throwable)e);
                    }
                    continue;
                }
                logger.warn("not a cache var=" + varName);
            }
        }
    }

    private String getCacheName() {
        String cacheName = this.ncDataset.getLocation();
        if (cacheName == null) {
            cacheName = this.ncDataset.getCacheName();
        }
        return cacheName;
    }
}

