/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.radial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.radial.RadialDatasetSweepAdapter;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class LevelII2Dataset
extends RadialDatasetSweepAdapter
implements TypedDatasetFactoryIF {
    private NetcdfDataset ds;
    double latv;
    double lonv;
    double elev;
    DateFormatter formatter = new DateFormatter();

    @Override
    public boolean isMine(NetcdfDataset ds) {
        String format;
        String convention = ds.findAttValueIgnoreCase(null, "Conventions", null);
        return null != convention && convention.equals("_Coordinates") && (format = ds.findAttValueIgnoreCase(null, "Format", null)) != null && (format.equals("ARCHIVE2") || format.equals("AR2V0001") || format.equals("CINRAD-SA") || format.equals("AR2V0003") || format.equals("AR2V0002") || format.equals("AR2V0004") || format.equals("AR2V0006") || format.equals("AR2V0007"));
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new LevelII2Dataset(ncd);
    }

    @Override
    public FeatureType getScientificDataType() {
        return FeatureType.RADIAL;
    }

    public LevelII2Dataset() {
    }

    public LevelII2Dataset(NetcdfDataset ds) {
        super(ds);
        this.ds = ds;
        this.desc = "Nexrad 2 radar dataset";
        this.setEarthLocation();
        try {
            this.setTimeUnits();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setStartDate();
        this.setEndDate();
        this.setBoundingBox();
    }

    @Override
    protected void setBoundingBox() {
        LatLonRect bb;
        if (this.origin == null) {
            return;
        }
        double dLat = Math.toDegrees(this.getMaximumRadialDist() / Earth.getRadius());
        double latRadians = Math.toRadians(this.origin.getLatitude());
        double dLon = dLat * Math.cos(latRadians);
        double lat1 = this.origin.getLatitude() - dLat / 2.0;
        double lon1 = this.origin.getLongitude() - dLon / 2.0;
        this.boundingBox = bb = new LatLonRect(new LatLonPointImpl(lat1, lon1), dLat, dLon);
    }

    double getMaximumRadialDist() {
        double maxdist = 0.0;
        for (RadialDatasetSweep.RadialVariable rv : this.dataVariables) {
            RadialDatasetSweep.Sweep sp = rv.getSweep(0);
            double dist = (float)sp.getGateNumber() * sp.getGateSize();
            if (!(dist > maxdist)) continue;
            maxdist = dist;
        }
        return maxdist;
    }

    @Override
    protected void setEarthLocation() {
        Attribute ga = this.ds.findGlobalAttribute("StationLatitude");
        this.latv = ga != null ? ga.getNumericValue().doubleValue() : 0.0;
        ga = this.ds.findGlobalAttribute("StationLongitude");
        this.lonv = ga != null ? ga.getNumericValue().doubleValue() : 0.0;
        ga = this.ds.findGlobalAttribute("StationElevationInMeters");
        this.elev = ga != null ? ga.getNumericValue().doubleValue() : 0.0;
        this.origin = new EarthLocationImpl(this.latv, this.lonv, this.elev);
    }

    @Override
    public EarthLocation getCommonOrigin() {
        return this.origin;
    }

    @Override
    public String getRadarID() {
        Attribute ga = this.ds.findGlobalAttribute("Station");
        if (ga != null) {
            return ga.getStringValue();
        }
        return "XXXX";
    }

    @Override
    public String getRadarName() {
        Attribute ga = this.ds.findGlobalAttribute("StationName");
        if (ga != null) {
            return ga.getStringValue();
        }
        return "Unknown Station";
    }

    @Override
    public String getDataFormat() {
        return "Level II";
    }

    @Override
    public boolean isVolume() {
        return true;
    }

    public boolean isHighResolution(NetcdfDataset nds) {
        Dimension r = nds.findDimension("scanR_HI");
        Dimension v = nds.findDimension("scanV_HI");
        return r != null || v != null;
    }

    @Override
    public boolean isStationary() {
        return true;
    }

    @Override
    protected void setTimeUnits() throws Exception {
        List<CoordinateAxis> axes = this.ds.getCoordinateAxes();
        for (int i = 0; i < axes.size(); ++i) {
            CoordinateAxis axis = axes.get(i);
            if (axis.getAxisType() != AxisType.Time) continue;
            String units = axis.getUnitsString();
            this.dateUnits = new DateUnit(units);
            this.calDateUnits = CalendarDateUnit.of(null, units);
            return;
        }
        this.parseInfo.append("*** Time Units not Found\n");
    }

    @Override
    protected void setStartDate() {
        String start_datetime = this.ds.findAttValueIgnoreCase(null, "time_coverage_start", null);
        if (start_datetime != null) {
            this.startDate = this.formatter.getISODate(start_datetime);
        } else {
            this.parseInfo.append("*** start_datetime not Found\n");
        }
    }

    @Override
    protected void setEndDate() {
        String end_datetime = this.ds.findAttValueIgnoreCase(null, "time_coverage_end", null);
        if (end_datetime != null) {
            this.endDate = this.formatter.getISODate(end_datetime);
        } else {
            this.parseInfo.append("*** end_datetime not Found\n");
        }
    }

    @Override
    public void clearDatasetMemory() {
        List<VariableSimpleIF> rvars = this.getDataVariables();
        for (RadialDatasetSweep.RadialVariable radialVariable : rvars) {
            radialVariable.clearVariableMemory();
        }
    }

    public void getRadialsNum() {
    }

    @Override
    protected void addRadialVariable(NetcdfDataset nds, Variable var) {
        RadialDatasetSweep.RadialVariable rsvar = null;
        String vName = var.getShortName();
        int rnk = var.getRank();
        if (rnk == 3) {
            if (!this.isHighResolution(nds)) {
                RadialDatasetSweepAdapter.MyRadialVariableAdapter v = new RadialDatasetSweepAdapter.MyRadialVariableAdapter(this, vName, var.getAttributes());
                rsvar = this.makeRadialVariable(nds, v, var);
            } else if (!vName.endsWith("_HI")) {
                RadialDatasetSweepAdapter.MyRadialVariableAdapter v = new RadialDatasetSweepAdapter.MyRadialVariableAdapter(this, vName, var.getAttributes());
                rsvar = this.makeRadialVariable(nds, v, var);
            }
        }
        if (rsvar != null) {
            this.dataVariables.add(rsvar);
        }
    }

    @Override
    protected RadialDatasetSweep.RadialVariable makeRadialVariable(NetcdfDataset nds, VariableSimpleIF v, Variable v0) {
        return new LevelII2Variable(nds, v, v0);
    }

    public String getInfo() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("LevelII2Dataset\n");
        sbuff.append(super.getDetailInfo());
        sbuff.append("\n\n");
        sbuff.append(this.parseInfo.toString());
        return sbuff.toString();
    }

    private static void testRadialVariable(RadialDatasetSweep.RadialVariable rv) throws IOException {
        RadialDatasetSweep.Sweep sw;
        int nsweep = rv.getNumSweeps();
        for (int i = 0; i < nsweep; ++i) {
            sw = rv.getSweep(i);
            float me = sw.getMeanElevation();
            System.out.println("*** radar Sweep mean elevation of sweep " + i + " is: " + me);
            int nrays = sw.getRadialNumber();
            float[] az = new float[nrays];
            for (int j = 0; j < nrays; ++j) {
                float azi;
                az[j] = azi = sw.getAzimuth(j);
            }
            sw.getAzimuth();
            sw.readData();
        }
        sw = rv.getSweep(0);
        rv.readAllData();
        float[] ddd = sw.readData();
        sw.getAzimuth();
        sw.getElevation();
        assert (null != ddd);
        int nrays = sw.getRadialNumber();
        float[] az = new float[nrays];
        for (int i = 0; i < nrays; ++i) {
            int ngates = sw.getGateNumber();
            assert (ngates > 0);
            float[] d = sw.readData(i);
            assert (null != d);
            float azi = sw.getAzimuth(i);
            assert (azi > 0.0f);
            az[i] = azi;
            float ele = sw.getElevation(i);
            assert (ele > 0.0f);
            float la = (float)sw.getOrigin(i).getLatitude();
            assert (la > 0.0f);
            float lo = (float)sw.getOrigin(i).getLongitude();
            assert (lo > 0.0f);
            float al = (float)sw.getOrigin(i).getAltitude();
            assert (al > 0.0f);
        }
        assert (0 != nrays);
    }

    public static void main(String[] args) throws Exception, IOException, InstantiationException, IllegalAccessException {
        String fileIn = "C:/Users/yuanho/Downloads/Level2_KCBW_20110307_2351.ar2v";
        RadialDatasetSweep rds = (RadialDatasetSweep)TypedDatasetFactory.open(FeatureType.RADIAL, fileIn, null, new StringBuilder());
        String id = rds.getRadarID();
        String name = rds.getRadarName();
        if (rds.isStationary()) {
            System.out.println("*** radar is stationary with name and id: " + name + " " + id);
        }
        RadialDatasetSweep.RadialVariable vDM = (RadialDatasetSweep.RadialVariable)rds.getDataVariable("Reflectivity");
        vDM.readAllData();
        LevelII2Dataset.testRadialVariable(vDM);
    }

    private class LevelII2Variable
    extends RadialDatasetSweepAdapter.MyRadialVariableAdapter
    implements RadialDatasetSweep.RadialVariable {
        int nsweeps;
        int nsweepsHR;
        ArrayList sweeps;
        String name;

        private LevelII2Variable(NetcdfDataset nds, VariableSimpleIF v, Variable v0) {
            String vname;
            Variable vehr;
            super(LevelII2Dataset.this, v.getShortName(), v0.getAttributes());
            this.nsweepsHR = 0;
            this.sweeps = new ArrayList();
            this.name = v.getShortName();
            if (LevelII2Dataset.this.isHighResolution(nds) && (vehr = nds.findVariable((vname = v0.getFullNameEscaped()) + "_HI")) != null) {
                int[] shape1 = vehr.getShape();
                int count1 = vehr.getRank() - 1;
                int ngatesHR = shape1[count1];
                int nraysHR = shape1[--count1];
                this.nsweepsHR = shape1[--count1];
                for (int i = 0; i < this.nsweepsHR; ++i) {
                    this.sweeps.add(new LevelII2Sweep(vehr, i, nraysHR, ngatesHR));
                }
            }
            int[] shape = v0.getShape();
            int count = v0.getRank() - 1;
            int ngates = shape[count];
            int nrays = shape[--count];
            this.nsweeps = shape[--count];
            for (int i = this.nsweepsHR; i < this.nsweeps + this.nsweepsHR; ++i) {
                this.sweeps.add(new LevelII2Sweep(v0, i, nrays, ngates));
            }
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public int getNumSweeps() {
            if (LevelII2Dataset.this.isHighResolution(LevelII2Dataset.this.ds)) {
                return this.nsweepsHR + this.nsweeps;
            }
            return this.nsweeps;
        }

        @Override
        public RadialDatasetSweep.Sweep getSweep(int sweepNo) {
            return (RadialDatasetSweep.Sweep)this.sweeps.get(sweepNo);
        }

        public int getNumRadials() {
            return 0;
        }

        @Override
        public float[] readAllData() throws IOException {
            RadialDatasetSweep.Sweep spn = (RadialDatasetSweep.Sweep)this.sweeps.get(this.sweeps.size() - 1);
            Variable v = spn.getsweepVar();
            float vGateSize = spn.getGateSize();
            Array allData = v.read();
            if (!LevelII2Dataset.this.isHighResolution(LevelII2Dataset.this.ds)) {
                return (float[])allData.get1DJavaArray(Float.TYPE);
            }
            RadialDatasetSweep.Sweep sp0 = (RadialDatasetSweep.Sweep)this.sweeps.get(0);
            Variable v0 = sp0.getsweepVar();
            float v0GateSize = sp0.getGateSize();
            int[] stride = v0.getShortName().startsWith("Reflect") ? new int[]{1, 2, 4} : new int[]{1, 2, 1};
            int[] shape1 = v.getShape();
            int[] shape2 = v0.getShape();
            int shp1 = shape1[1] * stride[1] > shape2[1] ? shape2[1] : shape1[1] * stride[1];
            int shp2 = shape1[2] * stride[2] > shape2[2] ? shape2[2] : shape1[2] * stride[2];
            int[] shape = new int[]{shape2[0], shp1, shp2};
            if (shape2[2] == shape1[2] || v0GateSize == vGateSize) {
                stride = new int[]{1, 2, 1};
                shape[2] = shape1[2];
            }
            int[] origin = new int[]{0, 0, 0};
            try {
                Section section = new Section(origin, shape, stride);
                Array hrData = v0.read(section);
                float[] fa1 = (float[])hrData.get1DJavaArray(Float.TYPE);
                float[] fa2 = (float[])allData.get1DJavaArray(Float.TYPE);
                float[] fa = new float[fa1.length + fa2.length];
                System.arraycopy(fa1, 0, fa, 0, fa1.length);
                System.arraycopy(fa2, 0, fa, fa1.length, fa2.length);
                return fa;
            }
            catch (InvalidRangeException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void clearVariableMemory() {
            for (int i = 0; i < this.nsweeps; ++i) {
            }
        }

        private class LevelII2Sweep
        implements RadialDatasetSweep.Sweep {
            double meanElevation = Double.NaN;
            double meanAzimuth = Double.NaN;
            int nrays;
            int ngates;
            int sweepno;
            Variable sweepVar;

            LevelII2Sweep(Variable v, int sweepno, int rays, int gates) {
                this.sweepVar = v;
                this.sweepno = sweepno;
                this.nrays = rays;
                this.ngates = gates;
            }

            @Override
            public Variable getsweepVar() {
                return this.sweepVar;
            }

            @Override
            public float[] readData() throws IOException {
                if (!LevelII2Dataset.this.isHighResolution(LevelII2Dataset.this.ds)) {
                    return this.sweepData(this.sweepno);
                }
                if (this.sweepno > LevelII2Variable.this.nsweepsHR - 1) {
                    int swpNo = this.sweepno - LevelII2Variable.this.nsweepsHR;
                    return this.sweepData(swpNo);
                }
                return this.sweepData(this.sweepno);
            }

            private float[] sweepData(int swpNumber) throws IOException {
                int[] shape = this.sweepVar.getShape();
                int[] origin = new int[3];
                origin[0] = swpNumber;
                shape[0] = 1;
                try {
                    Array sweepTmp = this.sweepVar.read(origin, shape).reduce();
                    return (float[])sweepTmp.get1DJavaArray(Float.TYPE);
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public float[] readData(int ray) throws IOException {
                if (!LevelII2Dataset.this.isHighResolution(LevelII2Dataset.this.ds)) {
                    return this.rayData(this.sweepno, ray);
                }
                if (this.sweepno >= LevelII2Variable.this.nsweepsHR) {
                    int swpNo = this.sweepno - LevelII2Variable.this.nsweepsHR;
                    return this.rayData(swpNo, ray);
                }
                return this.rayData(this.sweepno, ray);
            }

            public float[] rayData(int swpNumber, int ray) throws IOException {
                int[] shape = this.sweepVar.getShape();
                int[] origin = new int[3];
                origin[0] = swpNumber;
                origin[1] = ray;
                shape[0] = 1;
                shape[1] = 1;
                try {
                    Array sweepTmp = this.sweepVar.read(origin, shape).reduce();
                    return (float[])sweepTmp.get1DJavaArray(Float.TYPE);
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e);
                }
            }

            public void setMeanElevation() {
                String eleName = this.getRadialVarCoordinateName("elevation", this.sweepVar.getShortName());
                if (!LevelII2Dataset.this.isHighResolution(LevelII2Dataset.this.ds)) {
                    this.setMeanEle(eleName, this.sweepno);
                } else if (this.sweepno >= LevelII2Variable.this.nsweepsHR) {
                    int swpNo = this.sweepno - LevelII2Variable.this.nsweepsHR;
                    this.setMeanEle(eleName, swpNo);
                } else {
                    this.setMeanEle(eleName + "_HI", this.sweepno);
                }
            }

            private void setMeanEle(String elevName, int swpNumber) {
                float sum = 0.0f;
                int sumSize = 0;
                try {
                    float[] eleArray;
                    for (float v : eleArray = this.getEle(elevName, swpNumber)) {
                        if (Float.isNaN(v)) continue;
                        sum += v;
                        ++sumSize;
                    }
                    if (sumSize > 0) {
                        this.meanElevation = sum / (float)sumSize;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public float getMeanElevation() {
                if (Double.isNaN(this.meanElevation)) {
                    this.setMeanElevation();
                }
                return (float)this.meanElevation;
            }

            public double meanDouble(Array a) {
                double sum = 0.0;
                int size = 0;
                IndexIterator iterA = a.getIndexIterator();
                while (iterA.hasNext()) {
                    double s = iterA.getDoubleNext();
                    if (Double.isNaN(s)) continue;
                    sum += s;
                    ++size;
                }
                if (size > 0) {
                    return sum / (double)size;
                }
                return Double.POSITIVE_INFINITY;
            }

            @Override
            public int getGateNumber() {
                return this.ngates;
            }

            @Override
            public int getRadialNumber() {
                return this.nrays;
            }

            @Override
            public RadialDatasetSweep.Type getType() {
                return null;
            }

            @Override
            public EarthLocation getOrigin(int ray) {
                return LevelII2Dataset.this.origin;
            }

            @Override
            public Date getStartingTime() {
                return LevelII2Dataset.this.startDate;
            }

            @Override
            public Date getEndingTime() {
                return LevelII2Dataset.this.endDate;
            }

            @Override
            public int getSweepIndex() {
                return this.sweepno;
            }

            public void setMeanAzimuth() {
                String aziName = this.getRadialVarCoordinateName("azimuth", this.sweepVar.getShortName());
                if (!LevelII2Dataset.this.isHighResolution(LevelII2Dataset.this.ds)) {
                    this.setMeanAzi(aziName, this.sweepno);
                } else if (this.sweepno >= LevelII2Variable.this.nsweepsHR) {
                    int swpNo = this.sweepno - LevelII2Variable.this.nsweepsHR;
                    this.setMeanAzi(aziName, swpNo);
                } else {
                    this.setMeanAzi(aziName + "_HI", this.sweepno);
                }
            }

            private void setMeanAzi(String aziName, int swpNumber) {
                Array aziData = null;
                if (this.getType() != null) {
                    try {
                        Array data = LevelII2Dataset.this.ds.findVariable(aziName).read();
                        int[] aziOrigin = new int[]{swpNumber, 0};
                        int[] aziShape = new int[]{1, this.getRadialNumber()};
                        aziData = data.section(aziOrigin, aziShape);
                        this.meanAzimuth = MAMath.sumDouble(aziData) / (double)aziData.getSize();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.meanAzimuth = 0.0;
                    }
                    catch (InvalidRangeException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.meanAzimuth = 0.0;
                }
            }

            @Override
            public float getMeanAzimuth() {
                if (Double.isNaN(this.meanAzimuth)) {
                    this.setMeanAzimuth();
                }
                return (float)this.meanAzimuth;
            }

            public boolean isConic() {
                return true;
            }

            @Override
            public float getElevation(int ray) throws IOException {
                String eleName = this.getRadialVarCoordinateName("elevation", this.sweepVar.getShortName());
                if (!LevelII2Dataset.this.isHighResolution(LevelII2Dataset.this.ds)) {
                    return this.getEle(eleName, this.sweepno, ray);
                }
                if (this.sweepno >= LevelII2Variable.this.nsweepsHR) {
                    int swpNo = this.sweepno - LevelII2Variable.this.nsweepsHR;
                    return this.getEle(eleName, swpNo, ray);
                }
                return this.getEle(eleName + "_HI", this.sweepno, ray);
            }

            public float getEle(String elevName, int swpNumber, int ray) throws IOException {
                float[] eleData = this.getEle(elevName, swpNumber);
                return eleData[ray];
            }

            @Override
            public float[] getElevation() throws IOException {
                String eleName = this.getRadialVarCoordinateName("elevation", this.sweepVar.getShortName());
                if (!LevelII2Dataset.this.isHighResolution(LevelII2Dataset.this.ds)) {
                    return this.getEle(eleName, this.sweepno);
                }
                if (this.sweepno >= LevelII2Variable.this.nsweepsHR) {
                    int swpNo = this.sweepno - LevelII2Variable.this.nsweepsHR;
                    return this.getEle(eleName, swpNo);
                }
                return this.getEle(eleName + "_HI", this.sweepno);
            }

            public float[] getEle(String elevName, int swpNumber) throws IOException {
                try {
                    Variable evar = LevelII2Dataset.this.ds.findVariable(elevName);
                    Array eleData = evar.read();
                    evar.setCachedData(eleData, false);
                    int[] eleOrigin = new int[]{swpNumber, 0};
                    int[] eleShape = new int[]{1, this.getRadialNumber()};
                    eleData = eleData.section(eleOrigin, eleShape);
                    return (float[])eleData.get1DJavaArray(Float.TYPE);
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public float[] getAzimuth() throws IOException {
                String aziName = this.getRadialVarCoordinateName("azimuth", this.sweepVar.getShortName());
                if (!LevelII2Dataset.this.isHighResolution(LevelII2Dataset.this.ds)) {
                    return this.getAzi(aziName, this.sweepno);
                }
                if (this.sweepno >= LevelII2Variable.this.nsweepsHR) {
                    int swpNo = this.sweepno - LevelII2Variable.this.nsweepsHR;
                    return this.getAzi(aziName, swpNo);
                }
                return this.getAzi(aziName + "_HI", this.sweepno);
            }

            public float[] getAzi(String aziName, int swpNumber) throws IOException {
                try {
                    Variable avar = LevelII2Dataset.this.ds.findVariable(aziName);
                    Array aziData = avar.read();
                    avar.setCachedData(aziData, false);
                    int[] aziOrigin = new int[]{swpNumber, 0};
                    int[] aziShape = new int[]{1, this.getRadialNumber()};
                    aziData = aziData.section(aziOrigin, aziShape);
                    return (float[])aziData.get1DJavaArray(Float.TYPE);
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public float getAzimuth(int ray) throws IOException {
                String aziName = this.getRadialVarCoordinateName("azimuth", this.sweepVar.getShortName());
                if (!LevelII2Dataset.this.isHighResolution(LevelII2Dataset.this.ds)) {
                    return this.getAzi(aziName, this.sweepno, ray);
                }
                if (this.sweepno >= LevelII2Variable.this.nsweepsHR) {
                    int swpNo = this.sweepno - LevelII2Variable.this.nsweepsHR;
                    return this.getAzi(aziName, swpNo, ray);
                }
                return this.getAzi(aziName + "_HI", this.sweepno, ray);
            }

            public float getAzi(String aziName, int swpNumber, int ray) throws IOException {
                float[] aziData = this.getAzi(aziName, swpNumber);
                return aziData[ray];
            }

            public float getRadialDistance(int gate) throws IOException {
                String disName = this.getRadialVarCoordinateName("distance", this.sweepVar.getShortName());
                if (!LevelII2Dataset.this.isHighResolution(LevelII2Dataset.this.ds)) {
                    return this.getRadialDist(disName, gate);
                }
                if (this.sweepno >= LevelII2Variable.this.nsweepsHR) {
                    return this.getRadialDist(disName, gate);
                }
                return this.getRadialDist(disName + "_HI", gate);
            }

            public float getRadialDist(String dName, int gate) throws IOException {
                Variable dvar = LevelII2Dataset.this.ds.findVariable(dName);
                Array data = dvar.read();
                dvar.setCachedData(data, false);
                Index index = data.getIndex();
                return data.getFloat(index.set(gate));
            }

            @Override
            public float getTime(int ray) throws IOException {
                String tName = this.getRadialVarCoordinateName("time", this.sweepVar.getShortName());
                if (!LevelII2Dataset.this.isHighResolution(LevelII2Dataset.this.ds)) {
                    return this.getT(tName, this.sweepno, ray);
                }
                if (this.sweepno >= LevelII2Variable.this.nsweepsHR) {
                    int swpNo = this.sweepno - LevelII2Variable.this.nsweepsHR;
                    return this.getT(tName, swpNo, ray);
                }
                return this.getT(tName + "_HI", this.sweepno, ray);
            }

            public String getRadialVarCoordinateName(String coord, String rVar) {
                String cName = rVar.startsWith("Reflectivity") ? coord + "R" : (rVar.startsWith("DifferentialReflectivity") ? coord + "D" : (rVar.startsWith("CorrelationCoefficient") ? coord + "C" : (rVar.startsWith("DifferentialPhase") ? coord + "P" : coord + "V")));
                return cName;
            }

            public float getT(String tName, int swpNumber, int ray) throws IOException {
                Variable tvar = LevelII2Dataset.this.ds.findVariable(tName);
                Array timeData = tvar.read();
                tvar.setCachedData(timeData, false);
                Index timeIndex = timeData.getIndex();
                return timeData.getFloat(timeIndex.set(swpNumber, ray));
            }

            @Override
            public float getBeamWidth() {
                return 0.95f;
            }

            @Override
            public float getNyquistFrequency() {
                return 0.0f;
            }

            @Override
            public float getRangeToFirstGate() {
                try {
                    return this.getRadialDistance(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }

            @Override
            public float getGateSize() {
                try {
                    return this.getRadialDistance(1) - this.getRadialDistance(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }

            public boolean isGateSizeConstant() {
                return true;
            }

            @Override
            public void clearSweepMemory() {
            }
        }
    }
}

