/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.OutputStream;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.DirectoryBucket;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Download
extends Operation {
    final Logger logger = LoggerFactory.getLogger(Download.class);
    private String localPath;
    private String remotePath;
    private OutputStream os;

    public Download(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType);
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        this.localPath = file.getLocalPath();
        this.remotePath = remotePath;
        return this.getRemoteIdentifier(remotePath, rootArea);
    }

    @Override
    public String doIt(MyFile myFile) throws RemoteBackendException {
        String id = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" DOWNLOAD " + myFile.getRemotePath() + " in bucket: " + this.bucket);
        }
        try {
            id = this.get(myFile, false);
        }
        catch (Throwable e) {
            TransportManagerFactory tmf = new TransportManagerFactory(this.server, this.user, this.password);
            TransportManager tm = tmf.getTransport(this.backendType, myFile.getGcubeMemoryType());
            tm.close();
            this.logger.error("Problem in download from: " + myFile.getRemotePath() + ": " + e.getMessage());
            throw new RemoteBackendException(" Problem in download operation ", e.getCause());
        }
        return id;
    }

    @Override
    public String initOperation(MyFile resource, String remotePath, String author, String[] server, String rootArea) {
        DirectoryBucket dirBuc = new DirectoryBucket(server, this.user, this.password, remotePath, author);
        String bucketName = new BucketCoding().bucketFileCoding(remotePath, rootArea);
        Object dirObject = null;
        this.os = resource.getOutputStream();
        this.bucket = bucketName;
        return this.bucket;
    }
}

