/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import com.coverity.security.Escape;
import java.io.Serializable;
import java.net.URLConnection;
import opendap.dap.DAP2Exception;
import org.apache.http.Header;
import ucar.httpservices.HTTPMethod;

public class ServerVersion
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final int XDODS_SERVER = 0;
    public static final int XDAP = 1;
    public static final String DAP2_PROTOCOL_VERSION = "3.2";
    private int major;
    private int minor;
    private int subminor;
    private String versionString;

    public ServerVersion(HTTPMethod method) throws DAP2Exception {
        Header h = method.getResponseHeader("XDAP");
        if (h != null) {
            this.versionString = h.getValue();
            this.processXDAPVersion(this.versionString);
            return;
        }
        h = method.getResponseHeader("XDODS-Server");
        if (h != null) {
            this.versionString = h.getValue();
            this.processXDODSServerVersion(this.versionString);
            return;
        }
        throw new DAP2Exception("Not a valid OPeNDAP server - Missing MIME Header fields! Either \"XDAP\" or \"XDODS-Server.\" must be present.");
    }

    public ServerVersion(URLConnection connection) throws DAP2Exception {
        String sHeader_server = connection.getHeaderField("XDAP");
        if (sHeader_server != null) {
            this.processXDAPVersion(sHeader_server);
            return;
        }
        sHeader_server = connection.getHeaderField("XDODS-Server");
        if (sHeader_server == null) {
            sHeader_server = connection.getHeaderField("xdods-server");
        }
        if (sHeader_server != null) {
            this.processXDODSServerVersion(sHeader_server);
            return;
        }
        throw new DAP2Exception("Not a valid OPeNDAP server - Missing MIME Header fields! Either \"XDAP\" or \"XDODS-Server.\" must be present.");
    }

    public ServerVersion(String ver, int headerType) throws DAP2Exception {
        this.versionString = ver;
        this.minor = 0;
        this.major = 0;
        this.subminor = -1;
        switch (headerType) {
            case 1: {
                this.processXDAPVersion(ver);
                break;
            }
            case 0: {
                this.processXDODSServerVersion(ver);
                break;
            }
            default: {
                throw new DAP2Exception("Invalid Header Type. Must be one of ServerVersion.XDAP or ServerVersion.XDODS_SERVER");
            }
        }
    }

    private void processXDODSServerVersion(String ver) throws DAP2Exception {
        String badVersionMsg = "Invalid XDODS-Server header: " + Escape.html(ver) + "  Version must contain an identifying word (ex: opendap or DODS followed by a \"/\" and then MV.mv (Where MV = MajorVersionNumber and mv = MinorVersionNumber)";
        int verIndex = ver.indexOf("/");
        verIndex = verIndex != -1 ? ++verIndex : 0;
        int dotIndex = ver.indexOf(46, verIndex);
        if (dotIndex != -1) {
            String majorString = ver.substring(verIndex, dotIndex);
            this.major = Integer.parseInt(majorString);
            String minorString = ver.substring(dotIndex + 1);
            int minorDotIndex = minorString.indexOf(46);
            if (minorDotIndex != -1) {
                this.minor = Integer.parseInt(minorString.substring(0, minorDotIndex));
                this.subminor = Integer.parseInt(minorString.substring(minorDotIndex + 1));
            } else {
                this.minor = Integer.parseInt(minorString);
            }
        } else {
            throw new DAP2Exception(badVersionMsg);
        }
    }

    private void processXDAPVersion(String ver) {
        int dotIndex = ver.indexOf(46);
        if (dotIndex != -1) {
            String majorString = ver.substring(0, dotIndex);
            this.major = Integer.parseInt(majorString);
            String minorString = ver.substring(dotIndex + 1);
            int minorDotIndex = minorString.indexOf(46);
            this.minor = minorDotIndex != -1 ? Integer.parseInt(minorString.substring(0, minorDotIndex)) : Integer.parseInt(minorString);
        }
    }

    public ServerVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getSubMinor() {
        return this.minor;
    }

    public final String toString() {
        String version = this.major + "." + this.minor;
        if (this.subminor >= 0) {
            version = version + "." + this.subminor;
        }
        return "Version string: " + this.versionString + " produces headers  XDAP: " + version + "  XDODS-Server: DODS/" + version;
    }

    public final String getVersionString() {
        return this.versionString;
    }
}

