/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Calendar;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.gcube.dataanalysis.copernicus.cmems.CmemsProduct;
import org.gcube.dataanalysis.copernicus.cmems.CodedString;
import org.gcube.dataanalysis.copernicus.motu.model.MotuServer;
import org.gcube.dataanalysis.copernicus.motu.util.NetworkUtils;
import org.gcube.dataanalysis.copernicus.motu.util.TimeUtil;

public class CmemsClient {
    private static Logger LOGGER = Logger.getLogger(CmemsClient.class);
    private static Collection<CmemsProduct> cachedProducts = new Vector<CmemsProduct>();
    private static Long cacheTimestamp;
    private static final Long CACHE_TTL;
    private String endpoint;

    public CmemsClient() {
        this("http://cmems-resources.cls.fr/index.php?option=com_csw&task=advancedsearch");
    }

    public CmemsClient(String endpoint) {
        this.endpoint = endpoint;
    }

    private Collection<CmemsProduct> downloadProducts() throws Exception {
        String json = NetworkUtils.doGet(this.endpoint, null);
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode rootNode = objectMapper.readTree(json);
        JsonNode docsNode = rootNode.path("products").path("response").path("docs");
        Vector<CmemsProduct> out = new Vector<CmemsProduct>();
        for (CmemsProduct p : (CmemsProduct[])objectMapper.readValue(docsNode.toString(), CmemsProduct[].class)) {
            out.add(p);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CmemsProduct> getAllProducts() throws Exception {
        Collection<CmemsProduct> collection = cachedProducts;
        synchronized (collection) {
            if (this.isCacheExpired().booleanValue()) {
                LOGGER.debug((Object)"getting a fresh copy of products");
                Collection<CmemsProduct> prods = this.downloadProducts();
                cachedProducts = prods;
                cacheTimestamp = Calendar.getInstance().getTimeInMillis();
            }
            return cachedProducts;
        }
    }

    private Boolean isCacheExpired() {
        if (cacheTimestamp == null) {
            return true;
        }
        if (Calendar.getInstance().getTimeInMillis() - cacheTimestamp > CACHE_TTL * 60L * 1000L) {
            return true;
        }
        return false;
    }

    public Collection<MotuServer> getMotuServers() throws Exception {
        TreeSet<String> urls = new TreeSet<String>();
        for (CmemsProduct psi : this.getAllProducts()) {
            String tds = psi.getTds();
            if (tds == null || tds.equalsIgnoreCase("undefined")) continue;
            String url = tds.substring(0, tds.indexOf("?"));
            urls.add(url);
        }
        Vector<MotuServer> out = new Vector<MotuServer>();
        for (String url : urls) {
            out.add(new MotuServer(url));
        }
        return out;
    }

    public Collection<CodedString> getRegionalDomains() throws Exception {
        TreeSet<CodedString> out = new TreeSet<CodedString>();
        for (CmemsProduct product : this.getAllProducts()) {
            String[] parameters;
            for (String par : parameters = product.getGeographicalArea().split(",")) {
                if (par == null || par.trim().isEmpty()) continue;
                out.add(new CodedString(par.trim()));
            }
        }
        out.remove(new CodedString("undefined"));
        return out;
    }

    public Collection<CodedString> getOceanVariables() throws Exception {
        TreeSet<CodedString> out = new TreeSet<CodedString>();
        for (CmemsProduct product : this.getAllProducts()) {
            String[] parameters;
            for (String par : parameters = product.getOceanVariables().split(",")) {
                if (par == null || par.trim().isEmpty()) continue;
                out.add(new CodedString(par.trim()));
            }
        }
        out.remove(new CodedString("undefined"));
        return out;
    }

    public Collection<CodedString> getOceanKeys() throws Exception {
        TreeSet<CodedString> out = new TreeSet<CodedString>();
        for (CmemsProduct product : this.getAllProducts()) {
            String[] parameters;
            for (String par : parameters = product.getOceanKeys().split(",")) {
                if (par == null || par.trim().isEmpty()) continue;
                out.add(new CodedString(par.trim()));
            }
        }
        out.remove(new CodedString("undefined"));
        return out;
    }

    public Calendar getMinTime() throws Exception {
        Calendar out = Calendar.getInstance();
        for (CmemsProduct product : this.getAllProducts()) {
            Calendar c = TimeUtil.toCalendar(product.getTemporalBegin());
            if (!c.before(out)) continue;
            out = c;
        }
        return out;
    }

    public Calendar getMaxTime() throws Exception {
        Calendar out = Calendar.getInstance();
        out.setTimeInMillis(0L);
        for (CmemsProduct product : this.getAllProducts()) {
            Calendar c;
            if (product.getTemporalEnd() == null || !(c = TimeUtil.toCalendar(product.getTemporalEnd())).after(out)) continue;
            out = c;
        }
        return out;
    }

    static {
        CACHE_TTL = 1L;
    }
}

