/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.treeStructure.chunks;

import java.math.BigInteger;
import java.util.ArrayList;
import org.gcube.dataanalysis.lexicalmatcher.analysis.core.Engine;
import org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.data.DBObjectTranslator;
import org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.data.Entry;
import org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.treeStructure.chunks.Chunk;
import org.gcube.dataanalysis.lexicalmatcher.utils.LexicalLogger;
import org.hibernate.SessionFactory;

public class ReferenceChunk
extends Chunk {
    private String categoryName;
    private String categoryTableName;
    private ArrayList<Entry> referenceEntries;
    private BigInteger startPoint;
    private int chunkSize;

    public ReferenceChunk(String CategoryName, String CategoryTableName, BigInteger StartPoint, int ChunkSize, Engine engine) {
        super(engine);
        this.chunkSize = ChunkSize;
        this.categoryName = CategoryName;
        this.categoryTableName = CategoryTableName;
        this.startPoint = StartPoint;
        LexicalLogger.getLogger().trace("ReferenceChunk-> \t\tTOOK CATEGORY CHUNK FOR CATEGORY: " + this.categoryName + " - index : " + this.startPoint);
    }

    public ArrayList<Entry> getReferenceEntries() throws Exception {
        DBObjectTranslator dbo = new DBObjectTranslator();
        SessionFactory sess = this.engine.getDBSession();
        this.referenceEntries = dbo.retrieveEntries(sess, this.categoryTableName, this.startPoint, this.chunkSize);
        return this.referenceEntries;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }
}

