package org.gcube.dataanalysis.executor.plugin;

import java.util.Hashtable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.lifetime.State.Done;
import org.gcube.common.core.utils.handlers.lifetime.State.Failed;
import org.gcube.common.core.utils.handlers.lifetime.State.Running;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.dataanalysis.executor.messagequeue.ATTRIBUTE;
import org.gcube.dataanalysis.executor.messagequeue.Consumer;
import org.gcube.dataanalysis.executor.messagequeue.QCONSTANTS;
import org.gcube.dataanalysis.executor.messagequeue.QueueManager;
import org.gcube.vremanagement.executor.plugin.ExecutorTask;
import org.gcube.vremanagement.executor.state.TaskRuntime;

public class GenericWorkerPlugin extends GCUBEHandler<TaskRuntime> implements ExecutorTask {

	@Override
	public void stop() throws UnsupportedOperationException, Exception {

		this.getLogger().trace("GenericWorkerPlugin: Stopped");
	}

	public static Consumer activeT;
	// public static Producer activeP;
	public static QueueWatcher qWatcher;
	public static Hashtable<String, String> sessionBlackList=new Hashtable<String, String>();
	public static Boolean processing;
	public static Boolean creating;
	public static ConsumerWatcher2 consumerwatcher;
	public static Timer consumerWatcherTimer;
	static GCUBELog workerLogger;
	
	@Override
	public void run() throws Exception {
		if (workerLogger==null)
			workerLogger = this.getLogger();
		
		this.setState(Running.INSTANCE);
		this.getLogger().trace("GenericWorkerPlugin: Start");
		TaskRuntime runtime = this.getHandled();
		String nodeAddress = GHNContext.getContext().getHostname();

		Map<String, Object> inputs = runtime.getInputs();
		this.getLogger().trace("GenericWorkerPlugin: Inputs: " + inputs + " on node: " + nodeAddress);

		try {
			String uniqueTopicName = ScriptIOWorker.getString((String) inputs.get(ATTRIBUTE.TOPIC_NAME.name()));
			String user = ScriptIOWorker.getString((String) inputs.get(ATTRIBUTE.QUEUE_USER.name()));
			String password = ScriptIOWorker.getString((String) inputs.get(ATTRIBUTE.QUEUE_PASSWORD.name()));
			String queueURL = ScriptIOWorker.getString((String) inputs.get(ATTRIBUTE.QUEUE_URL.name()));
			String topicResponseName = ScriptIOWorker.getString((String) inputs.get(ATTRIBUTE.TOPIC_RESPONSE_NAME.name()));
			String session = ScriptIOWorker.getString((String) inputs.get(ATTRIBUTE.QSESSION.name()));
			String erase = ScriptIOWorker.getString((String) inputs.get(ATTRIBUTE.ERASE.name()));
			
			//the consumer watcher must always be checked
			if (consumerwatcher == null || consumerWatcherTimer == null) {
				this.getLogger().trace("GenericWorkerPlugin: Starting consumer watcher");
				consumerWatcherTimer = new Timer();
				consumerwatcher = new ConsumerWatcher2();
				consumerWatcherTimer.schedule(consumerwatcher, QCONSTANTS.QueueLifeTime, QCONSTANTS.QueueLifeTime);
			}
			
			if (session == null) {
				this.getLogger().trace("GenericWorkerPlugin: Session is null ignoring message");
			} 
			else
				if 	(GenericWorkerPlugin.sessionBlackList!=null&&GenericWorkerPlugin.sessionBlackList.contains(session)) 
					this.getLogger().trace("GenericWorkerPlugin: Session is black listed ... ignoring message");
				else if (getProcessing())
					this.getLogger().trace("GenericWorkerPlugin: The worker is processing... ignoring message");
				else if (getCreating())
					this.getLogger().trace("GenericWorkerPlugin: The worker is creating... ignoring message");
				else if ((erase != null) && (erase.equals("true"))) {
					this.getLogger().trace("GenericWorkerPlugin: Erasing queue command");
					this.getLogger().trace("GenericWorkerPlugin: purging session " + session + " on queue " + uniqueTopicName);
					sessionBlackList.put(session, uniqueTopicName);
					this.getLogger().trace("GenericWorkerPlugin: topic " + session + "on queue " + uniqueTopicName + " has been blacklisted");
				}
				else {
					this.getLogger().trace("GenericWorkerPlugin: The worker is available");
					setCreating(true);
					boolean eraseCon = eraseConsumer();
					if (eraseCon)
						createConsumer(uniqueTopicName, session, user, password, queueURL, nodeAddress);
					else 
						this.getLogger().trace("GenericWorkerPlugin: could not erase che consumer ... ignoring message");
					setCreating(false);
				}
			this.setState(Done.INSTANCE);

		} catch (Exception e) {
			e.printStackTrace();
			this.getLogger().error("GenericWorkerPlugin: Error " + e.getLocalizedMessage());
			this.getLogger().trace("GenericWorkerPlugin: Completely Finished");
			this.setState(Failed.INSTANCE);
		} finally {
			stop();
		}
	}
	
	public static void setProcessing(boolean state) {
		processing = state;
/*		if (processing)
			resetWatcher();*/
	}

	public static boolean getProcessing() {
		if (processing == null)
			processing = false;

		return processing;
	}

	public static boolean getCreating() {
		if (creating == null)
			creating = false;

		return creating;
	}

	public static void setCreating(boolean state) {
		creating = state;
/*		if (creating)
			resetWatcher();
			*/
	}

	public static boolean eraseConsumer(){
		try{
		if (activeT != null) {
			workerLogger.trace("GenericWorkerPlugin: deleting the previous consumer");
			activeT.stop();
			activeT.closeSession();
			activeT = null;
			System.gc();
			Thread.sleep(2000);
		}
		workerLogger.trace("GenericWorkerPlugin: Previous consumer is offline!");
		}catch(Throwable e){
			workerLogger.trace("GenericWorkerPlugin: Error could not erase Consumer! "+e.getLocalizedMessage());
			e.printStackTrace();
			return false;
		}
		return true;
	}
	
	public void createConsumer(String uniqueTopicName,String session, String user,String password,String queueURL,String nodeAddress){
		try{
		this.getLogger().trace("GenericWorkerPlugin: Adding Topic " + uniqueTopicName + " with session " + session);
		this.getLogger().trace("GenericWorkerPlugin: Active Queue is null - creating");
		this.getLogger().trace("GenericWorkerPlugin: Creating Consumer");
		QueueManager qm = new QueueManager();
		qm.createAndConnect(user, password, queueURL, uniqueTopicName);
		QueueListener ql = new QueueListener(qm, uniqueTopicName, nodeAddress, this.logger);
		activeT = new Consumer(qm, ql, ql, uniqueTopicName);
		this.getLogger().trace("GenericWorkerPlugin: Active Queue Consumer was created!");
		this.getLogger().trace("GenericWorkerPlugin: Creation was set to FALSE");
		}catch(Throwable e){
			this.getLogger().trace("GenericWorkerPlugin: Error could not create Consumer! "+e.getLocalizedMessage());
			e.printStackTrace();
		}
	}
	
	public static void resetGenericWorker() {
		setCreating(true);
		eraseConsumer();
		if (sessionBlackList != null && sessionBlackList.size()>10){
			sessionBlackList = null;
			sessionBlackList=new Hashtable<String, String>();
			workerLogger.trace("GenericWorkerPlugin: Refreshing the black list!");
		}
		setCreating(false);
		purgeConsumerWatcher();
		System.gc();
		workerLogger.trace("GenericWorkerPlugin: Reset GW!");
	}
	
	public static void purgeConsumerWatcher() {
		workerLogger.trace("GenericWorkerPlugin: Stopping - closing all watchers");
		if (consumerwatcher != null) {
			consumerwatcher.cancel();
			if (consumerWatcherTimer != null) {
				consumerWatcherTimer.cancel();
				consumerWatcherTimer.purge();
			}
			consumerwatcher = null;
			consumerWatcherTimer = null;
		}
		workerLogger.trace("GenericWorkerPlugin: Stopping - closed all watchers");
	}

	public class ConsumerWatcher2 extends TimerTask {

		public ConsumerWatcher2() {

		}

		@Override
		public void run() {
			try {
				if (!getProcessing() && !getCreating()) {
					resetGenericWorker();
				}
			} catch (Exception e) {
				System.out.println("GenericWorkerPlugin: ERROR IN RESETTING WATCHER!");
				e.printStackTrace();
			}
		}

	}
	
}
