package org.gcube.dataanalysis.environment.test.regression;

import java.util.HashMap;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.gcube.dataanalysis.environment.explorer.EnvDataExplorer;

public class RegressionThreddsExplorer {
	static float x= 173.1f;
	static float y= 11.5f;
	static String workspace = "THREDDS";
	
	public static void main(String[] args) {
		
		Logger logger = initLogger("./resources/ALog.properties");
		EnvDataExplorer.setLogger(logger);

		String layer = "Mean Chlorophyll a concentration OC4 Algorithm OCEANCOLOURGLOCHLSEAWIFSL3RANOBSERVATIONS009007b1323078504304.nc";
		check(layer);
		layer = "geopotential height 04091217ruc.nc";
		check(layer);
		layer = "terrain 04091217ruc.nc";
		check(layer);
		layer = "temperature 04091217ruc.nc";
		check(layer);
		layer = "pressure at tropopause 04091217ruc.nc";
		check(layer);
		layer = "Evaporation ECMWFERA40subset.nc";
		check(layer);
		layer = "orography standard deviation cami0000090164x128L26c030918.nc";
		check(layer);
		layer = "PBL height cami0000090164x128L26c030918.nc";
		check(layer);
		layer = "Cloud fraction cami0000090164x128L26c030918.nc";
		check(layer);
		layer = "pressure at mean sea level MAPS reduction 04091217ruc.nc";
		check(layer);
		layer = "v component of wind 04091217ruc.nc";
		check(layer);
		layer = "u component of wind in boundary layer 04091217ruc.nc";
		check(layer);
		layer = "Photosynthetically Available Radiation 400nm 700nm OCEANCOLOURGLOPARSEAWIFSL3RANOBSERVATIONS009007g1323078416955.nc";
		check(layer);
		layer = "Perturbation specific humidity eddies in PBL cami0000090164x128L26c030918.nc";
		check(layer);
		layer = "y wind component wrfoutv2Lambert.nc";
		check(layer);
		layer = "V at 10 M wrfoutv2Lambert.nc";
		check(layer);
		layer = "QV at 2 M wrfoutv2Lambert.nc";
		check(layer);
		layer = "Map scale factor on u grid wrfoutv2Lambert.nc";
		check(layer);
		layer = "Coriolis sine latitude term wrfoutv2Lambert.nc";
		check(layer);
		layer = "land ocean transition mask ocean 0 continent 1 transition 0 1 cami0000090164x128L26c030918.nc";
		check(layer);
		layer = "10 metre v wind component ECMWFERA40subset.nc";
		check(layer);
		layer = "2 metre dewpoint temperature ECMWFERA40subset.nc";
		check(layer);
		
		x= -34.7f;
		y= -7.68f;
		workspace = "aquamaps";
		layer = "enviroments";
		check(layer);
		layer = "faoarea";
		check(layer);
		layer = "Synodus tectus";
		check(layer);
		layer = "Diplodus noct";
		check(layer);
		layer = "Eurymen gyrinus";
		check(layer);
		layer = "";
		check(layer);
	}
	
	public static void check(String layer){
		String geonetworkUrl = "http://geoserver-dev.d4science-ii.research-infrastructures.eu/geonetwork";
		String geonetworkUsername = "admin";
		String geonetworkPassword = "admin";
		String geoserverUsername= "admin";
		String geoserverPassword="gcube@geo2010";
		System.out.println("TEST1");
		long t0 = System.currentTimeMillis();
		HashMap<String, String> map = EnvDataExplorer.retrieveEnvInfoGeoNetwork(geonetworkUrl, geonetworkUsername, geonetworkPassword, geoserverUsername, geoserverPassword, workspace,layer,x,y);
		System.out.println("PARAMETERS MAP: "+ map );
		System.out.println("ELAPSED: "+(System.currentTimeMillis()-t0));
		boolean b = (map!=null) && (map.size()>0);
		if (b)
			System.out.println("CHECK OK!");
		else
			System.err.println("CHECK ERROR ON "+layer);
	}
	public static Logger initLogger(String path){
		PropertyConfigurator.configure(path);
		Logger logger = Logger.getLogger("AnalysisLogger");
		return logger;
	}
	
}
