package org.gcube.dataanalysis.environment.thredds;

import java.io.IOException;
import java.util.List;

import org.gcube.dataanalysis.environment.utils.ELog;

import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;

public class NetCDFOperations {

	
	private ucar.nc2.NetcdfFile ncFile;
	private ucar.nc2.Variable var;
	@Deprecated
	public double getFeature(String openDapUrl, float x, float y) {
		try {
			open(openDapUrl);
			var = ncFile.findVariable("z");

		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			close();
		}
		return 0d;
	}
	
	public void openDataset(String filename) {
		NetcdfFile ncfile = null;
		try {
			ncfile = NetcdfDataset.openFile(filename, null);
			List<Dimension> dlist = ncfile.getDimensions();
			for (Dimension d : dlist) {
				ELog.debug("NetCDF Operations->"+d.getName() + " Len " + d.getLength());
			}

			List<Variable> vars = ncfile.getVariables();
			for (Variable v : vars) {
				if (v.isCoordinateVariable()) {
					ELog.debug("NetCDF Operations->"+v.getNameAndDimensions());
					ELog.debug("description->" + v.getDescription());
					ELog.debug("full name->" + v.getFullName());
					ELog.debug("rank->" + v.getRank());
					ELog.debug("units->" + v.getUnitsString());
					ELog.debug("data type name->" + v.getDataType().name());
					ELog.debug("data type ordinal->" + v.getDataType().ordinal());
					ELog.debug("data type primitive->" + v.getDataType().getPrimitiveClassType());
					ELog.debug("data type size->" + v.getDataType().getSize());
				} else
					ELog.debug("<-" + v.getNameAndDimensions());
			}
		} catch (IOException ioe) {
			ioe.printStackTrace();
		} finally {
			if (null != ncfile)
				try {
					ncfile.close();
				} catch (IOException ioe) {

				}
		}
	}
	
	
	public void open(String openDapUrl) throws java.io.IOException {
		ncFile = ucar.nc2.dataset.NetcdfDataset.openFile(openDapUrl, null);
		// var = ncFile.findVariable("z");
		List<Dimension> dlist = ncFile.getDimensions();
		for (Dimension d : dlist) {
			ELog.debug(d.getName() + " Len " + d.getLength());
		}

		// ucar.ma2.Array data = var.read();
	}

	public void close() {
		try {
			if (ncFile != null)
				ncFile.close();
		} catch (Exception e) {
		}
	}


}
