package org.gcube.dataanalysis.environment.test;

import java.util.HashMap;
import java.util.List;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.gcube.dataanalysis.environment.explorer.EnvDataExplorer;

public class TestThreddsExplorer {

	public static void main(String[] args) {
//		String layer = "Bathymetry";
//		String layer="Total column water";
//		String layer = "temperature 04091217ruc.nc";
//		String layer = "pressure at surface 04091217ruc.nc";
		
		String layer = "LATENT HEAT FLUX AT THE SURFACE wrfoutv2Lambert.nc";
//		String layer = "Mean Chlorophyll a concentration OC4 Algorithm OCEANCOLOURGLOCHLSEAWIFSL3RANOBSERVATIONS009007b1323078504304.nc";
		
		String workspace = "THREDDS";

//		layer = "enviroments";
//		workspace = "wsenvironment";
		
		float x= 43.7f;
		float y=10.42f;

		Logger logger = initLogger("./resources/ALog.properties");
		EnvDataExplorer.setLogger(logger);
		
		System.out.println("TEST1");
		long t0 = System.currentTimeMillis();
		//in ingresso vuole il path al file di config del log4j
		HashMap<String, String> map = EnvDataExplorer.retrieveEnvInfoGeoNetwork(workspace,layer,x,y);
		System.out.println("PARAMETERS MAP: "+ map );
		System.out.println("ELAPSED: "+(System.currentTimeMillis()-t0));
		
		
		System.out.println("TEST2");
		float [][] xy = new float[2][2];
		xy[0][0] = 173.1f;
		xy[0][1] = 11.5f;
		xy[0][0] = 171.1f;
		xy[0][1] = 10.5f;
		t0 = System.currentTimeMillis();
		List<HashMap<String, String>> map2 = EnvDataExplorer.retrieveEnvInfoGeoNetwork(workspace,layer,xy);
		System.out.println("PARAMETERS MAP: "+ map2 );
		System.out.println("ELAPSED: "+(System.currentTimeMillis()-t0));
		
		System.out.println("TEST3: RECOVER WCS");
		String wcsAddress = EnvDataExplorer.retrieveNetcdfWCSGeoNetwork(workspace, layer);
		System.out.println("WCS ADDRESS : "+wcsAddress);
		
		System.out.println("TEST4: RECOVER WMS");
		String wmsAddress = EnvDataExplorer.retrieveNetcdfWMSGeoNetwork(workspace, layer);
		System.out.println("WMS ADDRESS : "+wmsAddress);
	}
	
	public static Logger initLogger(String path){
		PropertyConfigurator.configure(path);
		Logger logger = Logger.getLogger("AnalysisLogger");
		return logger;
	}
	
}
