/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.evaluation.bioclimate;

import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.evaluation.bioclimate.BioClimateGraph;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.Operations;
import org.hibernate.SessionFactory;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;

public class BioClimateAnalysis {
    private static String countHighProbabilityCells = "select count(*) from %1$s where probability>%2$s";
    private static String countSeaCells = "select count(*) from %1$s as a join %2$s as b on a.oceanarea>0 and a.csquarecode=b.csquarecode and ((a.iceconann<b.iceconann-%3$s or a.iceconann>b.iceconann+%3$s) or (a.salinitymean<b.salinitymean-%3$s or a.salinitymean>b.salinitymean+%3$s) or (a.sstanmean<b.sstanmean-%3$s or a.sstanmean>b.sstanmean+%3$s))";
    private static String iceLeakage = "select count(*) from %1$s as a join %2$s as b on a.csquarecode=b.csquarecode and (a.iceconann<b.iceconann) and a.oceanarea>0";
    private static String takeRangeOfDepths = "select distinct depthmin, depthmax from %1$s order by depthmin";
    private static String takeRangeOfParam = "select %1$s from %2$s where %1$s is not null %3$s order by %1$s";
    private static String countNumberOfSpeciesPerRange = "select count(*) from %1$s where %4$s>%2$s and %4$s<=%3$s ";
    private static String countNumberOfSpecies = "select count(*) from %1$s where depthmin<%2$s and depthmin>=%3$s and depthmax<%4$s and depthmax>=%5$s";
    private static String countProbabilityPerArea = "select count(*) from %1$s as a join hcaf_s as b on b.%2$s = %3$s and a.probability > #THRESHOLD# and a.csquarecode=b.csquarecode";
    public static String salinityDefaultRange = "salinitymin>27.44 and salinitymin<=36.57";
    public static String salinityMinFeature = "salinitymin";
    private static String takeAvgSelection = "select avg(%1$s),%2$s from %3$s %4$s group by %2$s order by %2$s";
    private static String[] selectionCriteria = new String[]{"faoaream", "lme"};
    private static String[] timeseriesNames = new String[]{"Ice Conc.", "Sea Surface Temperature", "Salinity"};
    private static String[] quantitiesNames = new String[]{FIELD.iceconann.name(), FIELD.sstanmean.name(), FIELD.salinitymean.name()};
    private static String[] criteriaFilters = new String[]{"where faoaream>0", "where lme>0"};
    private static String[] criteriaNames = new String[]{"FaoArea", "LME"};
    private static String meanVal = "select avg(%2$s) from %1$s where oceanarea>0";
    private String configPath;
    private String temporaryDirectory;
    protected SessionFactory referencedbConnection;
    private String[] csquareTable;
    private String[] finalDistributionTable;
    private int[] highProbabilityCells;
    private double[] discrepancies;
    private double[] avgIce;
    private double[] avgSST;
    private double[] avgSalinity;
    private ComputationalAgent eval;
    private float status;
    private boolean liveRender;
    boolean doHcafAn;
    boolean doHspecAn;
    private LexicalEngineConfiguration config;
    static int width = 680;
    static int height = 420;
    static int defaultNumOfFeatureClusters = 10;
    private static String[] SERIES = new String[]{"High Probability Cells Trend (>%1$s)", "Number of Changing Cells", "Reducing Ice Concentration Trend", "High Probability Cells Trend Derivative", "Average Trends", "Ice Concentration", "Sea Surface Temperature", "Salinity"};
    private HashMap<String, Image> producedImages;

    public static void main(String[] args) throws Exception {
        String configPath = "./cfg/";
        String databaseUrl = "jdbc:postgresql://localhost/testdb";
        String databaseUser = "gcube";
        String databasePassword = "d4science2";
        BioClimateAnalysis bioClimate = new BioClimateAnalysis(configPath, configPath, databaseUrl, databaseUser, databasePassword, true);
        bioClimate.produceGraphs2D();
    }

    public void produceGraphs2D() throws Exception {
        DefaultCategoryDataset testpoints = new DefaultCategoryDataset();
        double[] points = Operations.parabolicInterpolation(0.1926, 0.1727, 20);
        for (int i = 0; i < points.length; ++i) {
            testpoints.addValue(points[i], (Comparable)((Object)"Points"), (Comparable)((Object)("" + i)));
        }
        BioClimateGraph lineg9 = new BioClimateGraph("parabols", Operations.getMax(points), Operations.getMin(points));
        lineg9.render((Dataset)testpoints);
    }

    public HashMap<String, Image> getProducedImages() {
        return this.producedImages;
    }

    private void produceGraphs(String[] csquareTableNames, String[] hspecTableNames, float threshold) throws Exception {
        csquareTableNames = this.checkTableNames(csquareTableNames);
        hspecTableNames = this.checkTableNames(hspecTableNames);
        this.producedImages = new HashMap();
        int numberOfTrends = this.highProbabilityCells.length;
        DefaultCategoryDataset probabilityTrend = new DefaultCategoryDataset();
        DefaultCategoryDataset discrepanciesTrend = new DefaultCategoryDataset();
        DefaultCategoryDataset avgIceD = new DefaultCategoryDataset();
        DefaultCategoryDataset avgSSTD = new DefaultCategoryDataset();
        DefaultCategoryDataset avgSalinityD = new DefaultCategoryDataset();
        for (int i = 0; i < numberOfTrends; ++i) {
            if (this.doHcafAn) {
                avgIceD.addValue(this.avgIce[i], (Comparable)((Object)"Ice Conc."), (Comparable)((Object)csquareTableNames[i]));
                avgSSTD.addValue(this.avgSST[i], (Comparable)((Object)"SST"), (Comparable)((Object)csquareTableNames[i]));
                avgSalinityD.addValue(this.avgSalinity[i], (Comparable)((Object)"Salinity"), (Comparable)((Object)csquareTableNames[i]));
            }
            if (!this.doHspecAn) continue;
            probabilityTrend.addValue((double)this.highProbabilityCells[i], (Comparable)((Object)"Number Of Cells"), (Comparable)((Object)hspecTableNames[i]));
            if (i <= 0) continue;
            discrepanciesTrend.addValue(this.discrepancies[i], (Comparable)((Object)"Mean Discrepancy Respect to Prev. Distrib."), (Comparable)((Object)this.finalDistributionTable[i]));
        }
        if (this.doHspecAn) {
            double min;
            this.discrepancies[0] = min = Operations.getMin(this.discrepancies);
            if (this.liveRender) {
                BioClimateGraph lineg1 = new BioClimateGraph(String.format(SERIES[0], Float.valueOf(threshold)), Operations.getMax(this.highProbabilityCells), Operations.getMin(this.highProbabilityCells));
                BioClimateGraph lineg4 = new BioClimateGraph(SERIES[3], Operations.getMax(this.discrepancies), min);
                lineg4.render((Dataset)discrepanciesTrend);
                lineg1.render((Dataset)probabilityTrend);
            }
            this.producedImages.put("Probability_Trend", BioClimateGraph.renderStaticImgObject(width, height, (Dataset)probabilityTrend, String.format(SERIES[0], Float.valueOf(threshold)), Operations.getMax(this.highProbabilityCells), Operations.getMin(this.highProbabilityCells)));
            this.producedImages.put("Probability_Discrepancies_Trend", BioClimateGraph.renderStaticImgObject(width, height, (Dataset)discrepanciesTrend, SERIES[3], Operations.getMax(this.discrepancies), min));
        }
        if (this.doHcafAn) {
            if (this.liveRender) {
                BioClimateGraph lineg6 = new BioClimateGraph(SERIES[5], Operations.getMax(this.avgIce), Operations.getMin(this.avgIce));
                BioClimateGraph lineg7 = new BioClimateGraph(SERIES[6], Operations.getMax(this.avgSST), Operations.getMin(this.avgSST));
                BioClimateGraph lineg8 = new BioClimateGraph(SERIES[7], Operations.getMax(this.avgSalinity), Operations.getMin(this.avgSalinity));
                lineg6.render((Dataset)avgIceD);
                lineg7.render((Dataset)avgSSTD);
                lineg8.render((Dataset)avgSalinityD);
            }
            this.producedImages.put("Average_Ice_Concentration", BioClimateGraph.renderStaticImgObject(width, height, (Dataset)avgIceD, SERIES[5], Operations.getMax(this.avgIce), Operations.getMin(this.avgIce)));
            this.producedImages.put("Average_SST", BioClimateGraph.renderStaticImgObject(width, height, (Dataset)avgSSTD, SERIES[6], Operations.getMax(this.avgSST), Operations.getMin(this.avgSST)));
            this.producedImages.put("Average_Salinity", BioClimateGraph.renderStaticImgObject(width, height, (Dataset)avgSalinityD, SERIES[7], Operations.getMax(this.avgSalinity), Operations.getMin(this.avgSalinity)));
        }
        AnalysisLogger.getLogger().trace((Object)"Produced All Images");
    }

    public void hcafEvolutionAnalysis(String[] hcafTable, String[] hcafTableNames) throws Exception {
        this.globalEvolutionAnalysis(hcafTable, null, hcafTableNames, null, null, null, 0.0f);
    }

    public void hspecEvolutionAnalysis(String[] hspecTables, String[] hspecTableNames, String probabilityColumn, String csquareColumn, float threshold) throws Exception {
        this.globalEvolutionAnalysis(null, hspecTables, null, hspecTableNames, probabilityColumn, csquareColumn, threshold);
    }

    private String[] checkTableNames(String[] tablesNames) {
        ArrayList<String> newtables = new ArrayList<String>();
        if (tablesNames == null || tablesNames.length == 0) {
            return tablesNames;
        }
        for (String table : tablesNames) {
            int i = 1;
            String originalTable = table;
            while (newtables.contains(table)) {
                table = originalTable + "_" + i;
                ++i;
            }
            newtables.add(table);
        }
        String[] tables = new String[tablesNames.length];
        for (int j = 0; j < tablesNames.length; ++j) {
            tables[j] = (String)newtables.get(j);
        }
        return tables;
    }

    public void produceCharts(HashMap<String, HashMap<String, double[]>> GeoMap, String[] tablesNames) {
        tablesNames = this.checkTableNames(tablesNames);
        this.producedImages = new HashMap();
        for (String featurename : GeoMap.keySet()) {
            DefaultCategoryDataset chart = new DefaultCategoryDataset();
            HashMap<String, double[]> timeseries = GeoMap.get(featurename);
            double absmax = -1.7976931348623157E308;
            double absmin = Double.MAX_VALUE;
            for (String timeserie : timeseries.keySet()) {
                double[] points = timeseries.get(timeserie);
                for (int i = 0; i < points.length; ++i) {
                    if (points[i] > absmax) {
                        absmax = points[i];
                    }
                    if (points[i] < absmin) {
                        absmin = points[i];
                    }
                    chart.addValue(points[i], (Comparable)((Object)timeserie), (Comparable)((Object)tablesNames[i]));
                }
            }
            if (this.liveRender) {
                BioClimateGraph lineg1 = new BioClimateGraph(featurename, absmax, absmin);
                lineg1.render((Dataset)chart);
            }
            this.producedImages.put(featurename.replace(" ", "_"), BioClimateGraph.renderStaticImgObject(width, height, (Dataset)chart, featurename, absmax, absmin));
        }
    }

    public void speciesEvolutionAnalysis(String[] hspenTables, String[] hspenTableNames, String parameterName, String condition) throws Exception {
        try {
            int numbOfTables;
            this.referencedbConnection = DatabaseFactory.initDBConnection(this.configPath + AlgorithmConfiguration.defaultConnectionFile, this.config);
            AnalysisLogger.getLogger().debug((Object)"ReferenceDB initialized");
            this.status = 0.0f;
            int n = numbOfTables = hspenTables != null ? hspenTables.length : 0;
            if (numbOfTables > 0) {
                int i;
                HashMap<String, HashMap<String, double[]>> GeoMap = new HashMap<String, HashMap<String, double[]>>();
                float statusstep = 80.0f / (float)numbOfTables;
                if (condition != null && condition.length() > 0) {
                    condition = "and " + condition;
                }
                AnalysisLogger.getLogger().trace((Object)("Range query: " + String.format(takeRangeOfParam, parameterName, hspenTables[0], condition)));
                List<Object> paramrange = DatabaseFactory.executeSQLQuery(String.format(takeRangeOfParam, parameterName, hspenTables[0], condition), this.referencedbConnection);
                int numberOfParams = paramrange.size();
                double absolutePMin = Double.parseDouble("" + paramrange.get(0));
                double absolutePMax = Double.parseDouble("" + paramrange.get(numberOfParams - 1));
                double step = (absolutePMax - absolutePMin) / (double)defaultNumOfFeatureClusters;
                int[] pClusters = new int[defaultNumOfFeatureClusters + 1];
                pClusters[0] = 0;
                for (i = 1; i < pClusters.length; ++i) {
                    double pToFind = absolutePMin + step * (double)(i + 1);
                    int k = 0;
                    for (Object row : paramrange) {
                        if (Double.parseDouble("" + row) > pToFind) break;
                        ++k;
                    }
                    if (k >= numberOfParams) {
                        k = numberOfParams - 1;
                    }
                    pClusters[i] = k;
                }
                for (i = 0; i < numbOfTables; ++i) {
                    double pmax = 0.0;
                    for (int j = 1; j < pClusters.length; ++j) {
                        String timeseries;
                        double[] elements;
                        double prevpmax = MathFunctions.roundDecimal(Double.parseDouble("" + paramrange.get(pClusters[j - 1])), 2);
                        if (prevpmax == (pmax = MathFunctions.roundDecimal(Double.parseDouble("" + paramrange.get(pClusters[j])), 2))) continue;
                        String countSpeciesQuery = String.format(countNumberOfSpeciesPerRange, hspenTables[i], prevpmax, pmax, parameterName);
                        AnalysisLogger.getLogger().trace((Object)("count elements query: " + countSpeciesQuery));
                        List<Object> elementsInRange = DatabaseFactory.executeSQLQuery(countSpeciesQuery, this.referencedbConnection);
                        int nelements = elementsInRange == null ? 0 : Integer.parseInt("" + elementsInRange.get(0));
                        AnalysisLogger.getLogger().trace((Object)("Number of elements for " + hspenTables[i] + " in (" + prevpmax + " - " + pmax + ")" + " : " + nelements));
                        String chartName = parameterName + " envelope for interval (" + prevpmax + " ; " + pmax + ")";
                        HashMap<String, Object> submap = GeoMap.get(chartName);
                        if (submap == null) {
                            submap = new HashMap();
                            GeoMap.put(chartName, submap);
                        }
                        if ((elements = submap.get(timeseries = "number of species")) == null) {
                            elements = new double[numbOfTables];
                            submap.put(timeseries, elements);
                        }
                        elements[i] = nelements;
                    }
                    this.status += statusstep;
                }
                this.status = 80.0f;
                this.produceCharts(GeoMap, hspenTableNames);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.status = 100.0f;
            try {
                this.referencedbConnection.close();
            }
            catch (Exception exception) {}
        }
    }

    public void speciesGeographicEvolutionAnalysis2(String[] hspecTables, String[] hspecTablesNames, float threshold) throws Exception {
        try {
            int numbOfTables;
            this.referencedbConnection = DatabaseFactory.initDBConnection(this.configPath + AlgorithmConfiguration.defaultConnectionFile, this.config);
            AnalysisLogger.getLogger().debug((Object)"ReferenceDB initialized");
            this.status = 0.0f;
            int n = numbOfTables = hspecTables != null ? hspecTables.length : 0;
            if (numbOfTables > 0) {
                HashMap<String, HashMap<String, double[]>> GeoMap = new HashMap<String, HashMap<String, double[]>>();
                float statusstep = 80.0f / (float)numbOfTables;
                for (int i = 0; i < numbOfTables; ++i) {
                    for (int j = 0; j < criteriaNames.length; ++j) {
                        List<Object> listCriterion = DatabaseFactory.executeSQLQuery(DatabaseUtils.getDinstictElements("hcaf_s", selectionCriteria[j], criteriaFilters[j]), this.referencedbConnection);
                        for (Object code : listCriterion) {
                            String timeseries;
                            double[] elements;
                            String code$ = "" + code;
                            String query = String.format(countProbabilityPerArea, hspecTables[i], selectionCriteria[j], code$);
                            query = query.replace("#THRESHOLD#", "" + threshold);
                            AnalysisLogger.getLogger().trace((Object)("Executing query for counting probabilities: " + query));
                            List<Object> counts = DatabaseFactory.executeSQLQuery(query, this.referencedbConnection);
                            AnalysisLogger.getLogger().trace((Object)"Query Executed");
                            int countPerArea = counts == null ? 0 : Integer.parseInt("" + counts.get(0));
                            String chartName = "Hspec (prob>0.8) for " + criteriaNames[j] + "_" + code$;
                            HashMap<String, Object> submap = GeoMap.get(chartName);
                            if (submap == null) {
                                submap = new HashMap();
                                GeoMap.put(chartName, submap);
                            }
                            if ((elements = submap.get(timeseries = "number of occupied cells")) == null) {
                                elements = new double[numbOfTables];
                                submap.put(timeseries, elements);
                            }
                            elements[i] = countPerArea;
                        }
                    }
                    this.status += statusstep;
                }
                this.status = 80.0f;
                this.produceCharts(GeoMap, hspecTablesNames);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.status = 100.0f;
            this.referencedbConnection.close();
        }
    }

    public void speciesGeographicEvolutionAnalysis(String[] hspecTables, String[] hspecTablesNames, float threshold) throws Exception {
        block14: {
            try {
                int numbOfTables;
                this.referencedbConnection = DatabaseFactory.initDBConnection(this.configPath + AlgorithmConfiguration.defaultConnectionFile, this.config);
                AnalysisLogger.getLogger().debug((Object)"ReferenceDB initialized");
                this.status = 0.0f;
                int n = numbOfTables = hspecTables != null ? hspecTables.length : 0;
                if (numbOfTables <= 0) break block14;
                HashMap<String, HashMap<String, double[]>> GeoMap = new HashMap<String, HashMap<String, double[]>>();
                float statusstep = 80.0f / (float)numbOfTables;
                for (int i = 0; i < numbOfTables; ++i) {
                    String tmpanalysisTable = "tmpanalysis" + ("" + UUID.randomUUID()).replace("-", "").replace("_", "");
                    try {
                        DatabaseFactory.executeSQLUpdate("drop table " + tmpanalysisTable, this.referencedbConnection);
                    }
                    catch (Exception ee) {
                        AnalysisLogger.getLogger().trace((Object)("table " + tmpanalysisTable + " does not exist"));
                    }
                    String preparationQuery = "create table " + tmpanalysisTable + " as select a.faoaream, lme,count(*) from %1$s as a where a.probability > #THRESHOLD# group by faoaream,lme;";
                    preparationQuery = String.format(preparationQuery, hspecTables[i]);
                    preparationQuery = preparationQuery.replace("#THRESHOLD#", "" + threshold);
                    AnalysisLogger.getLogger().trace((Object)("Executing query for counting probabilities: " + preparationQuery));
                    DatabaseFactory.executeSQLUpdate(preparationQuery, this.referencedbConnection);
                    AnalysisLogger.getLogger().trace((Object)"Query Executed");
                    for (int j = 0; j < criteriaNames.length; ++j) {
                        String criteriaQuery = String.format("select %1$s,sum(count) from " + tmpanalysisTable + " %2$s group by %1$s;", selectionCriteria[j], criteriaFilters[j]);
                        AnalysisLogger.getLogger().trace((Object)("Executing query for counting probabilities: " + criteriaQuery));
                        List<Object> codeSums = DatabaseFactory.executeSQLQuery(criteriaQuery, this.referencedbConnection);
                        for (Object codeSum : codeSums) {
                            String timeseries;
                            double[] elements;
                            String code$ = "" + ((Object[])codeSum)[0];
                            int countPerArea = ((Object[])codeSum)[1] == null ? 0 : Integer.parseInt("" + ((Object[])codeSum)[1]);
                            AnalysisLogger.getLogger().trace((Object)("Analyzing " + selectionCriteria[j] + " with code " + code$ + " count " + countPerArea));
                            String chartName = "Hspec (prob>0.8) for " + criteriaNames[j] + "_" + code$;
                            HashMap<String, Object> submap = GeoMap.get(chartName);
                            if (submap == null) {
                                submap = new HashMap();
                                GeoMap.put(chartName, submap);
                            }
                            if ((elements = submap.get(timeseries = "number of occupied cells")) == null) {
                                elements = new double[numbOfTables];
                                submap.put(timeseries, elements);
                            }
                            elements[i] = countPerArea;
                        }
                    }
                    try {
                        DatabaseFactory.executeSQLUpdate("drop table " + tmpanalysisTable, this.referencedbConnection);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                        AnalysisLogger.getLogger().trace((Object)("table " + tmpanalysisTable + " does not exist"));
                    }
                    this.status += statusstep;
                }
                this.status = 80.0f;
                this.produceCharts(GeoMap, hspecTablesNames);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                this.status = 100.0f;
                this.referencedbConnection.close();
            }
        }
    }

    public void geographicEvolutionAnalysis(String[] hcafTable, String[] hcafTableNames) throws Exception {
        try {
            int numbOfTables;
            this.referencedbConnection = DatabaseFactory.initDBConnection(this.configPath + AlgorithmConfiguration.defaultConnectionFile, this.config);
            AnalysisLogger.getLogger().debug((Object)"ReferenceDB initialized");
            this.doHcafAn = true;
            this.doHspecAn = true;
            this.status = 0.0f;
            this.csquareTable = hcafTable;
            int n = numbOfTables = hcafTable != null ? hcafTable.length : 0;
            if (numbOfTables > 0) {
                HashMap<String, HashMap<String, double[]>> GeoMap = new HashMap<String, HashMap<String, double[]>>();
                float statusstep = 80.0f / (float)numbOfTables;
                for (int i = 0; i < numbOfTables; ++i) {
                    for (int j = 0; j < criteriaNames.length; ++j) {
                        for (int k = 0; k < quantitiesNames.length; ++k) {
                            String query = String.format(takeAvgSelection, quantitiesNames[k], selectionCriteria[j], hcafTable[i], criteriaFilters[j]);
                            AnalysisLogger.getLogger().debug((Object)("Query to be executed : " + query));
                            List<Object> quantityCriterion = DatabaseFactory.executeSQLQuery(query, this.referencedbConnection);
                            for (Object element : quantityCriterion) {
                                String timeseries;
                                double[] elements;
                                Object[] row = (Object[])element;
                                double value = row[0] == null ? 0.0 : Double.parseDouble("" + row[0]);
                                String code = "" + row[1];
                                String chartName = timeseriesNames[k] + " for " + criteriaNames[j] + "_" + code;
                                HashMap<String, Object> submap = GeoMap.get(chartName);
                                if (submap == null) {
                                    submap = new HashMap();
                                    GeoMap.put(chartName, submap);
                                }
                                if ((elements = (double[])submap.get(timeseries = criteriaNames[j] + "_" + code)) == null) {
                                    elements = new double[numbOfTables];
                                    submap.put(timeseries, elements);
                                }
                                elements[i] = value;
                            }
                        }
                    }
                    this.status += statusstep;
                }
                this.status = 80.0f;
                this.produceCharts(GeoMap, hcafTableNames);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.status = 100.0f;
            this.referencedbConnection.close();
        }
    }

    public void globalEvolutionAnalysis(String[] hcafTable, String[] hspecTables, String[] hcafTablesNames, String[] hspecTableNames, String probabilityColumn, String csquareColumn, float threshold) throws Exception {
        try {
            this.referencedbConnection = DatabaseFactory.initDBConnection(this.configPath + AlgorithmConfiguration.defaultConnectionFile, this.config);
            AnalysisLogger.getLogger().debug((Object)"ReferenceDB initialized");
            this.doHcafAn = true;
            this.doHspecAn = true;
            if (hcafTable == null) {
                this.doHcafAn = false;
            }
            if (hspecTables == null) {
                this.doHspecAn = false;
            }
            this.status = 0.0f;
            this.csquareTable = hcafTable;
            this.finalDistributionTable = hspecTables;
            int numbOfPoints = hcafTable != null ? hcafTable.length : hspecTables.length;
            this.highProbabilityCells = new int[numbOfPoints];
            this.discrepancies = new double[numbOfPoints];
            this.avgIce = new double[numbOfPoints];
            this.avgSST = new double[numbOfPoints];
            this.avgSalinity = new double[numbOfPoints];
            float statusstep = 80.0f / (float)numbOfPoints;
            for (int i = 0; i < numbOfPoints; ++i) {
                if (this.doHspecAn) {
                    this.highProbabilityCells[i] = this.calcHighProbabilityCells(hspecTables[i], threshold);
                }
                if (this.doHcafAn) {
                    this.avgIce[i] = this.avgValue(hcafTable[i], FIELD.iceconann.name());
                    this.avgSST[i] = this.avgValue(hcafTable[i], FIELD.sstanmean.name());
                    this.avgSalinity[i] = this.avgValue(hcafTable[i], FIELD.salinitymean.name());
                    AnalysisLogger.getLogger().trace((Object)("(" + hcafTable[i] + "): " + " ICE " + this.avgIce[i] + " SST " + this.avgSST[i] + " SAL " + this.avgSalinity[i]));
                }
                if (this.doHspecAn) {
                    this.discrepancies[i] = i == 0 ? 1.0 : (double)(this.highProbabilityCells[i] - this.highProbabilityCells[i - 1]);
                    AnalysisLogger.getLogger().trace((Object)("(" + hspecTables[i] + "): DISCREPANCY " + this.discrepancies[i] + " HIGH PROB CELLS " + this.highProbabilityCells[i]));
                }
                this.status += statusstep;
            }
            this.status = 80.0f;
            this.produceGraphs(hcafTablesNames, hspecTableNames, threshold);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.status = 100.0f;
            try {
                this.referencedbConnection.close();
            }
            catch (Exception exception) {}
        }
    }

    public BioClimateAnalysis(String configPath, String persistencePath, String databaseURL, String databaseUserName, String databasePassword, boolean liveRender) throws Exception {
        this.configPath = configPath;
        this.temporaryDirectory = persistencePath;
        if (!configPath.endsWith("/")) {
            configPath = configPath + "/";
        }
        if (!persistencePath.endsWith("/")) {
            this.temporaryDirectory = this.temporaryDirectory + "/";
        }
        AnalysisLogger.setLogger(configPath + AlgorithmConfiguration.defaultLoggerFile);
        this.config = new LexicalEngineConfiguration();
        this.config.setDatabaseURL(databaseURL);
        this.config.setDatabaseUserName(databaseUserName);
        this.config.setDatabasePassword(databasePassword);
        this.liveRender = liveRender;
    }

    public int calcHighProbabilityCells(String hspec, double probabilty) throws Exception {
        AnalysisLogger.getLogger().trace((Object)("Calculating High Prob Cells: " + String.format(countHighProbabilityCells, hspec, probabilty)));
        List<Object> countage = DatabaseFactory.executeSQLQuery(String.format(countHighProbabilityCells, hspec, probabilty), this.referencedbConnection);
        int count = Integer.parseInt("" + countage.get(0));
        AnalysisLogger.getLogger().trace((Object)("Calc High Prob Cells: " + count));
        return count;
    }

    public double avgValue(String hcaf1, String field) throws Exception {
        List<Object> countage = DatabaseFactory.executeSQLQuery(String.format(meanVal, hcaf1, field), this.referencedbConnection);
        double count = 0.0;
        if (countage != null && countage.size() > 0) {
            count = Double.parseDouble("" + countage.get(0));
        }
        return count;
    }

    public int countIceLeakageCells(String hcaf1, String hcaf2) throws Exception {
        List<Object> countage = DatabaseFactory.executeSQLQuery(String.format(iceLeakage, hcaf1, hcaf2), this.referencedbConnection);
        int count = Integer.parseInt("" + countage.get(0));
        return count;
    }

    public int countSeaCells(String hcaf1, String hcaf2, double threshold) throws Exception {
        List<Object> countage = DatabaseFactory.executeSQLQuery(String.format(countSeaCells, hcaf1, hcaf2, threshold), this.referencedbConnection);
        int count = Integer.parseInt("" + countage.get(0));
        return count;
    }

    public float getStatus() {
        return this.status;
    }

    public double calcOverDiscrepancy(String configPath, String persistencePath, String firstTable, String secondTable, String probabilityColumnName, String csquareColumn, float comparisonThreshold) throws Exception {
        List<Object> nelementsQ1 = DatabaseFactory.executeSQLQuery(DatabaseUtils.countElementsStatement(firstTable), this.referencedbConnection);
        int nelements = Integer.parseInt("" + nelementsQ1.get(0));
        AnalysisLogger.getLogger().trace((Object)("Number Of elements1: " + nelementsQ1));
        List<Object> nelementsQ2 = DatabaseFactory.executeSQLQuery(DatabaseUtils.countElementsStatement(secondTable), this.referencedbConnection);
        int nelements2 = Integer.parseInt("" + nelementsQ2.get(0));
        AnalysisLogger.getLogger().trace((Object)("Number Of elements2: " + nelementsQ1));
        List<Object> sumFirst = DatabaseFactory.executeSQLQuery(DatabaseUtils.sumElementsStatement(firstTable, probabilityColumnName), this.referencedbConnection);
        double sum1 = Double.parseDouble("" + sumFirst.get(0));
        AnalysisLogger.getLogger().trace((Object)("Sum1: " + sum1));
        List<Object> sumSecond = DatabaseFactory.executeSQLQuery(DatabaseUtils.sumElementsStatement(secondTable, probabilityColumnName), this.referencedbConnection);
        double sum2 = Double.parseDouble("" + sumSecond.get(0));
        AnalysisLogger.getLogger().trace((Object)("Sum2: " + sum1));
        double d = (sum2 - sum1) / (double)(nelements + nelements2);
        return d;
    }

    public double calcDiscrepancy(String configPath, String persistencePath, String firstTable, String secondTable, String probabilityColumnName, String csquareColumn, float comparisonThreshold) throws Exception {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath(configPath);
        config.setPersistencePath(persistencePath);
        config.setNumberOfResources(1);
        config.setAgent("DISCREPANCY_ANALYSIS");
        config.setParam("FirstTable", firstTable);
        config.setParam("SecondTable", secondTable);
        config.setParam("FirstTableCsquareColumn", csquareColumn);
        config.setParam("SecondTableCsquareColumn", csquareColumn);
        config.setParam("FirstTableProbabilityColumn", probabilityColumnName);
        config.setParam("SecondTableProbabilityColumn", probabilityColumnName);
        config.setParam("ComparisonThreshold", "" + comparisonThreshold);
        config.setParam("MaxSamples", "30000");
        this.eval = EvaluatorsFactory.getEvaluators(config).get(0);
        this.eval.compute();
        PrimitiveType output = (PrimitiveType)this.eval.getOutput();
        HashMap out = (HashMap)output.getContent();
        Double d = Double.parseDouble((String)out.get("MEAN"));
        return d;
    }

    private static enum FIELD {
        iceconann,
        sstanmean,
        salinitymean;

    }
}

