/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.timeseries.charts.support.types;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.gcube.portlets.user.timeseries.charts.support.assertions.Assertion;
import org.gcube.portlets.user.timeseries.charts.support.exceptions.InvalidParameterException;
import org.gcube.portlets.user.timeseries.charts.support.types.ValueEntry;

public class Point<S extends Number, T extends Number>
implements Serializable {
    private static final long serialVersionUID = 6164075295272357264L;
    private String label = null;
    private S value = null;
    private List<ValueEntry<T>> entries = new Vector<ValueEntry<T>>();

    public Point() {
    }

    public Point(S value) throws InvalidParameterException {
        this.setValue(value);
    }

    public Point(String label, S value) throws InvalidParameterException {
        this(value);
        this.setLabel(label);
    }

    public Point(S value, ValueEntry<T> ... entries) throws InvalidParameterException {
        this(value);
        this.setEntries(entries);
    }

    public Point(String label, S value, ValueEntry<T> ... entries) throws InvalidParameterException {
        this(label, value);
        this.setEntries(entries);
    }

    public final void setLabel(String label) {
        if (label != null) {
            this.label = label.trim();
        }
    }

    public final void setValue(S value) throws InvalidParameterException {
        Assertion<InvalidParameterException> checker = new Assertion<InvalidParameterException>();
        checker.validate(value != null, new InvalidParameterException("Invalid parameter value. Null not allowed."));
        this.value = value;
    }

    public final S getValue() {
        return this.value;
    }

    public final void addEntry(ValueEntry<T> entry) {
        this.entries.add(entry);
    }

    public final void setEntries(ValueEntry<T> ... entries) {
        if (entries != null) {
            ValueEntry<T>[] valueEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                ValueEntry<T> t = valueEntryArray[n2];
                this.entries.add(t);
                ++n2;
            }
        }
    }

    public final void sortEntries() {
        Collections.sort(this.entries, new Comparator<ValueEntry<T>>(){

            @Override
            public int compare(ValueEntry<T> o1, ValueEntry<T> o2) {
                ((Number)o1.getValue()).doubleValue();
                return 0;
            }
        });
    }

    public final List<ValueEntry<T>> getEntries() {
        return this.entries;
    }

    public final String getLabel() {
        return this.label;
    }

    public final String toString() {
        StringBuilder retval = new StringBuilder("[" + (this.label != null ? this.label : "N/D") + "] {");
        for (ValueEntry<T> yValue : this.getEntries()) {
            retval.append(String.valueOf(yValue.toString()) + " ");
        }
        retval.append("}");
        return retval.toString();
    }
}

