/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.transducers.charts;

import java.awt.Image;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.contentmanagement.graphtools.plotting.graphs.TimeSeriesGraph;
import org.gcube.contentmanagement.graphtools.plotting.graphs.TransectLineGraph;
import org.gcube.contentmanagement.graphtools.utils.DateGuesser;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.transducers.charts.QuantitiesAttributesChartsTransducerer;
import org.gcube.dataanalysis.ecoengine.utils.Operations;
import org.gcube.dataanalysis.ecoengine.utils.TimeAnalyzer;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;

public class TimeSeriesChartsTransducerer
extends QuantitiesAttributesChartsTransducerer {
    protected String timepattern = "";
    protected SimpleDateFormat formatter = null;
    protected Date sampleTime = null;
    protected int maxvisualizable = 100;

    @Override
    protected void setInputParameters() {
        ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
        templates.add(TableTemplates.GENERIC);
        InputTable tinput = new InputTable(templates, inputTableParameter, "The input table");
        this.inputs.add(tinput);
        ColumnTypesList p1 = new ColumnTypesList(inputTableParameter, attributesParameter, "The dimensions to consider in the charts", true);
        ColumnTypesList p2 = new ColumnTypesList(inputTableParameter, quantitiesParameter, "The numeric quantities to visualize ", false);
        this.inputs.add(p1);
        this.inputs.add(p2);
        ColumnType p3 = new ColumnType(inputTableParameter, timeParameter, "The column containing time information", "year", false);
        this.inputs.add(p3);
        DatabaseType.addDefaultDBPars(this.inputs);
    }

    @Override
    public String getDescription() {
        return "An algorithm producing time series charts of attributes vs. quantities. Charts are displayed per quantity column and superposing quantities are summed.";
    }

    public Date getTime(String timel) {
        try {
            if (this.formatter == null) {
                TimeAnalyzer analyzer = new TimeAnalyzer();
                this.sampleTime = analyzer.string2Date(timel);
                this.timepattern = analyzer.getPattern();
                AnalysisLogger.getLogger().debug((Object)("TimeSeriesChart: Time pattern: " + this.timepattern));
                this.formatter = new SimpleDateFormat(this.timepattern);
            }
            return this.formatter.parse(timel);
        }
        catch (ParseException e) {
            AnalysisLogger.getLogger().debug((Object)("Error parsing date " + timel + " using pattern " + this.timepattern));
            return null;
        }
    }

    public String getChartPattern(Date time) {
        if (this.timepattern.equals("s") || DateGuesser.isJavaDateOrigin(time)) {
            return "HH:mm:ss:SS";
        }
        if (this.timepattern.length() == 4) {
            return "yyyy";
        }
        return "MM-dd-yy";
    }

    @Override
    public LinkedHashMap<String, Object> createCharts(String[] dimensions, String quantity, String time, List<Object> rows, boolean displaychart) {
        if (dimensions == null) {
            dimensions = new String[]{};
        }
        LinkedHashMap<String, Object> charts = new LinkedHashMap<String, Object>();
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        TimeSeries series = null;
        series = dimensions.length > 0 ? new TimeSeries((Comparable)((Object)("Trend of " + quantity + " for " + Arrays.toString(dimensions).replace("[", "").replace("]", "")))) : new TimeSeries((Comparable)((Object)("Trend of " + quantity)));
        dataset.addSeries(series);
        DefaultCategoryDataset[] linedatasets = new DefaultCategoryDataset[dimensions.length];
        int nrows = rows.size();
        int[] indicesToTake = null;
        indicesToTake = nrows > this.maxvisualizable ? Operations.uniformIntegerSampling(0.0, nrows - 1, this.maxvisualizable) : Operations.uniformIntegerSampling(0.0, nrows - 1, nrows);
        AnalysisLogger.getLogger().debug((Object)("TimeSeriesChartsTransducerer: uniform sampling - taking " + indicesToTake.length + " over " + nrows));
        for (int i = 0; i < indicesToTake.length; ++i) {
            Object row = rows.get(indicesToTake[i]);
            Object[] array = (Object[])row;
            Double q = null;
            Date timeD = null;
            String timel = "" + array[array.length - 1];
            try {
                q = Double.parseDouble("" + array[array.length - 2]);
                timeD = this.getTime(timel);
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().debug((Object)("TimeSeriesChartsTransducerer: warning skipping value " + q + "," + timel));
            }
            if (q == null || timeD == null) continue;
            FixedMillisecond ms = new FixedMillisecond(timeD);
            TimeSeriesDataItem item = series.getDataItem((RegularTimePeriod)ms);
            if (item != null) {
                double prevquant = (Double)item.getValue();
                q = prevquant + q;
                AnalysisLogger.getLogger().debug((Object)("TimeSeriesChartsTransducerer: a previous quantity was found for time " + timel + " : " + prevquant + " setting to " + (prevquant + q)));
                item.setValue((Number)q);
            } else {
                series.add((RegularTimePeriod)ms, (Number)q);
            }
            for (int dimIdx = 0; dimIdx < dimensions.length; ++dimIdx) {
                String dimensionValue = "";
                if (array[dimIdx] != null) {
                    dimensionValue = "" + array[dimIdx];
                }
                if (dimensionValue.length() <= 0) continue;
                DefaultCategoryDataset lineds = linedatasets[dimIdx];
                if (lineds == null) {
                    linedatasets[dimIdx] = lineds = new DefaultCategoryDataset();
                }
                lineds.addValue((Number)q, (Comparable)((Object)"singlets"), (Comparable)((Object)(timel + ";[" + dimensionValue + "]")));
            }
        }
        if (this.sampleTime != null) {
            Image chartTS = ImageTools.toImage(TimeSeriesGraph.createStaticChart((Dataset)dataset, this.getChartPattern(this.sampleTime), "Variation of " + quantity).createBufferedImage(1200, 960));
            if (displaychart) {
                TimeSeriesGraph tsg = new TimeSeriesGraph("Variation of " + quantity);
                tsg.timeseriesformat = this.getChartPattern(this.sampleTime);
                tsg.render((Dataset)dataset);
                for (int i = 0; i < dimensions.length; ++i) {
                    TransectLineGraph tlg = new TransectLineGraph("Variation of " + dimensions[i]);
                    tlg.render((Dataset)TransectLineGraph.orderByTime(linedatasets[i], this.timepattern));
                }
            }
            charts.put("Time trend of " + quantity, chartTS);
            for (int i = 0; i < dimensions.length; ++i) {
                Image linechartTS = ImageTools.toImage(TransectLineGraph.createStaticChart((Dataset)TransectLineGraph.orderByTime(linedatasets[i], this.timepattern)).createBufferedImage(1200, 960));
                charts.put("Annotated chart of " + quantity + " for " + dimensions[i], linechartTS);
            }
        }
        return charts;
    }
}

