/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.data;

import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.graphtools.abstracts.SamplesTable;
import org.gcube.portlets.user.timeseries.charts.support.types.Point;
import org.gcube.portlets.user.timeseries.charts.support.types.ValueEntry;

public class GraphSamplesTable
extends SamplesTable {
    List<Point<? extends Number, ? extends Number>> singlegraph;

    public GraphSamplesTable(List<Point<? extends Number, ? extends Number>> graph) {
        this.singlegraph = graph;
    }

    public GraphSamplesTable() {
        this.singlegraph = new ArrayList<Point<? extends Number, ? extends Number>>();
    }

    public GraphSamplesTable(String seriesName, List<String> xLables, List<Double> yValues, boolean invert) {
        this.singlegraph = new ArrayList<Point<? extends Number, ? extends Number>>();
        int size = xLables.size();
        try {
            if (invert) {
                Point<Double, Number> p = new Point<Double, Number>(seriesName, 0.0);
                int i = 0;
                while (i < size) {
                    ValueEntry<Number> v = new ValueEntry<Number>(xLables.get(i), yValues.get(i));
                    p.addEntry(v);
                    ++i;
                }
                this.singlegraph.add(p);
            } else {
                int i = 0;
                while (i < size) {
                    Point<Double, Number> p = new Point<Double, Number>(xLables.get(i), new Double(i));
                    ValueEntry<Number> v = new ValueEntry<Number>("series1", yValues.get(i));
                    p.addEntry(v);
                    this.singlegraph.add(p);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int getNumOfAttributes() {
        if (this.singlegraph.size() > 0) {
            return this.singlegraph.get(0).getEntries().size() + 1;
        }
        return 0;
    }

    @Override
    public int getNumOfDataRows() {
        return this.singlegraph.size();
    }

    @Override
    public double getValue(int d, int a) {
        Double doub = a == 0 ? (Double)this.singlegraph.get(d).getValue() : (Double)this.singlegraph.get(d).getEntries().get(a - 1).getValue();
        return doub;
    }

    @Override
    public String getClassification(int d) {
        StringBuffer sb = new StringBuffer();
        int numbOfColumns = this.getNumOfAttributes();
        sb.append(String.valueOf(this.singlegraph.get(d).getLabel()) + ";");
        int i = 0;
        while (i < numbOfColumns - 1) {
            sb.append(this.singlegraph.get(d).getEntries().get(i).getLabel());
            if (i < numbOfColumns - 2) {
                sb.append(";");
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void addLabel(int i, String label) {
        this.singlegraph.get(i).setLabel(label);
    }

    @Override
    public void addSample(int i, int j, double value) {
        try {
            if (j == 0) {
                Point<? extends Number, ? extends Number> p = this.singlegraph.get(i);
                p.setValue((Number)value);
            } else {
                Point<? extends Number, ? extends Number> p = this.singlegraph.get(i);
                p.getEntries().get(j - 1).setValue(new Double(value));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addSampleRow(String label, double ... values) {
        try {
            Double x = values[0];
            Double y1 = 0.0;
            if (values.length > 1) {
                y1 = values[1];
            }
            String[] lables = label.split(";");
            int labsize = lables.length;
            String labelx = lables[0];
            String labely1 = lables[1];
            ValueEntry<Double> ve = new ValueEntry<Double>(labely1, y1);
            Point p = new Point(labelx, x, ve);
            int j = 2;
            while (j < labsize) {
                Double y = new Double(0.0);
                if (values.length > j) {
                    y = values[j];
                }
                p.getEntries().add(new ValueEntry<Double>(lables[j], y));
                ++j;
            }
            this.singlegraph.add(p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Point<? extends Number, ? extends Number>> getGraph() {
        return this.singlegraph;
    }
}

