/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.transducers.charts;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.contentmanagement.graphtools.plotting.graphs.GaussianDistributionGraph;
import org.gcube.contentmanagement.graphtools.plotting.graphs.HistogramGraph;
import org.gcube.contentmanagement.graphtools.plotting.graphs.RadarGraph;
import org.gcube.contentmanagement.graphtools.plotting.graphs.ScatterGraphGeneric;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.transducers.charts.AbstractChartsProducer;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.function.Function2D;
import org.jfree.data.function.NormalDistributionFunction2D;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class QuantitiesAttributesChartsTransducerer
extends AbstractChartsProducer {
    @Override
    protected void setInputParameters() {
        ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
        templates.add(TableTemplates.GENERIC);
        InputTable tinput = new InputTable(templates, inputTableParameter, "The input table");
        this.inputs.add(tinput);
        ColumnTypesList p1 = new ColumnTypesList(inputTableParameter, attributesParameter, "The dimensions to consider in the charts", true);
        ColumnTypesList p2 = new ColumnTypesList(inputTableParameter, quantitiesParameter, "The numeric quantities to visualize ", false);
        this.inputs.add(p1);
        this.inputs.add(p2);
        DatabaseType.addDefaultDBPars(this.inputs);
    }

    @Override
    public String getDescription() {
        return "An algorithm producing generic charts of attributes vs. quantities. Charts are displayed per quantity column. Histograms, Scattering and Radar charts are produced for the top ten quantities. A gaussian distribution reports overall statistics for the quantities.";
    }

    @Override
    public Image[] createCharts(String[] dimensions, String quantity, String time, List<Object> rows, boolean displaychart) {
        if (dimensions == null) {
            dimensions = new String[]{};
        }
        DefaultCategoryDataset datasetHisto = new DefaultCategoryDataset();
        for (Object row : rows) {
            Object[] array = (Object[])row;
            Double q = null;
            try {
                q = Double.parseDouble("" + array[array.length - 1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (q == null) continue;
            int dimIdx = 0;
            String[] stringArray = dimensions;
            int n = dimensions.length;
            int n2 = 0;
            while (n2 < n) {
                String dimension = stringArray[n2];
                String dimensionValue = "";
                if (array[dimIdx] != null) {
                    dimensionValue = "" + array[dimIdx];
                }
                if (dimensionValue.length() > 0) {
                    datasetHisto.addValue((Number)q, (Comparable)((Object)dimensionValue), (Comparable)((Object)dimension));
                }
                ++dimIdx;
                ++n2;
            }
        }
        List<Object> meanvar = DatabaseFactory.executeSQLQuery("select avg(" + quantity + "), variance(" + quantity + ") from " + IOHelper.getInputParameter(this.config, inputTableParameter), this.connection);
        Object[] meanvarsrow = (Object[])meanvar.get(0);
        double mean = MathFunctions.roundDecimal(Double.parseDouble("" + meanvarsrow[0]), 2);
        double variance = MathFunctions.roundDecimal(Math.sqrt(Double.parseDouble("" + meanvarsrow[1])), 2);
        AnalysisLogger.getLogger().debug((Object)("QuantitiesAttributesCharts: " + mean + " and variance:" + variance));
        NormalDistributionFunction2D normaldistributionfunction2d = new NormalDistributionFunction2D(mean, variance);
        XYSeries gaussianxyseries = DatasetUtilities.sampleFunction2DToSeries((Function2D)normaldistributionfunction2d, (double)(mean - 2.0 * variance), (double)(mean + 2.0 * variance), (int)121, (Comparable)((Object)("Distribution of " + quantity)));
        XYSeriesCollection gaussianxyseriescollection = new XYSeriesCollection();
        gaussianxyseriescollection.addSeries(gaussianxyseries);
        Image charthisto = null;
        Image chartscattering = null;
        Image chartradar = null;
        if (dimensions.length > 0) {
            charthisto = ImageTools.toImage(HistogramGraph.createStaticChart((Dataset)datasetHisto).createBufferedImage(680, 420));
            chartscattering = ImageTools.toImage(ScatterGraphGeneric.createStaticChart((Dataset)datasetHisto).createBufferedImage(680, 420));
            chartradar = ImageTools.toImage(RadarGraph.createStaticChart((Dataset)datasetHisto).createBufferedImage(680, 420));
        }
        Image chartgaussian = ImageTools.toImage(GaussianDistributionGraph.createStaticChart((Dataset)gaussianxyseriescollection, mean, variance).createBufferedImage(680, 420));
        if (displaychart) {
            HistogramGraph tsg = new HistogramGraph("QuantitiesAttributesHistogram");
            tsg.render((Dataset)datasetHisto);
            ScatterGraphGeneric scatter = new ScatterGraphGeneric("QuantitiesAttributesScattering");
            scatter.render((Dataset)datasetHisto);
            RadarGraph radar = new RadarGraph("QuantitiesAttributesRadar");
            radar.render((Dataset)datasetHisto);
            GaussianDistributionGraph gaussian = new GaussianDistributionGraph("Gaussian");
            gaussian.mean = mean;
            gaussian.variance = variance;
            gaussian.render((Dataset)gaussianxyseriescollection);
        }
        Image[] charts = new Image[]{charthisto, chartscattering, chartradar, chartgaussian};
        return charts;
    }
}

