/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.transducers;

import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.TablesList;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.evaluation.bioclimate.BioClimateAnalysis;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.utils.ResourceFactory;

public class BioClimateHSPECTransducer
implements Transducerer {
    protected HashMap<String, Image> producedImages;
    protected AlgorithmConfiguration config;
    protected BioClimateAnalysis bioClimate;
    private String[] hspecTables;
    private String[] hspecTablesNames;
    protected float status = 0.0f;
    ResourceFactory resourceManager;

    @Override
    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.LOCAL;
    }

    @Override
    public void init() throws Exception {
        this.bioClimate = new BioClimateAnalysis(this.config.getConfigPath(), this.config.getPersistencePath(), this.config.getParam("DatabaseURL"), this.config.getParam("DatabaseUserName"), this.config.getParam("DatabasePassword"), false);
        this.hspecTables = this.config.getParam("HSPEC_Table_List").split(AlgorithmConfiguration.getListSeparator());
        this.hspecTablesNames = this.config.getParam("HSPEC_Table_Names").split(AlgorithmConfiguration.getListSeparator());
    }

    @Override
    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public float getStatus() {
        if (this.status > 0.0f && this.status < 100.0f) {
            return Math.min(this.bioClimate.getStatus(), 95.0f);
        }
        return this.status;
    }

    @Override
    public String getDescription() {
        return "A transducer algorithm that generates a table containing an estimate of species distributions per half-degree cell (HSPEC) in time. Evaluates the climatic changes impact on species presence.";
    }

    @Override
    public List<StatisticalType> getInputParameters() {
        ArrayList<StatisticalType> parameters = new ArrayList<StatisticalType>();
        ArrayList<TableTemplates> templateHspec = new ArrayList<TableTemplates>();
        templateHspec.add(TableTemplates.HSPEC);
        TablesList p7 = new TablesList(templateHspec, "HSPEC_Table_List", "List of HSPEC tables to analyze", false);
        PrimitiveTypesList p8 = new PrimitiveTypesList(String.class.getName(), PrimitiveTypes.STRING, "HSPEC_Table_Names", "list of HSPEC table names to be used as labels", false);
        PrimitiveType p9 = new PrimitiveType(Double.class.getName(), null, PrimitiveTypes.NUMBER, "Threshold", "a threshold of probability over which the abundancy per species will be calculated", "0.5");
        parameters.add(p7);
        parameters.add(p8);
        parameters.add(p9);
        DatabaseType.addDefaultDBPars(parameters);
        return parameters;
    }

    @Override
    public StatisticalType getOutput() {
        String name = HashMap.class.getName();
        PrimitiveType p = new PrimitiveType(name, this.producedImages, PrimitiveTypes.IMAGES, "Charts", "A map with keys and Images");
        return p;
    }

    @Override
    public void compute() throws Exception {
        this.status = 0.1f;
        try {
            try {
                float threshold = Float.parseFloat(this.config.getParam("Threshold"));
                this.bioClimate.globalEvolutionAnalysis(null, this.hspecTables, null, this.hspecTablesNames, "probability", "csquare", threshold);
                this.producedImages = this.bioClimate.getProducedImages();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            this.status = 100.0f;
        }
    }

    @Override
    public String getResourceLoad() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceFactory();
        }
        return this.resourceManager.getResourceLoad(1);
    }

    @Override
    public String getResources() {
        return ResourceFactory.getResources(100.0f);
    }
}

