/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.evaluation.bioclimate;

import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.DataTypeRecognizer;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.Operations;
import org.hibernate.SessionFactory;

public class InterpolateTables {
    protected String temporaryDirectory;
    public static String selectElementsQuery = "select %1$s from %2$s order by %3$s";
    public static String selectDestElementsQuery = "select %1$s from %2$s where %3$s";
    public float status;
    private String[] interpolatedTables;
    private LexicalEngineConfiguration config;
    protected SessionFactory referencedbConnection;
    private String configPath;
    private File[] producedfiles;

    public String[] getInterpolatedTables() {
        return this.interpolatedTables;
    }

    public InterpolateTables(String configPath, String persistencePath, String databaseURL, String databaseUserName, String databasePassword) throws Exception {
        this.configPath = configPath;
        this.temporaryDirectory = persistencePath;
        if (!configPath.endsWith("/")) {
            configPath = String.valueOf(configPath) + "/";
        }
        if (!persistencePath.endsWith("/")) {
            this.temporaryDirectory = String.valueOf(this.temporaryDirectory) + "/";
        }
        AnalysisLogger.setLogger(String.valueOf(configPath) + AlgorithmConfiguration.defaultLoggerFile);
        AnalysisLogger.getLogger().debug((Object)("Initialization complete: persistence path " + persistencePath));
        this.config = new LexicalEngineConfiguration();
        this.config.setDatabaseURL(databaseURL);
        this.config.setDatabaseUserName(databaseUserName);
        this.config.setDatabasePassword(databasePassword);
    }

    public void interpolate(String table1, String table2, int intervals, INTERPOLATIONFUNCTIONS function, int startYear, int endYear) throws Exception {
        block21: {
            try {
                try {
                    if (intervals == 1) {
                        this.interpolatedTables = new String[2];
                        this.interpolatedTables[0] = table1;
                        this.interpolatedTables[1] = table2;
                        AnalysisLogger.getLogger().debug((Object)"NO TABLES TO PRODUCE");
                        break block21;
                    }
                    this.referencedbConnection = DatabaseFactory.initDBConnection(String.valueOf(this.configPath) + AlgorithmConfiguration.defaultConnectionFile, this.config);
                    AnalysisLogger.getLogger().debug((Object)"ReferenceDB initialized");
                    this.status = 0.0f;
                    AnalysisLogger.getLogger().debug((Object)("Interpolating from " + table1 + " to " + table2));
                    DatabaseUtils utils = new DatabaseUtils(this.referencedbConnection);
                    String createTableStatement = utils.buildCreateStatement(table1, "%1$s");
                    AnalysisLogger.getLogger().debug((Object)("Create Statement for table " + table1 + ": " + createTableStatement));
                    int numberOfColumns = utils.getColumnDecriptions().size();
                    ArrayList<List<StringBuffer>> outputFiles = new ArrayList<List<StringBuffer>>();
                    int g = 0;
                    while (g < intervals - 2) {
                        outputFiles.add(new ArrayList());
                        ++g;
                    }
                    float statusstep = 60.0f / (float)numberOfColumns;
                    int j = 0;
                    while (j < numberOfColumns) {
                        String gotColumn = utils.getColumnName(j);
                        String gotColumnType = utils.getColumnType(j);
                        String javatype = DataTypeRecognizer.transformTypeFromDB(gotColumnType);
                        String takeF = DatabaseUtils.getOrderedElements(table1, utils.getPrimaryKey(), gotColumn);
                        String takeS = DatabaseUtils.getOrderedElements(table2, utils.getPrimaryKey(), gotColumn);
                        AnalysisLogger.getLogger().debug((Object)("Taking First column->" + takeF));
                        AnalysisLogger.getLogger().debug((Object)("Taking Second column->" + takeS));
                        List<Object> takeFirstColumn = DatabaseFactory.executeSQLQuery(takeF, this.referencedbConnection);
                        List<Object> takeSecondColumn = DatabaseFactory.executeSQLQuery(takeS, this.referencedbConnection);
                        AnalysisLogger.getLogger().debug((Object)("First column elements size->" + takeFirstColumn.size()));
                        AnalysisLogger.getLogger().debug((Object)("Second column elements size->" + takeSecondColumn.size()));
                        if (javatype.equals(BigDecimal.class.getName())) {
                            AnalysisLogger.getLogger().debug((Object)("interpolating -> " + gotColumn));
                            List<List<Object>> interpolations = this.interpolateColumns(takeFirstColumn, takeSecondColumn, intervals, gotColumnType, function);
                            int i = 1;
                            while (i < intervals - 1) {
                                String tableInterp = String.valueOf(table1) + "_" + i;
                                List<Object> columnToSub = interpolations.get(i);
                                if (columnToSub.size() > 0) {
                                    AnalysisLogger.getLogger().debug((Object)("UPDATE TABLE " + tableInterp + " ON COLUMN " + gotColumn));
                                    this.addColumnToTable((List)outputFiles.get(i - 1), columnToSub, true);
                                } else {
                                    AnalysisLogger.getLogger().debug((Object)("DOESN'T CHANGE TABLE " + tableInterp + " COLUMN " + gotColumn));
                                    this.addColumnToTable((List)outputFiles.get(i - 1), takeFirstColumn, true);
                                }
                                ++i;
                            }
                        } else {
                            int i = 0;
                            while (i < intervals - 2) {
                                this.addColumnToTable((List)outputFiles.get(i), takeFirstColumn, false);
                                ++i;
                            }
                        }
                        this.status += statusstep;
                        ++j;
                    }
                    this.status = 60.0f;
                    AnalysisLogger.getLogger().debug((Object)"WRITING ALL THE BUFFERS");
                    this.writeAllStringBuffersToFiles(table1, outputFiles, function, startYear, endYear);
                    statusstep = 40.0f / (float)this.producedfiles.length;
                    this.interpolatedTables = new String[this.producedfiles.length + 2];
                    this.interpolatedTables[0] = table1;
                    int i = 0;
                    while (i < this.producedfiles.length) {
                        String filename = this.producedfiles[i].getName();
                        this.interpolatedTables[i + 1] = filename = filename.substring(0, filename.lastIndexOf(".")).replace(" ", "");
                        AnalysisLogger.getLogger().debug((Object)("CREATING TABLE->" + filename));
                        DatabaseFactory.executeSQLUpdate(String.format(createTableStatement, filename), this.referencedbConnection);
                        AnalysisLogger.getLogger().debug((Object)("COPYING TABLE->" + filename));
                        DatabaseUtils.createRemoteTableFromFile(this.producedfiles[i].getAbsolutePath(), filename, ";", false, this.config.getDatabaseUserName(), this.config.getDatabasePassword(), this.config.getDatabaseURL());
                        this.status = Math.min(this.status + statusstep, 99.0f);
                        ++i;
                    }
                    AnalysisLogger.getLogger().debug((Object)"DELETING ALL TEMPORARY FILES");
                    i = 0;
                    while (i < this.producedfiles.length) {
                        this.producedfiles[i].delete();
                        ++i;
                    }
                    this.interpolatedTables[this.interpolatedTables.length - 1] = table2;
                    AnalysisLogger.getLogger().debug((Object)"ALL TABLES HAVE BEEN PRODUCED");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
            finally {
                if (this.referencedbConnection != null) {
                    try {
                        this.referencedbConnection.close();
                    }
                    catch (Exception exception) {}
                }
                this.status = 100.0f;
            }
        }
    }

    public float getStatus() {
        return this.status;
    }

    private void addColumnToTable(List<StringBuffer> rows, List<Object> elements, boolean isNumber) {
        int size = elements.size();
        int i = 0;
        while (i < size) {
            Object[] couple = (Object[])elements.get(i);
            String value = "" + couple[1];
            StringBuffer buffer = null;
            if (i >= rows.size()) {
                buffer = new StringBuffer();
                if (isNumber && value == null || value.length() == 0) {
                    buffer.append("0");
                } else {
                    buffer.append(value);
                }
                rows.add(buffer);
            } else {
                buffer = rows.get(i);
                buffer.append(";" + value);
            }
            ++i;
        }
    }

    private void writeAllStringBuffersToFiles(String initialFile, List<List<StringBuffer>> outputFiles, INTERPOLATIONFUNCTIONS function, int startYear, int endYear) throws Exception {
        int numOfFiles = outputFiles.size();
        int yearStep = (int)((float)(endYear - startYear) / (float)(numOfFiles + 1));
        this.producedfiles = new File[numOfFiles];
        int i = 0;
        while (i < numOfFiles) {
            List<StringBuffer> rows = outputFiles.get(i);
            StringBuffer completeFile = new StringBuffer();
            int nrows = rows.size();
            int k = 0;
            while (k < nrows) {
                completeFile.append(rows.get(k) + "\n");
                ++k;
            }
            int yearCals = startYear + (i + 1) * yearStep;
            if (yearCals == endYear) {
                yearCals = endYear - 1;
            }
            String filename = String.valueOf(this.temporaryDirectory) + "interp_" + yearCals + "_" + function.name() + "_" + i + System.currentTimeMillis() + ".csv";
            FileTools.saveString(filename, completeFile.toString(), true, "UTF-8");
            this.producedfiles[i] = new File(filename);
            System.out.println("PRODUCED FILE TO COPY " + this.producedfiles[i]);
            ++i;
        }
    }

    private List<List<Object>> interpolateColumns(List<Object> col1, List<Object> col2, int intervals, String type, INTERPOLATIONFUNCTIONS function) {
        int elements = col1.size();
        ArrayList<List<Object>> columns = new ArrayList<List<Object>>();
        int i = 0;
        while (i < intervals) {
            columns.add(new ArrayList());
            ++i;
        }
        boolean interping = true;
        int i2 = 0;
        while (i2 < elements) {
            Object[] row1 = (Object[])col1.get(i2);
            Object[] row2 = (Object[])col2.get(i2);
            double firstNum = row1[1] != null ? Double.parseDouble("" + row1[1]) : 0.0;
            double secondNum = row2[1] != null ? Double.parseDouble("" + row2[1]) : 0.0;
            Object key = row1[0];
            double[] interpolation = null;
            if (firstNum != secondNum) {
                if (interping) {
                    AnalysisLogger.getLogger().debug((Object)"Interpolating ... ");
                    interping = false;
                }
                if (function == INTERPOLATIONFUNCTIONS.LINEAR) {
                    interpolation = Operations.linearInterpolation(firstNum, secondNum, intervals);
                } else if (function == INTERPOLATIONFUNCTIONS.PARABOLIC) {
                    interpolation = Operations.parabolicInterpolation(firstNum, secondNum, intervals);
                }
            }
            int j = 0;
            while (j < intervals) {
                Object[] couple = new Object[2];
                couple[0] = key;
                double interp = firstNum;
                if (interpolation != null) {
                    interp = interpolation[j];
                }
                if (type.equals("integer")) {
                    couple[1] = Math.round(interp);
                } else {
                    interp = MathFunctions.roundDecimal(interp, 2);
                    couple[1] = interp;
                }
                columns.get(j).add(couple);
                ++j;
            }
            ++i2;
        }
        return columns;
    }

    public static void main(String[] args) throws Exception {
        String configPath = "./cfg/";
        String persistencePath = "/win/";
        String databaseUrl = "jdbc:postgresql://dbtest.research-infrastructures.eu/aquamapsorgupdated";
        String databaseUser = "utente";
        String databasePassword = "d4science";
        InterpolateTables interp = new InterpolateTables(configPath, persistencePath, databaseUrl, databaseUser, databasePassword);
        interp.interpolate("hcaf_d", "hcaf_d_2050", 7, INTERPOLATIONFUNCTIONS.LINEAR, 2012, 2050);
    }

    public static enum INTERPOLATIONFUNCTIONS {
        LINEAR,
        PARABOLIC;

    }
}

