package org.gcube.dataanalysis.ecoengine.test;

import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.transducers.charts.QuantitiesAttributesChartsTransducerer;
import org.gcube.dataanalysis.ecoengine.transducers.charts.TimeSeriesChartsTransducerer;

public class ChartsTests {

	public static void main(String[] args) throws Exception{
		AnalysisLogger.setLogger("./cfg/" + AlgorithmConfiguration.defaultLoggerFile);
		AlgorithmConfiguration config = new AlgorithmConfiguration();

		config.setConfigPath("./cfg/");
		config.setPersistencePath("./");
		config.setParam("DatabaseUserName", "utente");
		config.setParam("DatabasePassword", "d4science");
		config.setParam("DatabaseURL", "jdbc:postgresql://statistical-manager.d.d4science.research-infrastructures.eu/testdb");
		config.setParam("DatabaseDriver", "org.postgresql.Driver");

		config.setParam("InputTable", "hspen_mini");
//		config.setParam("Attributes", "speciesid#lifestage#faoareas");
		config.setParam("Quantities", "depthmax#speccode");
		
		config.setGcubeScope("/gcube/devsec/devVRE");
		
		QuantitiesAttributesChartsTransducerer cscreator = new QuantitiesAttributesChartsTransducerer();
		cscreator.setConfiguration(config);
		cscreator.compute();
		
		System.out.println("DONE! "+cscreator.getOutput());
	}
	
	public static void main1(String[] args) throws Exception{
		AnalysisLogger.setLogger("./cfg/" + AlgorithmConfiguration.defaultLoggerFile);
		AlgorithmConfiguration config = new AlgorithmConfiguration();

		config.setConfigPath("./cfg/");
		config.setPersistencePath("./");
		config.setParam("DatabaseUserName", "utente");
		config.setParam("DatabasePassword", "d4science");
		config.setParam("DatabaseURL", "jdbc:postgresql://statistical-manager.d.d4science.research-infrastructures.eu/testdb");
		config.setParam("DatabaseDriver", "org.postgresql.Driver");

		config.setParam("InputTable", "timeseries_id4dd368bf_63fb_4d19_8e31_20ced63a477d");
		config.setParam("Attributes", "country#area");
//		config.setParam("Attributes", "");
		config.setParam("Quantities", "quantity");
		config.setParam("Time", "time");
		
		config.setGcubeScope("/gcube/devsec/devVRE");
		
		TimeSeriesChartsTransducerer cscreator = new TimeSeriesChartsTransducerer();
		cscreator.setConfiguration(config);
		cscreator.compute();
		
		System.out.println("DONE! "+cscreator.getOutput());
	}
}
