/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.processing.factories;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.interfaces.Generator;
import org.gcube.dataanalysis.ecoengine.interfaces.GenericAlgorithm;
import org.gcube.dataanalysis.ecoengine.interfaces.SpatialProbabilityDistributionGeneric;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;

public class GeneratorsFactory {
    public static void main(String[] args) throws Exception {
        ServiceLoader<SpatialProbabilityDistributionGeneric> sp = ServiceLoader.load(SpatialProbabilityDistributionGeneric.class);
        for (SpatialProbabilityDistributionGeneric distrib : sp) {
            System.out.println(distrib.getName());
        }
    }

    public static List<String> getProbabilityDistributionAlgorithms(String configPath) throws Exception {
        List<String> algs = ProcessorsFactory.getClasses(configPath + AlgorithmConfiguration.algorithmsFile);
        return algs;
    }

    public static List<String> getAllGenerators(String configPath) throws Exception {
        List<String> gens = ProcessorsFactory.getClasses(configPath + AlgorithmConfiguration.generatorsFile);
        return gens;
    }

    public static String getDescription(String configPath, String algorithmName) throws Exception {
        String input = ProcessorsFactory.getDescription(configPath + AlgorithmConfiguration.algorithmsFile, algorithmName);
        return input;
    }

    public static List<StatisticalType> getAlgorithmParameters(String configPath, String algorithmName) throws Exception {
        List<StatisticalType> inputs = ProcessorsFactory.getParameters(configPath + AlgorithmConfiguration.algorithmsFile, algorithmName);
        return inputs;
    }

    public static StatisticalType getAlgorithmOutput(String configPath, String algorithmName) throws Exception {
        StatisticalType output = ProcessorsFactory.getOutputDescriptions(configPath + AlgorithmConfiguration.algorithmsFile, algorithmName);
        return output;
    }

    public static Generator getGenerator(AlgorithmConfiguration config) throws Exception {
        return (Generator)ProcessorsFactory.getProcessor(config, config.getConfigPath() + AlgorithmConfiguration.generatorsFile);
    }

    public static List<ComputationalAgent> getGenerators(AlgorithmConfiguration config) throws Exception {
        ArrayList<ComputationalAgent> generators = new ArrayList<ComputationalAgent>();
        try {
            AnalysisLogger.setLogger(config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile);
            String algorithm = config.getModel();
            Properties p = AlgorithmConfiguration.getProperties(config.getConfigPath() + AlgorithmConfiguration.algorithmsFile);
            String algorithmclass = p.getProperty(algorithm);
            Object algclass = Class.forName(algorithmclass).newInstance();
            if (algclass instanceof Generator) {
                Generator g = (Generator)algclass;
                g.setConfiguration(config);
                generators.add(g);
            } else {
                GenericAlgorithm sp = (GenericAlgorithm)algclass;
                ALG_PROPS[] algp = sp.getProperties();
                Properties pg = AlgorithmConfiguration.getProperties(config.getConfigPath() + AlgorithmConfiguration.generatorsFile);
                for (Object generatorName : pg.values()) {
                    Generator gen = (Generator)Class.forName((String)generatorName).newInstance();
                    gen.setConfiguration(config);
                    ALG_PROPS[] supportedAlgs = gen.getSupportedAlgorithms();
                    boolean genSuitable = false;
                    block3: for (ALG_PROPS prop : algp) {
                        for (ALG_PROPS gprop : supportedAlgs) {
                            if (gprop != prop) continue;
                            genSuitable = true;
                            continue block3;
                        }
                    }
                    if (!genSuitable) continue;
                    gen.setConfiguration(config);
                    GeneratorsFactory.addGenerator2List(generators, gen);
                }
            }
            return generators;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void addGenerator2List(List<ComputationalAgent> generators, Generator generator) {
        if (generator == null) {
            return;
        }
        int i = 0;
        boolean inserted = false;
        for (ComputationalAgent g : generators) {
            if (g.getInfrastructure().compareTo(generator.getInfrastructure()) > 0) {
                generators.add(i, generator);
                inserted = true;
                break;
            }
            ++i;
        }
        if (!inserted) {
            generators.add(generator);
        }
    }
}

