/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.signals.ssa;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.signals.ssa.SSADataset;
import org.gcube.dataanalysis.ecoengine.signals.ssa.SSAGroupList;
import org.gcube.dataanalysis.ecoengine.signals.ssa.SSAUnselectList;

public class SingularSpectrumAnalysis {
    public static void inclosure(SSADataset data) {
        int L = data.getL();
        int K = data.getTimeSeries().size() - L + 1;
        double[][] inclosureMatrix = new double[L][K];
        for (int i = 1; i <= K; ++i) {
            int num = 0;
            for (int j = i - 1; j <= i + L - 2; ++j) {
                inclosureMatrix[num][i - 1] = data.getTimeSeries().get(j);
                ++num;
            }
        }
        data.setInclosureMatrix(inclosureMatrix);
    }

    public static void singularDecomposition(SSADataset data) {
        int i;
        double[][] inclosureMatrix = data.getInclosureMatrix();
        double[][] transp = SingularSpectrumAnalysis.transpositionMatrix(inclosureMatrix);
        Matrix S = new Matrix(inclosureMatrix).times(new Matrix(transp));
        EigenvalueDecomposition decomposition = new EigenvalueDecomposition(S);
        Matrix eigenvalue = decomposition.getD();
        Matrix eigenvec = decomposition.getV();
        ArrayList<Double> eigenvalueList = new ArrayList<Double>();
        for (int i2 = 0; i2 < eigenvalue.getRowDimension(); ++i2) {
            for (int j = 0; j < eigenvalue.getRowDimension(); ++j) {
                if (i2 != j) continue;
                eigenvalueList.add(eigenvalue.get(i2, j));
            }
        }
        Comparator comparator = Collections.reverseOrder();
        Collections.sort(eigenvalueList, comparator);
        data.setEigenValueList(eigenvalueList);
        double sumValueList = 0.0;
        for (int i3 = 0; i3 < data.getEigenValueList().size(); ++i3) {
            sumValueList += data.getEigenValueList().get(i3).doubleValue();
        }
        ArrayList<Double> percentList = new ArrayList<Double>();
        ArrayList<Double> accruePercentList = new ArrayList<Double>();
        double accruePercent = 0.0;
        for (int i4 = 0; i4 < data.getEigenValueList().size(); ++i4) {
            percentList.add(data.getEigenValueList().get(i4) / sumValueList * 100.0);
            accruePercentList.add(accruePercent += ((Double)percentList.get(i4)).doubleValue());
        }
        data.setAccruePercentList(accruePercentList);
        data.setPercentList(percentList);
        int size = eigenvec.getColumnDimension();
        Matrix[] V = new Matrix[size];
        Matrix[] U = new Matrix[size];
        Matrix[] X = new Matrix[size];
        ArrayList listSeries = new ArrayList();
        for (int j = 0; j < eigenvec.getColumnDimension(); ++j) {
            double[][] uVec = new double[size][1];
            ArrayList<Double> series = new ArrayList<Double>();
            for (int k = 0; k < eigenvec.getRowDimension(); ++k) {
                uVec[k][0] = eigenvec.get(k, eigenvec.getColumnDimension() - j - 1);
                series.add(uVec[k][0]);
            }
            listSeries.add(series);
            U[j] = new Matrix(uVec);
            V[j] = new Matrix(transp).times(U[j]);
        }
        data.setEigenVectors(listSeries);
        for (i = 0; i < V.length; ++i) {
            for (int j = 0; j < V[i].getRowDimension(); ++j) {
                for (int k = 0; k < V[i].getColumnDimension(); ++k) {
                    double val = V[i].get(j, k) / Math.sqrt((Double)eigenvalueList.get(i));
                    V[i].set(j, k, val);
                }
            }
        }
        data.setV(V);
        for (i = 0; i < X.length; ++i) {
            X[i] = U[i].times(V[i].transpose());
            for (int j = 0; j < X[i].getRowDimension(); ++j) {
                for (int k = 0; k < X[i].getColumnDimension(); ++k) {
                    double val = X[i].get(j, k) * Math.sqrt((Double)eigenvalueList.get(i));
                    X[i].set(j, k, val);
                }
            }
        }
        data.setX(X);
    }

    public static void grouping(List<SSAGroupList> model, SSADataset data) {
        Matrix[] grouX = new Matrix[model.size()];
        for (int i = 0; i < model.size(); ++i) {
            SSAGroupList obj = model.get(i);
            for (int j = 0; j < obj.getGroups().size(); ++j) {
                SSAUnselectList unselect = (SSAUnselectList)obj.getGroups().get(j);
                grouX[i] = j == 0 ? data.getX()[unselect.getIndex()] : grouX[i].plus(data.getX()[unselect.getIndex()]);
            }
        }
        data.setGroupX(grouX);
    }

    public static void diagonalAveraging(SSADataset data) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < data.getGroupX().length; ++i) {
            int K;
            int L;
            if (data.getGroupX()[i].getRowDimension() < data.getGroupX()[i].getColumnDimension()) {
                L = data.getGroupX()[i].getRowDimension();
                K = data.getGroupX()[i].getColumnDimension();
            } else {
                K = data.getGroupX()[i].getRowDimension();
                L = data.getGroupX()[i].getColumnDimension();
            }
            int N = data.getGroupX()[i].getRowDimension() + data.getGroupX()[i].getColumnDimension() - 1;
            ArrayList<Double> series = new ArrayList<Double>();
            for (int k = 0; k <= N - 1; ++k) {
                int m;
                double element = 0.0;
                if (k >= 0 && k < L - 1) {
                    for (m = 0; m <= k; ++m) {
                        if (data.getGroupX()[i].getRowDimension() <= data.getGroupX()[i].getColumnDimension()) {
                            element += data.getGroupX()[i].get(m, k - m);
                            continue;
                        }
                        if (data.getGroupX()[i].getRowDimension() <= data.getGroupX()[i].getColumnDimension()) continue;
                        element += data.getGroupX()[i].get(k - m, m);
                    }
                    series.add(element *= 1.0 / (double)(k + 1));
                }
                if (k >= L - 1 && k < K - 1) {
                    for (m = 0; m <= L - 2; ++m) {
                        if (data.getGroupX()[i].getRowDimension() <= data.getGroupX()[i].getColumnDimension()) {
                            element += data.getGroupX()[i].get(m, k - m);
                            continue;
                        }
                        if (data.getGroupX()[i].getRowDimension() <= data.getGroupX()[i].getColumnDimension()) continue;
                        element += data.getGroupX()[i].get(k - m, m);
                    }
                    series.add(element *= 1.0 / (double)L);
                }
                if (k < K - 1 || k >= N) continue;
                for (m = k - K + 1; m <= N - K; ++m) {
                    if (data.getGroupX()[i].getRowDimension() <= data.getGroupX()[i].getColumnDimension()) {
                        element += data.getGroupX()[i].get(m, k - m);
                        continue;
                    }
                    if (data.getGroupX()[i].getRowDimension() <= data.getGroupX()[i].getColumnDimension()) continue;
                    element += data.getGroupX()[i].get(k - m, m);
                }
                series.add(element *= 1.0 / (double)(N - k));
            }
            list.add(series);
        }
        ArrayList<Double> reconstructionList = new ArrayList<Double>();
        for (int j = 0; j < ((List)list.get(0)).size(); ++j) {
            double sum = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                sum += ((Double)((List)list.get(i)).get(j)).doubleValue();
            }
            reconstructionList.add(sum);
        }
        data.setReconstructionList(reconstructionList);
    }

    private static double[][] transpositionMatrix(double[][] matrix) {
        AnalysisLogger.getLogger().debug((Object)("SSA->Building a matrix with dimensions: " + matrix[0].length + " X " + matrix.length));
        double[][] transpMatrix = new double[matrix[0].length][matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                transpMatrix[j][i] = matrix[i][j];
            }
        }
        return transpMatrix;
    }

    public static void setMovingAverage(SSADataset data) {
        ArrayList<Double> SMA = new ArrayList<Double>();
        int m = data.getTimeSeries().size() - data.getL() + 1;
        for (int i = 0; i < data.getL(); ++i) {
            double sum = 0.0;
            double avg = 0.0;
            for (int j = i; j < m + i; ++j) {
                sum += data.getTimeSeries().get(j).doubleValue();
            }
            avg = sum / (double)m;
            SMA.add(avg);
            data.setSMA(SMA);
        }
    }

    public static void averagedCovariance(SSADataset data) {
        double K = data.getTimeSeries().size() - data.getL() + 1;
        ArrayList<Double> covarianceList = new ArrayList<Double>();
        double[][] transp = SingularSpectrumAnalysis.transpositionMatrix(data.getInclosureMatrix());
        Matrix S = new Matrix(data.getInclosureMatrix()).times(new Matrix(transp));
        S = S.times(1.0 / K);
        int size = S.getColumnDimension();
        int N = size + size - 1;
        for (int k = 0; k < N; ++k) {
            int m;
            int n;
            double avg;
            if (k % 2 != 0) continue;
            if (k >= 0 && k < size) {
                avg = 0.0;
                n = 0;
                for (m = 0; m <= k; ++m) {
                    avg += S.get(m, size - 1 - (k - m));
                    ++n;
                }
                covarianceList.add(avg /= (double)n);
            }
            if (k < size || k >= N) continue;
            avg = 0.0;
            n = 0;
            for (m = k - size + 1; m <= N - size; ++m) {
                avg += S.get(m, size - 1 - (k - m));
                ++n;
            }
            covarianceList.add(avg /= (double)n);
        }
        data.setCov(covarianceList);
    }

    public static void functionEigenValue(SSADataset data) {
        ArrayList<Double> lgList = new ArrayList<Double>();
        ArrayList<Double> sqrtList = new ArrayList<Double>();
        for (int i = 0; i < data.getEigenValueList().size(); ++i) {
            lgList.add(Math.log(data.getEigenValueList().get(i)));
            sqrtList.add(Math.sqrt(data.getEigenValueList().get(i)));
        }
        data.setLgEigenValue(lgList);
        data.setSqrtEigenValue(sqrtList);
    }

    public static void forecast(SSADataset data, int nPointsToForecast, boolean reconstructedSignal) {
        int nTotalEigenV;
        if (nPointsToForecast == 0) {
            data.setForecastList(data.getReconstructionList());
            return;
        }
        int bestEigenVectors = nTotalEigenV = data.getPercentList().size();
        for (int i = 0; i < nTotalEigenV; ++i) {
            double currentperc = data.getPercentList().get(i);
            if (!(currentperc < data.getPercThreshold())) continue;
            bestEigenVectors = i + 1;
            break;
        }
        List eigenvectors = data.getEigenVectors().subList(0, bestEigenVectors);
        int L = data.getL();
        int lastcoordinate = L - 1;
        AnalysisLogger.getLogger().debug((Object)("SSA: value for L: " + L));
        int nEigenVectors = eigenvectors.size();
        AnalysisLogger.getLogger().debug((Object)("Number of Selected Eigenvectors For Reconstruction: " + nEigenVectors));
        double[] p = new double[nEigenVectors];
        for (int i = 0; i < nEigenVectors; ++i) {
            p[i] = (Double)((List)eigenvectors.get(i)).get(lastcoordinate);
        }
        double[][] P = new double[nEigenVectors][L - 1];
        for (int i = 0; i < nEigenVectors; ++i) {
            List evec = (List)eigenvectors.get(i);
            for (int j = 0; j < L - 1; ++j) {
                P[i][j] = (Double)evec.get(j);
            }
        }
        double ni_sqr = 0.0;
        for (int i = 0; i < nEigenVectors; ++i) {
            ni_sqr += p[i] * p[i];
        }
        double[] R = new double[L - 1];
        for (int j = 0; j < L - 1; ++j) {
            double rj = 0.0;
            for (int i = 0; i < nEigenVectors; ++i) {
                rj += p[i] * P[i][j];
            }
            R[j] = rj / (1.0 - ni_sqr);
        }
        int M = nPointsToForecast;
        ArrayList<Double> y = new ArrayList<Double>();
        int signalSize = data.getTimeSeries().size();
        for (int j = 0; j < signalSize + M; ++j) {
            if (j < signalSize) {
                if (reconstructedSignal) {
                    y.add(j, data.getReconstructionList().get(j));
                    continue;
                }
                y.add(j, data.getTimeSeries().get(j));
                continue;
            }
            double sumprec = 0.0;
            for (int g = 0; g < L - 1; ++g) {
                double ag = R[L - 2 - g];
                double yj_g = (Double)y.get(j - g - 1);
                sumprec += ag * yj_g;
            }
            y.add(j, sumprec);
        }
        AnalysisLogger.getLogger().debug((Object)("Length of the original signal: " + signalSize + " Length of the reconstructed signal: " + y.size()));
        data.setForecastList(y);
    }
}

