/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.models.cores.pca;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.features.transformation.PCA;
import com.rapidminer.operator.features.transformation.PCAModel;
import com.rapidminer.tools.OperatorService;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.Operations;
import org.gcube.dataanalysis.ecoengine.utils.Transformations;

public class PrincipalComponentAnalysis {
    PCAModel innermodel;
    int numberOfComponents;

    public static void main(String[] args) throws Exception {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./cfg/");
        config.setNumberOfResources(1);
        config.setAgent("QUALITY_ANALYSIS");
        AnalysisLogger.setLogger(config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile);
        config.initRapidMiner();
        PrincipalComponentAnalysis pca = new PrincipalComponentAnalysis();
        int m = 5;
        int n = 5;
        double[][] values = new double[m][n];
        double[] val2 = new double[]{1.0, 0.451, 0.511, 0.197, 0.162};
        double[] val1 = new double[]{0.451, 1.0, 0.445, 0.252, 0.238};
        double[] val3 = new double[]{0.511, 0.445, 1.0, 0.301, 0.227};
        double[] val5 = new double[]{0.197, 0.252, 0.301, 1.0, 0.62};
        double[] val4 = new double[]{0.162, 0.238, 0.227, 0.62, 1.0};
        values[0] = val1;
        values[1] = val2;
        values[2] = val3;
        values[3] = val4;
        values[4] = val5;
        pca.calcPCA(values);
        PCAModel model = pca.getModel();
        int components = model.getMaximumNumberOfComponents();
        for (int i = 0; i < components; ++i) {
            AnalysisLogger.getLogger().debug((Object)(i + 1 + "->" + model.getEigenvalue(i)));
            double[] eigen = model.getEigenvector(i);
            for (int j = 0; j < eigen.length; ++j) {
                System.out.print(eigen[j] + " ");
            }
            System.out.println();
        }
        double[][] componentsMatrix = pca.getComponentsMatrix(values);
        System.exit(0);
    }

    public void init(AlgorithmConfiguration config) {
        config.initRapidMiner();
    }

    public PCAModel getModel() {
        return this.innermodel;
    }

    public double[] getEigenvector(int index) {
        return this.innermodel.getEigenvector(index);
    }

    public double getEigenvalue(int index) {
        return this.innermodel.getEigenvalue(index);
    }

    public double[] getEigenvalues() {
        double[] values = new double[this.numberOfComponents];
        for (int i = 0; i < this.numberOfComponents; ++i) {
            values[i] = this.getEigenvalue(i);
        }
        return values;
    }

    public double[] getNormalizedEigenvalues() {
        double[] values = new double[this.numberOfComponents];
        for (int i = 0; i < this.numberOfComponents; ++i) {
            values[i] = this.getEigenvalue(i);
        }
        double sumEigen = Operations.sumVector(values);
        for (int i = 0; i < this.numberOfComponents; ++i) {
            values[i] = values[i] / sumEigen;
        }
        return values;
    }

    public double[] getInverseEigenvalues() {
        double[] values = new double[this.numberOfComponents];
        for (int i = 0; i < this.numberOfComponents; ++i) {
            values[i] = 1.0 / this.getEigenvalue(i);
        }
        return values;
    }

    public double[] getInverseNormalizedEigenvalues() {
        double[] values = new double[this.numberOfComponents];
        double[] weightedEigens = this.getNormalizedEigenvalues();
        for (int i = 0; i < this.numberOfComponents; ++i) {
            values[i] = 1.0 / weightedEigens[i];
        }
        return values;
    }

    public double[][] getComponentsMatrix(double[][] vectors) throws Exception {
        int nsamples = vectors.length;
        double[][] components = new double[nsamples][];
        for (int i = 0; i < nsamples; ++i) {
            components[i] = this.getComponents(vectors[i]);
        }
        return components;
    }

    public double[] getComponents(double[] vector) throws Exception {
        double[] components = new double[this.numberOfComponents];
        for (int i = 0; i < this.numberOfComponents; ++i) {
            components[i] = Operations.scalarProduct(vector, this.getEigenvector(i));
        }
        return components;
    }

    protected double[][] getPCA(double[][] sampleVectors) throws Exception {
        ExampleSet set = Transformations.matrix2ExampleSet(sampleVectors);
        ExampleSet outset = this.innermodel.apply(set);
        return Transformations.exampleSet2Matrix(outset);
    }

    public void calcPCA(double[][] sampleVectors) throws Exception {
        AnalysisLogger.getLogger().debug((Object)"STARTING PCA COMPUTATION");
        PCA pca = (PCA)OperatorService.createOperator((String)"PCA");
        pca.setParameter("variance_threshold", "0.95");
        pca.setParameter("dimensionality_reduction", "keep variance");
        pca.setParameter("number_of_components", "-1");
        ExampleSet set = Transformations.matrix2ExampleSet(sampleVectors);
        IOContainer innerInput = new IOContainer(new IOObject[]{set});
        IOContainer output = pca.apply(innerInput);
        IOObject[] outputvector = output.getIOObjects();
        this.innermodel = (PCAModel)outputvector[1];
        this.numberOfComponents = this.innermodel.getMaximumNumberOfComponents();
        AnalysisLogger.getLogger().debug((Object)"MODEL APPLIED");
    }
}

