/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.utils;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.gcube.portlets.user.timeseries.charts.support.types.Point;

public class MathFunctions {
    public static void main(String[] args) {
        System.out.println(MathFunctions.cohensKappaForDichotomy(25L, 35L, 5L, 35L));
    }

    public static double roundDecimal(double number, int decimalposition) {
        double n = (double)Math.round(number * Math.pow(10.0, decimalposition)) / Math.pow(10.0, decimalposition);
        return n;
    }

    public static float incrementPerc(float perc, float quantity, int N) {
        if (N == 0) {
            return quantity;
        }
        float out = 0.0f;
        int N_plus_1 = N + 1;
        out = (float)(((double)perc + (double)quantity / (double)N) * ((double)N / (double)N_plus_1));
        return out;
    }

    public static ArrayList<Integer> generateRandoms(int numberOfRandoms, int min, int max) {
        ArrayList<Integer> randomsSet = new ArrayList<Integer>();
        if (numberOfRandoms == -1) {
            for (int i = min; i < max; ++i) {
                randomsSet.add(i);
            }
        } else {
            int numofrandstogenerate = 0;
            numofrandstogenerate = numberOfRandoms <= max ? numberOfRandoms : max;
            if (numofrandstogenerate == 0) {
                randomsSet.add(0);
            } else {
                for (int i = 0; i < numofrandstogenerate; ++i) {
                    int RNum = -1;
                    RNum = (int)((double)max * Math.random()) + min;
                    while (randomsSet.contains(RNum)) {
                        RNum = (int)((double)max * Math.random()) + min;
                    }
                    if (RNum < 0) continue;
                    randomsSet.add(RNum);
                }
            }
        }
        return randomsSet;
    }

    public static int[] generateSequence(int elements) {
        int[] sequence = new int[elements];
        for (int i = 0; i < elements; ++i) {
            sequence[i] = i;
        }
        return sequence;
    }

    public static BigInteger chunk2Index(int chunkIndex, int chunkSize) {
        return BigInteger.valueOf(chunkIndex).multiply(BigInteger.valueOf(chunkSize));
    }

    public static double mean(double[] p) {
        double sum = 0.0;
        for (int i = 0; i < p.length; ++i) {
            sum += p[i];
        }
        return sum / (double)p.length;
    }

    public static double[] derivative(double[] a) {
        double[] d = new double[a.length];
        double max = 1.0;
        if (a.length > 0) {
            int i;
            for (i = 0; i < a.length; ++i) {
                double current;
                double previous = current = a[i];
                if (i > 0) {
                    previous = a[i - 1];
                }
                d[i] = current - previous;
                if (!(Math.abs(d[i]) > max)) continue;
                max = Math.abs(d[i]);
            }
            for (i = 0; i < a.length; ++i) {
                d[i] = d[i] / max;
            }
        }
        return d;
    }

    public static boolean[] findSpikes(double[] derivative, double threshold) {
        boolean[] d = new boolean[derivative.length];
        if (d.length > 0) {
            d[0] = false;
            for (int i = 1; i < derivative.length - 1; ++i) {
                if (derivative[i] / derivative[i + 1] < 0.0) {
                    if (!(threshold > 0.0) || !(Math.abs(derivative[i]) > threshold)) continue;
                    d[i] = true;
                    continue;
                }
                d[i] = false;
            }
            d[derivative.length - 1] = false;
        }
        return d;
    }

    public static boolean[] findSpikes(double[] derivative) {
        return MathFunctions.findSpikes(derivative, -1.0);
    }

    public static double[] points2Double(List<Point<? extends Number, ? extends Number>> pointslist, int seriesIndex, int numbOfPoints) {
        double[] points = new double[numbOfPoints];
        for (int y = 0; y < numbOfPoints; ++y) {
            double value;
            points[y] = value = pointslist.get(seriesIndex).getEntries().get(y).getValue().doubleValue();
        }
        return points;
    }

    public static boolean isIn(List<Integer> indexarray, int index) {
        int size = indexarray.size();
        for (int i = 0; i < size; ++i) {
            if (index != indexarray.get(i)) continue;
            return true;
        }
        return false;
    }

    public static List<Integer> findZeros(double[] points) {
        int size = points.length;
        ArrayList<Integer> zeros = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            if (points[i] != 0.0) continue;
            int start = i;
            int end = i;
            for (int j = i + 1; j < size; ++j) {
                if (points[j] == 0.0) continue;
                end = j - 1;
                break;
            }
            int center = start + (end - start) / 2;
            zeros.add(center);
            i = end;
        }
        return zeros;
    }

    public static double[] logSubdivision(double start, double end, int numberOfParts) {
        if (end <= start) {
            return null;
        }
        if (start == 0.0) {
            start = 0.01;
        }
        double logStart = Math.log(start);
        double logEnd = Math.log(end);
        double step = 0.0;
        if (numberOfParts > 0) {
            double difference = logEnd - logStart;
            step = difference / (double)numberOfParts;
        }
        double[] linearpoints = new double[numberOfParts + 1];
        for (int i = 0; i < numberOfParts + 1; ++i) {
            linearpoints[i] = Math.exp(logStart + (double)i * step);
            if (!(linearpoints[i] < 0.011)) continue;
            linearpoints[i] = 0.0;
        }
        return linearpoints;
    }

    public static double cohensKappaForDichotomy(long NumOf_A1_B1, long NumOf_A1_B0, long NumOf_A0_B1, long NumOf_A0_B0) {
        long T = NumOf_A1_B1 + NumOf_A1_B0 + NumOf_A0_B1 + NumOf_A0_B0;
        double Pra = (double)(NumOf_A1_B1 + NumOf_A0_B0) / (double)T;
        double Pre1 = (double)(NumOf_A1_B1 + NumOf_A1_B0) * (double)(NumOf_A1_B1 + NumOf_A0_B1) / (double)(T * T);
        double Pre2 = (double)(NumOf_A0_B0 + NumOf_A0_B1) * (double)(NumOf_A0_B0 + NumOf_A1_B0) / (double)(T * T);
        double Pre = Pre1 + Pre2;
        double Kappa = (Pra - Pre) / (1.0 - Pre);
        return MathFunctions.roundDecimal(Kappa, 3);
    }

    public static String kappaClassificationLandisKoch(double kappa) {
        if (kappa < 0.0) {
            return "Poor";
        }
        if (kappa >= 0.0 && kappa <= 0.2) {
            return "Slight";
        }
        if (kappa >= 0.21 && kappa <= 0.4) {
            return "Fair";
        }
        if (kappa >= 0.41 && kappa <= 0.6) {
            return "Moderate";
        }
        if (kappa >= 0.61 && kappa <= 0.8) {
            return "Substantial";
        }
        if (kappa >= 0.81) {
            return "Almost Perfect";
        }
        return "Not Applicable";
    }

    public static String kappaClassificationFleiss(double kappa) {
        if (kappa < 0.0) {
            return "Poor";
        }
        if (kappa >= 0.0 && kappa <= 0.4) {
            return "Marginal";
        }
        if (kappa > 0.4 && kappa <= 0.75) {
            return "Good";
        }
        if (kappa > 0.75) {
            return "Excellent";
        }
        return "Not Applicable";
    }
}

