package org.gcube.dataanalysis.ecoengine.signals;

import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.signals.SignalConverter;
import org.gcube.dataanalysis.ecoengine.signals.SignalProcessing;

public class PeriodicityDetector {

	/*
	 * static int defaultSamplingRate = 1000;// Hz static float defaultSignalLengthTimeinSec = 5;// s static float defaultHiddenFrequency = 100f;// Hz static float defaultMinPossibleFreq = 0; // Hz static float defaultMaxPossibleFreq = 200; // Hz static float defaultSNratio = 2; static float defaultFreqError = 1f;
	 */
	static int defaultSamplingRate = 8000;// Hz
	static float defaultSignalLengthTimeinSec = 5;// s
	static float defaultHiddenFrequency = 2f;// Hz
	static float defaultMinPossibleFreq = 0; // Hz
	static float defaultMaxPossibleFreq = 1000; // Hz
	static float defaultSNratio = 0;
	static float defaultFreqError = 1f;

	public int currentSamplingRate;
	public int currentWindowShiftSamples;
	public int currentWindowAnalysisSamples;
	public double[][] currentspectrum;

	public double meanF = 0;
	public double lowermeanF = 0;
	public double uppermeanF = 0;

	public double meanPeriod = 0;
	public double lowermeanPeriod = 0;
	public double uppermeanPeriod = 0;

	public double startPeriodTime = 0;
	public double endPeriodTime = 0;
	public double startPeriodSampleIndex = 0;
	public double endPeriodSampleIndex = 0;

	public double periodicityStrength = 0;
	public double minFrequency;
	public double maxFrequency;

	public String getPeriodicityStregthInterpretation() {
		if (periodicityStrength > 0.6)
			return "High";
		if (periodicityStrength < 0.6 && periodicityStrength > 0.5)
			return "Moderate";
		if (periodicityStrength < 0.5 && periodicityStrength > 0.3)
			return "Weak";
		if (periodicityStrength < 0.5 && periodicityStrength > 0.3)
			return "Very Low";
		else
			return "None";
	}

	public void demo() throws Exception {

		double[] signal = produceNoisySignal(defaultSignalLengthTimeinSec, defaultSamplingRate, defaultHiddenFrequency, defaultSNratio);
		AnalysisLogger.getLogger().debug("Signal samples: " + signal.length);
		double F = detectFrequency(signal, defaultSamplingRate, defaultMinPossibleFreq, defaultMaxPossibleFreq, defaultFreqError, -1, true);
		AnalysisLogger.getLogger().debug("Detected F:" + F + " indecision [" + lowermeanF + " , " + uppermeanF + "]");
	}

	public static void main(String[] args) throws Exception {

		PeriodicityDetector processor = new PeriodicityDetector();
		processor.demo();
	}

	public double[] produceNoisySignal(float signalLengthTimeinSec, int samplingRate, float frequency, float SNratio) {

		// generate a signal with the above period
		double[] sin = SignalConverter.generateSinSignal((int) signalLengthTimeinSec * samplingRate, 1f / samplingRate, frequency);

		// add noise
		for (int i = 0; i < sin.length; i++) {
			sin[i] = sin[i] + SNratio * Math.random();
		}
		return sin;
	}

	public double detectFrequency(double[] signal, boolean display) throws Exception {

		return detectFrequency(signal, 1, 0, 1, 1f, -1, display);
	}

	public double detectFrequency(double[] signal) throws Exception {

		return detectFrequency(signal, false);
	}

	public double detectFrequency(double[] signal, int samplingRate, float minPossibleFreq, float maxPossibleFreq, float wantedFreqError, int FFTnsamples, boolean display) throws Exception {

		// estimate the best samples based on the error we want
		int wLength = 0;
		long pow = 0;
		if (wantedFreqError>-1){
			pow = Math.round(Math.log((float) samplingRate / wantedFreqError) / Math.log(2));

		if (pow <= 1)
			pow = Math.round(Math.log((float) signal.length / (float) ("" + signal.length).length()) / Math.log(2));

		AnalysisLogger.getLogger().debug("Suggested pow for window length=" + pow);
			
		}
		//adjust FFT Samples to be even 
		else{
			if (FFTnsamples<2)
				FFTnsamples=2;
			else if (FFTnsamples>signal.length)
				FFTnsamples=signal.length;
			
			pow = Math.round(Math.log((float) FFTnsamples) / Math.log(2));
		}
		
		wLength = (int) Math.pow(2, pow);
		
		AnalysisLogger.getLogger().debug("Suggested windows length (samples)=" + wLength);
		AnalysisLogger.getLogger().debug("Suggested windows length (s)=" + ((float) wLength / (float) samplingRate) + " s");
		int windowAnalysisSamples = (int) Math.pow(2, 14);// (int)
		windowAnalysisSamples = wLength;
		int windowShiftSamples = (int) Math.round((float) windowAnalysisSamples / 2f);
		float windowShiftTime = (float) SignalConverter.sample2Time(windowShiftSamples, samplingRate);

		float error = ((float) samplingRate / (float) windowAnalysisSamples);

		AnalysisLogger.getLogger().debug("Error in the Measure will be: " + error + " Hz");
		AnalysisLogger.getLogger().debug("A priori Min Freq: " + minPossibleFreq + " s");
		AnalysisLogger.getLogger().debug("A priori Max Freq: " + maxPossibleFreq + " s");
		if (maxPossibleFreq >= samplingRate)
			maxPossibleFreq = (float) (samplingRate / 2f) - (0.1f * samplingRate / 2f);

		if (minPossibleFreq == 0)
			minPossibleFreq = 0.1f;

		minFrequency = minPossibleFreq;
		maxFrequency = maxPossibleFreq;
		// display the signal
		// if (display)
		// SignalProcessing.displaySignalWithGenericTime(signal, 0, 1, "signal");

		this.currentSamplingRate = samplingRate;
		this.currentWindowShiftSamples = windowShiftSamples;
		this.currentWindowAnalysisSamples = windowAnalysisSamples;

		// trace spectrum
		double[][] spectrum = SignalConverter.spectrogram("spectrogram", signal, samplingRate, windowShiftSamples, windowAnalysisSamples, false);
		if (display)
			SignalConverter.displaySpectrogram(spectrum, signal, "complete spectrogram", samplingRate, windowShiftSamples, windowAnalysisSamples);
		// apply the bandpass filter
		spectrum = SignalConverter.cutSpectrum(spectrum, minPossibleFreq, maxPossibleFreq, windowAnalysisSamples, samplingRate);
		if (display)
			// display cut spectrum
			SignalConverter.displaySpectrogram(spectrum, signal, "clean spectrogram", samplingRate, windowShiftSamples, windowAnalysisSamples);
		// extract the maximum frequencies in each frame
		SignalConverter signalMaximumAnalyzer = new SignalConverter();
		double[] maxfrequencies = signalMaximumAnalyzer.takeMaxFrequenciesInSpectrogram(spectrum, samplingRate, windowAnalysisSamples, minPossibleFreq);
		double[] powers = signalMaximumAnalyzer.averagepower;
		currentspectrum = spectrum;
		// display the maximum freqs
		AnalysisLogger.getLogger().debug("Number of frequency peaks " + maxfrequencies.length);
		// take the longest stable sequence of frequencies
		SignalConverter signalconverter = new SignalConverter();
		maxfrequencies = signalconverter.takeLongestStableTract(maxfrequencies, 0.01);

		if (maxfrequencies == null)
			return 0;

		this.startPeriodTime = SignalConverter.spectrogramTimeFromIndex(signalconverter.startStableTractIdx, windowShiftTime);
		this.endPeriodTime = SignalConverter.spectrogramTimeFromIndex(signalconverter.endStableTractIdx, windowShiftTime);
		this.startPeriodSampleIndex = SignalConverter.time2Sample(startPeriodTime, samplingRate);
		this.endPeriodSampleIndex = Math.min(SignalConverter.time2Sample(endPeriodTime, samplingRate), signal.length - 1);

		float power = 0;
		int counter = 0;
		// calculate the average spectrum relative amplitude in the most stable periodic tract
		for (int i = signalconverter.startStableTractIdx; i < signalconverter.endStableTractIdx; i++) {
			power = MathFunctions.incrementPerc(power, (float) powers[i], counter);
			counter++;
		}

		this.periodicityStrength = power;
		if (this.periodicityStrength == -0.0)
			this.periodicityStrength = 0;

		// reconstruct the F
		double meanF = MathFunctions.mean(maxfrequencies);
		//we consider a complete cycle
		double possibleperiod = 2d/meanF;
		AnalysisLogger.getLogger().debug("TimeSeriesAnalysis->Frequency "+meanF);
		AnalysisLogger.getLogger().debug("TimeSeriesAnalysis->Periodicity "+possibleperiod);
		if ((meanF <= minPossibleFreq) || (meanF >= maxPossibleFreq) || (possibleperiod==0) || (possibleperiod>(endPeriodTime-startPeriodTime)))  {
			meanF=0;
			this.meanF = 0;
			this.lowermeanF = 0;
			this.uppermeanF = 0;

			this.meanPeriod = 0;
			this.lowermeanPeriod = 0;
			this.uppermeanPeriod = 0;
			this.periodicityStrength = 0;
			this.startPeriodTime = 0;
			this.endPeriodTime = 0;
			this.startPeriodSampleIndex = 0;
			this.endPeriodSampleIndex = 0;
			
		} else {
			this.meanF = meanF;
			this.lowermeanF = Math.max(meanF - error, minPossibleFreq);
			this.uppermeanF = Math.min(meanF + error, maxFrequency);

			this.meanPeriod = 2d / meanF;
			this.lowermeanPeriod = 2d / lowermeanF;
			this.uppermeanPeriod = 2d / uppermeanF;
		}
		return meanF;
	}
}
