/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.Neuron;

public class Neural_Network
implements Serializable {
    public Neuron[][] griglia;
    static final long serialVersionUID = 1L;
    double soglia = 1.0E-4;
    double maxcycle = 3000.0;
    double acceptanceThr = 0.5;
    public double maxfactor = 1.0;
    public double minfactor = 0.0;
    public float status = 0.0f;
    public double en;

    public void setThreshold(double soglia) {
        this.soglia = soglia;
    }

    public double getCorrectValueFromOutput(double prob) {
        return prob * this.maxfactor + (1.0 - prob) * this.minfactor;
    }

    public double getCorrectValueForOutput(double output) {
        return (output - this.minfactor) / (this.maxfactor - this.minfactor);
    }

    public void setAcceptanceThreshold(double treshold) {
        this.acceptanceThr = treshold;
    }

    public void setCycles(double cycs) {
        this.maxcycle = cycs;
    }

    public Neural_Network(int N, int M, ACTIVATIONFUNCTION attifun) {
        this(N, M, attifun.ordinal() + 1);
    }

    public Neural_Network(int N, int M, ACTIVATIONFUNCTION attifun, float[] V) {
        this(N, M, attifun.ordinal() + 1, V);
    }

    public static double[] preprocessObjects(Object[] vector) {
        double[] out = new double[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            double element = 0.0;
            if (vector[i] != null) {
                element = Double.parseDouble("" + vector[i]);
            }
            if (element == 0.0) {
                element = 0.1;
            }
            out[i] = element;
        }
        return out;
    }

    public static double[] preprocessObjects(double[] vector) {
        double[] out = new double[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            double element = vector[i];
            if (element == 0.0) {
                element = 0.1;
            }
            out[i] = element;
        }
        return out;
    }

    public int getNumberOfOutputs() {
        if (this.griglia != null) {
            return this.griglia[this.griglia.length - 1].length;
        }
        return 0;
    }

    public int getNumberOfInputs() {
        if (this.griglia != null) {
            return this.griglia[0].length;
        }
        return 0;
    }

    public double[] getPositiveCase() {
        double[] out = new double[]{};
        if (this.griglia.length > 0) {
            out = new double[this.griglia[this.griglia.length - 1].length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = 1.0;
            }
        }
        return out;
    }

    public double[] getNegativeCase() {
        double[] out = new double[]{};
        if (this.griglia.length > 0) {
            out = new double[this.griglia[this.griglia.length - 1].length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = 0.0;
            }
        }
        return out;
    }

    public static int[] setupInnerLayers(int ... numberOfNeurons) {
        int[] layers = null;
        if (numberOfNeurons.length > 0) {
            layers = new int[numberOfNeurons.length];
            for (int i = 0; i < numberOfNeurons.length; ++i) {
                layers[i] = numberOfNeurons[i];
            }
        }
        return layers;
    }

    public Neural_Network(int N, int M, int[] t, ACTIVATIONFUNCTION attifun) {
        this(N, M, t, attifun.ordinal() + 1);
    }

    public Neural_Network(int N, int M, int attifun) {
        this.griglia = new Neuron[2][];
        Neuron[] input = new Neuron[N + 1];
        input[0] = new Neuron(M, 4);
        for (int i = 1; i < N + 1; ++i) {
            input[i] = new Neuron(M, 3);
        }
        this.griglia[0] = input;
        Neuron[] output = new Neuron[M];
        for (int i = 0; i < M; ++i) {
            output[i] = new Neuron(0, attifun);
        }
        this.griglia[1] = output;
    }

    public Neural_Network(int N, int M, int attifun, float[] V) {
        this.griglia = new Neuron[2][];
        Neuron[] input = new Neuron[N + 1];
        input[0] = new Neuron(M, 4);
        for (int i = 1; i < N + 1; ++i) {
            input[i] = new Neuron(M, 3, V);
        }
        this.griglia[0] = input;
        Neuron[] output = new Neuron[M];
        for (int i = 0; i < M; ++i) {
            output[i] = new Neuron(0, attifun);
        }
        this.griglia[1] = output;
    }

    public Neural_Network(int N, int M, int[] t, int attifun) {
        this.griglia = new Neuron[t.length + 2][];
        Neuron[] input = new Neuron[N + 1];
        input[0] = new Neuron(t[0], 4);
        for (int i = 1; i < N + 1; ++i) {
            input[i] = new Neuron(t[0], 3);
        }
        this.griglia[0] = input;
        for (int i = 0; i < t.length; ++i) {
            Neuron[] aux = new Neuron[t[i] + 1];
            if (i != t.length - 1) {
                aux[0] = new Neuron(t[i + 1], 4);
                for (int g = 1; g < t[i] + 1; ++g) {
                    aux[g] = new Neuron(t[i + 1], attifun);
                }
            } else {
                aux[0] = new Neuron(M, 4);
                for (int j = 1; j < t[i] + 1; ++j) {
                    aux[j] = new Neuron(M, attifun);
                }
            }
            this.griglia[i + 1] = aux;
        }
        Neuron[] output = new Neuron[M];
        for (int i = 0; i < M; ++i) {
            output[i] = new Neuron(0, attifun);
        }
        this.griglia[t.length + 1] = output;
    }

    public double[] propagate(double[] input) {
        if (input.length == this.griglia[0].length - 1) {
            return this.prop(input, 0);
        }
        System.out.println("Error : number of inputs not valid!");
        return null;
    }

    private double[] prop(double[] input, int i) {
        if (this.griglia[i][0].W.length != 0) {
            double[] arrayaux = new double[this.griglia[i][0].W.length];
            for (int j = 0; j < this.griglia[i][0].W.length; ++j) {
                double multip = this.griglia[i][0].W[j];
                for (int g = 1; g < this.griglia[i].length; ++g) {
                    multip += (double)this.griglia[i][g].W[j] * this.griglia[i][g].generaOutput(input[g - 1]);
                }
                arrayaux[j] = multip;
            }
            return this.prop(arrayaux, i + 1);
        }
        double[] arrayaux = new double[this.griglia[i].length];
        for (int j = 0; j < this.griglia[i].length; ++j) {
            arrayaux[j] = this.griglia[i][j].generaOutput(input[j]);
        }
        return arrayaux;
    }

    private double[][] trainpropagate(double[] input) {
        double[][] arrayout = new double[this.griglia.length + 1][];
        if (input.length == this.griglia[0].length - 1) {
            arrayout[0] = input;
            for (int i = 0; i < this.griglia.length; ++i) {
                arrayout[i + 1] = this.trainprop(arrayout[i], i);
            }
            return arrayout;
        }
        System.out.println("Error : number of inputs not valid!");
        return null;
    }

    private double[] trainprop(double[] input, int i) {
        if (this.griglia[i][0].W.length != 0) {
            double[] arrayaux = new double[this.griglia[i][0].W.length];
            for (int j = 0; j < this.griglia[i][0].W.length; ++j) {
                double multip = this.griglia[i][0].W[j];
                for (int g = 1; g < this.griglia[i].length; ++g) {
                    multip += (double)this.griglia[i][g].W[j] * this.griglia[i][g].generaOutput(input[g - 1]);
                }
                arrayaux[j] = multip;
            }
            return arrayaux;
        }
        double[] arrayaux = new double[this.griglia[i].length];
        for (int j = 0; j < this.griglia[i].length; ++j) {
            arrayaux[j] = this.griglia[i][j].generaOutput(input[j]);
        }
        return arrayaux;
    }

    private void BProp(double[] input, double[] realvalues) {
        int g;
        double Dk;
        double Ak;
        double[][] Ai = this.trainpropagate(input);
        int lungtrain = Ai.length;
        double[][] arraydelta = new double[this.griglia.length - 1][];
        int lungdelta = this.griglia.length - 1;
        arraydelta[lungdelta - 1] = new double[Ai[lungtrain - 1].length];
        for (int i = 0; i < Ai[lungtrain - 1].length; ++i) {
            double Yk = Ai[lungtrain - 1][i];
            Ak = Ai[lungtrain - 2][i];
            double Tk = realvalues[i];
            arraydelta[lungdelta - 1][i] = Dk = (Yk - Tk) * (1.0 / (1.0 + Math.exp(-1.0 * Ak))) * (1.0 - 1.0 / (1.0 + Math.exp(-1.0 * Ak)));
        }
        for (g = lungdelta - 2; g >= 0; --g) {
            arraydelta[g] = new double[Ai[g + 1].length];
            double[] DKnext = arraydelta[g + 1];
            for (int j = 0; j < Ai[g + 1].length; ++j) {
                Ak = Ai[g + 1][j];
                double somma = 0.0;
                for (int k = 0; k < arraydelta[g + 1].length; ++k) {
                    somma += (double)this.griglia[g + 1][j + 1].W[k] * DKnext[k];
                }
                arraydelta[g][j] = Dk = somma * (1.0 / (1.0 + Math.exp(-1.0 * Ak))) * (1.0 - 1.0 / (1.0 + Math.exp(-1.0 * Ak)));
            }
        }
        for (g = 0; g < this.griglia.length - 1; ++g) {
            float[] D = new float[Ai[g + 1].length];
            for (int k = 0; k < Ai[g + 1].length; ++k) {
                D[k] = (float)(0.5 * arraydelta[g][k]);
            }
            this.griglia[g][0].aggiornaPesi(D);
            for (int i = 1; i < this.griglia[g].length; ++i) {
                float[] V = new float[Ai[g + 1].length];
                for (int k = 0; k < Ai[g + 1].length; ++k) {
                    V[k] = (float)(0.5 * (this.griglia[g][i].generaOutput(Ai[g][i - 1]) * arraydelta[g][k]));
                }
                this.griglia[g][i].aggiornaPesi(V);
            }
        }
    }

    public void train(double[][] inputvet, double[][] correctoutputvet) {
        if (this.griglia[this.griglia.length - 1].length != correctoutputvet[0].length) {
            AnalysisLogger.getLogger().debug((Object)"Error :  the vector of outputs has not a lenght equal to the output of the network");
        } else {
            this.en = 2.0;
            int counter = 0;
            double enprec = 2.0;
            while (this.en > this.soglia && (double)counter <= this.maxcycle) {
                this.en = 0.0;
                for (int i = 0; i < inputvet.length; ++i) {
                    this.BProp(inputvet[i], correctoutputvet[i]);
                    this.en += this.energy(this.propagate(inputvet[i]), correctoutputvet[i]);
                }
                AnalysisLogger.getLogger().debug((Object)("Learning Score: " + this.en));
                this.status = (float)(++counter) / (float)this.maxcycle;
                if (this.en == enprec) break;
                enprec = this.en;
            }
            System.out.println("Scarto Finale: " + this.en);
            if ((double)counter >= this.maxcycle) {
                AnalysisLogger.getLogger().debug((Object)"training incomplete: didn't manage to reduce the error under the thr!");
            } else {
                AnalysisLogger.getLogger().debug((Object)"training complete!");
            }
            this.status = 100.0f;
        }
    }

    private double energy(double[] vettore1, double[] vettore2) {
        double nrg = (float)Math.pow(vettore1[0] - vettore2[0], 2.0);
        for (int i = 1; i < vettore2.length; ++i) {
            nrg += Math.pow(vettore1[i] - vettore2[i], 2.0);
        }
        return (float)(0.5 * nrg);
    }

    public void writeout(double numero, double soglia) {
        if (numero < soglia) {
            System.out.println("Uscita : 0");
        } else {
            System.out.println("Uscita : 1");
        }
    }

    public double[] getClassification(double[] out) {
        double[] o = new double[out.length];
        for (int i = 0; i < out.length; ++i) {
            o[i] = out[i] < this.acceptanceThr ? 0.0 : 1.0;
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Neural_Network loadNN(String nomeFile) {
        Neural_Network nn = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(nomeFile);
            ObjectInputStream ois = new ObjectInputStream(stream);
            nn = (Neural_Network)ois.readObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)("Error in reading the object from file " + nomeFile + " ."));
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return nn;
    }

    public static String generateNNName(String referenceEntity, String username, String neuralNetName) {
        return referenceEntity + "_" + username + "_" + neuralNetName;
    }

    public static void main(String[] args) {
        int[] t = new int[]{2};
        Neural_Network nn = new Neural_Network(2, 1, t, 2);
        double[] input = new double[]{1.0, 1.0};
        double[] output = new double[]{0.0};
        double[] input1 = new double[]{0.1, 0.1};
        double[] output1 = new double[]{0.0};
        double[] input2 = new double[]{1.0, 0.1};
        double[] output2 = new double[]{1.0};
        double[] input3 = new double[]{0.1, 1.0};
        double[] output3 = new double[]{1.0};
        double[][] in = new double[4][];
        double[][] out = new double[4][];
        in[0] = input;
        in[1] = input1;
        out[0] = output;
        out[1] = output1;
        in[2] = input2;
        out[2] = output2;
        in[3] = input3;
        out[3] = output3;
        nn.train(in, out);
        double[] dummy = new double[]{0.0, 0.0};
        System.out.println("responso sul dummy: " + nn.propagate(dummy)[0]);
        nn.writeout(nn.propagate(dummy)[0], 0.5);
    }

    public static enum ACTIVATIONFUNCTION {
        HEAVYSIDE,
        SIGMOID,
        IDENTITY;

    }
}

