/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.DataAnalysis;
import org.gcube.dataanalysis.ecoengine.models.cores.pca.PrincipalComponentAnalysis;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.Operations;
import org.gcube.dataanalysis.ecoengine.utils.Transformations;

public class HabitatRepresentativeness
extends DataAnalysis {
    static String getNumberOfElementsQuery = "select count(*) from %1$s #OPTIONAL#";
    static String getRandomVectors = "select %1$s from %2$s #OPTIONAL# order by RANDOM() limit %3$s";
    String configPath = "./cfg/";
    private LinkedHashMap<String, String> output;
    private static int minimumNumberToTake = 10000;
    private float status;
    private int currentIterationStep;
    private float innerstatus;
    private int maxTests = 2;
    private double meanHRS;
    private double[] meanHRSVector;
    private double currentHRSScore;
    private double[] currentHRSVector;
    List<double[]> frequencyDistrib;
    List<double[]> intervals;

    @Override
    public List<StatisticalType> getInputParameters() {
        ArrayList<StatisticalType> parameters = new ArrayList<StatisticalType>();
        ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
        templates.add(TableTemplates.HCAF);
        templates.add(TableTemplates.TRAININGSET);
        templates.add(TableTemplates.TESTSET);
        ArrayList<TableTemplates> templatesOccurrences = new ArrayList<TableTemplates>();
        templatesOccurrences.add(TableTemplates.OCCURRENCE_AQUAMAPS);
        templatesOccurrences.add(TableTemplates.TRAININGSET);
        templatesOccurrences.add(TableTemplates.TESTSET);
        InputTable p1 = new InputTable(templates, "ProjectingAreaTable", "A Table containing projecting area information");
        PrimitiveType p2 = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, "OptionalCondition", "optional filter for taking area rows", "where oceanarea>0", true);
        InputTable p3 = new InputTable(templates, "PositiveCasesTable", "A Table containing positive cases");
        InputTable p4 = new InputTable(templates, "NegativeCasesTable", "A Table containing negative cases");
        ColumnTypesList p5 = new ColumnTypesList("PositiveCasesTable", "FeaturesColumns", "Features columns", false);
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p3);
        parameters.add(p4);
        parameters.add(p5);
        DatabaseType.addDefaultDBPars(parameters);
        return parameters;
    }

    public List<String> getOutputParameters() {
        ArrayList<String> outputs = new ArrayList<String>();
        outputs.add("HRS_VECTOR");
        outputs.add("HRS");
        return outputs;
    }

    private int calculateNumberOfPoints(String table, String option) {
        String numberOfPositiveCasesQuery = String.format(getNumberOfElementsQuery, table);
        numberOfPositiveCasesQuery = numberOfPositiveCasesQuery.replace("#OPTIONAL#", option != null ? option : "");
        List<Object> totalPoints = DatabaseFactory.executeSQLQuery(numberOfPositiveCasesQuery, this.connection);
        int points = Integer.parseInt("" + totalPoints.get(0));
        return points;
    }

    private double[][] getPoints(String table, String option, String features, int numberOfElemsToTake) {
        String query = String.format(getRandomVectors, features, table, "" + numberOfElemsToTake);
        query = query.replace("#OPTIONAL#", option != null ? option : "");
        AnalysisLogger.getLogger().trace((Object)("Compare - Query to perform for points:" + query));
        List<Object> caughtpoints = DatabaseFactory.executeSQLQuery(query, this.connection);
        int size = 0;
        if (caughtpoints != null) {
            size = caughtpoints.size();
        }
        double[][] points = null;
        if (size > 0) {
            points = new double[size][((Object[])caughtpoints.get(0)).length];
            for (int i = 0; i < size; ++i) {
                if (caughtpoints.get(i) == null) continue;
                Object[] arrayFeatures = (Object[])caughtpoints.get(i);
                for (int j = 0; j < arrayFeatures.length; ++j) {
                    double delement;
                    points[i][j] = delement = arrayFeatures[j] == null ? 0.0 : Double.parseDouble("" + arrayFeatures[j]);
                }
            }
        }
        return points;
    }

    private void calcHRS(String projectingAreaTable, String projectingAreaFeaturesOptionalCondition, String FeaturesColumns, String positiveCasesTable, String negativeCasesTable, int numberOfElements) throws Exception {
        this.innerstatus = 0.0f;
        int numberOfElementsToTake = Operations.calcNumOfRepresentativeElements(numberOfElements, minimumNumberToTake);
        AnalysisLogger.getLogger().trace((Object)("HRS: TAKING " + numberOfElementsToTake + " POINTS ON " + numberOfElements + " FROM THE AREA UNDER ANALYSIS"));
        double[][] areaPoints = this.getPoints(projectingAreaTable, projectingAreaFeaturesOptionalCondition, FeaturesColumns, numberOfElementsToTake);
        AnalysisLogger.getLogger().trace((Object)"HRS: AREA POINTS MATRIX GENERATED");
        this.innerstatus = 10.0f;
        Operations operations = new Operations();
        areaPoints = operations.standardize(areaPoints);
        AnalysisLogger.getLogger().trace((Object)"HRS: MATRIX HAS BEEN STANDARDIZED");
        this.innerstatus = 20.0f;
        PrincipalComponentAnalysis pca = new PrincipalComponentAnalysis();
        pca.calcPCA(areaPoints);
        AnalysisLogger.getLogger().trace((Object)"HRS: PCA HAS BEEN TRAINED");
        this.innerstatus = 30.0f;
        double[][] pcaComponents = pca.getComponentsMatrix(areaPoints);
        AnalysisLogger.getLogger().trace((Object)"HRS: PCA COMPONENT CALCULATED");
        this.innerstatus = 40.0f;
        this.calcFrequenciesDistributionsForComponents(pcaComponents);
        AnalysisLogger.getLogger().trace((Object)"HRS: FREQUENCIES FOR COMPONENTS CALCULATED");
        this.innerstatus = 50.0f;
        double[][] positivePoints = null;
        if (positiveCasesTable != null && positiveCasesTable.length() > 0) {
            positivePoints = this.getPoints(positiveCasesTable, "", FeaturesColumns, numberOfElementsToTake);
        }
        double[][] negativePoints = null;
        if (negativeCasesTable != null && negativeCasesTable.length() > 0) {
            negativePoints = this.getPoints(negativeCasesTable, "", FeaturesColumns, numberOfElementsToTake);
        }
        double[][] habitatPoints = Transformations.mergeMatrixes(positivePoints, negativePoints);
        AnalysisLogger.getLogger().trace((Object)"HRS: HABITAT POINTS BUILT FROM POSITIVE AND NEGATIVE POINTS");
        this.innerstatus = 60.0f;
        habitatPoints = operations.standardize(habitatPoints, operations.means, operations.variances);
        AnalysisLogger.getLogger().trace((Object)"HRS: HABITAT POINTS HAVE BEEN STANDARDIZED RESPECT TO PREVIOUS MEANS AND VARIANCES");
        double[][] habitatPcaComponents = pca.getComponentsMatrix(habitatPoints);
        AnalysisLogger.getLogger().trace((Object)"HRS: HABITAT POINTS HAVE BEEN TRANSFORMED BY PCA");
        this.innerstatus = 70.0f;
        int components = habitatPcaComponents[0].length;
        this.currentHRSVector = new double[components];
        double[][] habitatPcaPointsMatrix = Transformations.traspose(habitatPcaComponents);
        for (int i = 0; i < components; ++i) {
            double[] habitatPcaPoints = habitatPcaPointsMatrix[i];
            double[] habitatPcafrequencies = Operations.calcFrequencies(this.intervals.get(i), habitatPcaPoints);
            habitatPcafrequencies = Operations.normalizeFrequencies(habitatPcafrequencies, habitatPcaPoints.length);
            double[] absdifference = Operations.vectorialAbsoluteDifference(habitatPcafrequencies, this.frequencyDistrib.get(i));
            this.currentHRSVector[i] = Operations.sumVector(absdifference);
        }
        AnalysisLogger.getLogger().trace((Object)"HRS: HRS VECTOR HAS BEEN CALCULATED");
        this.innerstatus = 90.0f;
        this.currentHRSScore = Operations.sumVector(this.currentHRSVector);
        AnalysisLogger.getLogger().trace((Object)"HRS: HRS SCORE HAS BEEN CALCULATED");
        this.innerstatus = 100.0f;
    }

    @Override
    public LinkedHashMap<String, String> analyze() throws Exception {
        try {
            this.status = 0.0f;
            String projectingAreaTable = this.config.getParam("ProjectingAreaTable");
            String projectingAreaFeaturesOptionalCondition = this.config.getParam("OptionalCondition");
            String FeaturesColumns = this.config.getParam("FeaturesColumns").replace(AlgorithmConfiguration.getListSeparator(), ",");
            String positiveCasesTable = this.config.getParam("PositiveCasesTable");
            String negativeCasesTable = this.config.getParam("NegativeCasesTable");
            this.connection = AlgorithmConfiguration.getConnectionFromConfig(this.config);
            this.meanHRS = 0.0;
            int numberOfElements = this.calculateNumberOfPoints(projectingAreaTable, projectingAreaFeaturesOptionalCondition);
            for (int i = 0; i < this.maxTests; ++i) {
                this.currentIterationStep = i;
                AnalysisLogger.getLogger().trace((Object)("ITERATION NUMBER " + (i + 1)));
                this.calcHRS(projectingAreaTable, projectingAreaFeaturesOptionalCondition, FeaturesColumns, positiveCasesTable, negativeCasesTable, numberOfElements);
                this.meanHRS = org.gcube.contentmanagement.lexicalmatcher.utils.MathFunctions.incrementAvg(this.meanHRS, this.currentHRSScore, i);
                if (this.meanHRSVector == null) {
                    this.meanHRSVector = new double[this.currentHRSVector.length];
                }
                for (int j = 0; j < this.currentHRSVector.length; ++j) {
                    this.meanHRSVector[j] = MathFunctions.roundDecimal(org.gcube.contentmanagement.lexicalmatcher.utils.MathFunctions.incrementAvg(this.meanHRSVector[j], this.currentHRSVector[j], i), 2);
                }
                AnalysisLogger.getLogger().trace((Object)("ITERATION FINISHED " + this.meanHRS));
                this.status = Math.min(this.status + 100.0f / (float)this.maxTests, 99.0f);
            }
            this.output = new LinkedHashMap();
            this.output.put("HRS_VECTOR", "" + Transformations.vector2String(this.meanHRSVector));
            this.output.put("HRS", "" + MathFunctions.roundDecimal(this.meanHRS, 2));
            LinkedHashMap<String, String> linkedHashMap = this.output;
            return linkedHashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().error((Object)("ALERT: AN ERROR OCCURRED DURING HRS CALCULATION : " + e.getLocalizedMessage()));
            throw e;
        }
        finally {
            this.status = 100.0f;
            AnalysisLogger.getLogger().trace((Object)"COMPUTATION FINISHED ");
        }
    }

    public void calcFrequenciesDistributionsForComponents(double[][] pcaComponents) {
        this.frequencyDistrib = null;
        if (pcaComponents.length > 0) {
            int sizeDistrib = pcaComponents[0].length;
            this.frequencyDistrib = new ArrayList<double[]>();
            this.intervals = new ArrayList<double[]>();
            double[][] pcaColumns = Transformations.traspose(pcaComponents);
            for (int i = 0; i < sizeDistrib; ++i) {
                double[] pcaPoints = pcaColumns[i];
                double[] interval = Operations.uniformDivide(Operations.getMax(pcaPoints), Operations.getMin(pcaPoints), pcaPoints);
                double[] frequencies = Operations.calcFrequencies(interval, pcaPoints);
                frequencies = Operations.normalizeFrequencies(frequencies, pcaPoints.length);
                this.intervals.add(interval);
                this.frequencyDistrib.add(frequencies);
            }
        }
    }

    public static void visualizeResults(HashMap<String, String> results) {
        for (String key : results.keySet()) {
            System.out.println(key + ":" + results.get(key));
        }
    }

    public static void main(String[] args) throws Exception {
        AnalysisLogger.setLogger("./cfg/" + AlgorithmConfiguration.defaultLoggerFile);
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setParam("ProjectingAreaTable", "hcaf_d");
        config.setParam("OptionalCondition", "where oceanarea>0");
        config.setParam("FeaturesColumns", "depthmean,depthmax,depthmin, sstanmean,sbtanmean,salinitymean,salinitybmean, primprodmean,iceconann,landdist,oceanarea");
        config.setParam("PositiveCasesTable", "presence_data_baskingshark");
        config.setParam("NegativeCasesTable", "absence_data_baskingshark_random");
        HabitatRepresentativeness hsrcalc = new HabitatRepresentativeness();
        hsrcalc.setConfiguration(config);
        hsrcalc.init();
        LinkedHashMap<String, String> output = hsrcalc.analyze();
        for (String param : ((HashMap)output).keySet()) {
            System.out.println(param + ":" + (String)((HashMap)output).get(param));
        }
        System.out.println("FINISHED");
    }

    @Override
    public StatisticalType getOutput() {
        PrimitiveType p = new PrimitiveType(Map.class.getName(), PrimitiveType.stringMap2StatisticalMap(this.output), PrimitiveTypes.MAP, "AnalysisResult", "Habitat Representativeness Score");
        return p;
    }

    @Override
    public float getStatus() {
        return this.status == 100.0f ? this.status : Math.min(this.status + (float)(this.currentIterationStep + 1) * this.innerstatus / (float)this.maxTests, 99.0f);
    }

    @Override
    public String getDescription() {
        return "An evaluator algorithm that calculates the Habitat Representativeness Score, i.e. an indicator of the assessment of whether a specific survey coverage or another environmental features dataset, contains data that are representative of all available habitat variable combinations in an area.";
    }
}

