/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.interfaces;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.DatabaseParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.utils.ResourceFactory;

public abstract class StandardLocalExternalAlgorithm
implements Transducerer {
    protected AlgorithmConfiguration config;
    protected float status = 0.0f;
    protected List<StatisticalType> inputs = new ArrayList<StatisticalType>();
    protected ResourceFactory resourceManager;
    public LinkedHashMap<String, String> outputParameters = new LinkedHashMap();

    protected void addEnumerateInput(Object itemsList, String name, String description, String defaultvalue) {
        this.inputs.add(new PrimitiveType(Enum.class.getName(), itemsList, PrimitiveTypes.ENUMERATED, name, description, defaultvalue));
    }

    protected void addRemoteDatabaseInput(String runtimeResourceName, String urlParameterName, String userParameterName, String passwordParameterName, String driverParameterName, String dialectParameterName) {
        this.inputs.add(new DatabaseType(DatabaseParameters.REMOTEDATABASERRNAME, runtimeResourceName, "RR name"));
        this.inputs.add(new DatabaseType(DatabaseParameters.REMOTEDATABASEURL, urlParameterName, ""));
        this.inputs.add(new DatabaseType(DatabaseParameters.REMOTEDATABASEUSERNAME, userParameterName, ""));
        this.inputs.add(new DatabaseType(DatabaseParameters.REMOTEDATABASEPASSWORD, passwordParameterName, ""));
        this.inputs.add(new DatabaseType(DatabaseParameters.REMOTEDATABASEDRIVER, driverParameterName, ""));
        this.inputs.add(new DatabaseType(DatabaseParameters.REMOTEDATABASEDIALECT, dialectParameterName, ""));
    }

    protected void addStringInput(String name, String description, String defaultvalue) {
        this.inputs.add(new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, name, description, defaultvalue));
    }

    protected void addIntegerInput(String name, String description, String defaultvalue) {
        this.inputs.add(new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, name, description, defaultvalue));
    }

    protected void addDoubleInput(String name, String description, String defaultvalue) {
        this.inputs.add(new PrimitiveType(Double.class.getName(), null, PrimitiveTypes.NUMBER, name, description, defaultvalue));
    }

    protected void addOutputString(String name, String value) {
        this.outputParameters.put(name, value);
    }

    @Override
    public void compute() throws Exception {
        AnalysisLogger.setLogger(this.config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile);
        this.status = 0.0f;
        this.process();
        this.status = 100.0f;
    }

    protected void log(Object message) {
        AnalysisLogger.getLogger().trace(message);
    }

    @Override
    public abstract void init() throws Exception;

    @Override
    public abstract String getDescription();

    @Override
    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.LOCAL;
    }

    @Override
    public List<StatisticalType> getInputParameters() {
        this.setInputParameters();
        return this.inputs;
    }

    protected String getInputParameter(String paramName) {
        return this.config.getParam(paramName);
    }

    @Override
    public StatisticalType getOutput() {
        PrimitiveType p = new PrimitiveType(Map.class.getName(), PrimitiveType.stringMap2StatisticalMap(this.outputParameters), PrimitiveTypes.MAP, "Species Match", "");
        return p;
    }

    @Override
    public String getResourceLoad() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceFactory();
        }
        return this.resourceManager.getResourceLoad(1);
    }

    @Override
    public String getResources() {
        return ResourceFactory.getResources(100.0f);
    }

    @Override
    public float getStatus() {
        return this.status;
    }

    protected abstract void process() throws Exception;

    @Override
    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
    }

    protected abstract void setInputParameters();

    @Override
    public abstract void shutdown();
}

