/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks;

import java.io.Serializable;
import java.util.Random;

public class Neuron
implements Serializable {
    public static final long serialVersionUID = 1L;
    public int attivfun;
    public float[] W;

    public Neuron(int N, int numero) {
        this.attivfun = numero;
        this.W = new float[N];
        Random rand = new Random();
        int i = 0;
        while (i < N) {
            this.W[i] = 2.0f * rand.nextFloat() - 1.0f;
            ++i;
        }
    }

    public Neuron(int N, int numero, float[] V) {
        this.attivfun = numero;
        this.W = new float[N];
        if (V.length == N) {
            int i = 0;
            while (i < N) {
                this.W[i] = V[i];
                ++i;
            }
        } else {
            System.out.println("Error : weights vector lenght is not correct");
        }
    }

    public double generaOutput(double input) {
        if (this.attivfun == 1) {
            if (input > 0.0) {
                return 1.0;
            }
            return 0.0;
        }
        if (this.attivfun == 2) {
            return 1.0 / (1.0 + Math.exp(-1.0 * input));
        }
        if (this.attivfun == 3) {
            return input;
        }
        return 1.0;
    }

    public void aggiornaPesi(float[] V) {
        int i = 0;
        while (i < V.length) {
            int n = i;
            this.W[n] = this.W[n] - V[i];
            ++i;
        }
    }

    public static void main(String[] args) {
        Neuron neuron1 = new Neuron(4, 1);
        System.out.println("con la sigmoide: " + neuron1.generaOutput(1.0));
        System.out.println("con heaviside: " + neuron1.generaOutput(1.0));
        System.out.println("heaviside e input negativo: " + neuron1.generaOutput(-12.0));
        System.out.println("unitaria e input positivo: " + neuron1.generaOutput(12.0));
        float[] G = new float[]{0.1f, 0.2f, 0.1f, 2.0f};
        neuron1.aggiornaPesi(G);
        int i = 0;
        while (i < G.length) {
            System.out.println(neuron1.W[i]);
            ++i;
        }
    }
}

