/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.plotting.graphs;

import java.util.List;
import org.gcube.contentmanagement.graphtools.abstracts.GenericStandaloneGraph;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.portlets.user.timeseries.charts.support.types.GraphData;
import org.gcube.portlets.user.timeseries.charts.support.types.Point;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.util.TableOrder;

public class PieGraph
extends GenericStandaloneGraph {
    private static final long serialVersionUID = 1L;

    public PieGraph(String title) {
        super(title);
    }

    public static void main(String[] args) {
    }

    @Override
    protected Dataset generateDataset() {
        DefaultPieDataset dataset = new DefaultPieDataset();
        dataset.setValue((Comparable)((Object)"One"), (Number)43.2);
        dataset.setValue((Comparable)((Object)"Two"), (Number)10.0);
        dataset.setValue((Comparable)((Object)"Three"), (Number)27.5);
        dataset.setValue((Comparable)((Object)"Four"), (Number)17.5);
        dataset.setValue((Comparable)((Object)"Five"), (Number)11.0);
        dataset.setValue((Comparable)((Object)"Six"), (Number)19.4);
        return dataset;
    }

    @Override
    protected JFreeChart createChart(Dataset dataset) {
        JFreeChart chart = ChartFactory.createMultiplePieChart((String)"Multiple Pie Chart", (CategoryDataset)((DefaultCategoryDataset)dataset), (TableOrder)TableOrder.BY_ROW, (boolean)true, (boolean)true, (boolean)false);
        return chart;
    }

    protected Dataset convert2DatasetOld(GraphData st) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        List<Point<? extends Number, ? extends Number>> pointslist = st.getData();
        int numbOfRows = pointslist.size();
        if (numbOfRows > 0) {
            double value;
            int y;
            int numbOfCols = pointslist.get(0).getEntries().size();
            int x = 0;
            String xlabel = pointslist.get(x).getLabel();
            double max = 0.0;
            for (y = 0; y < numbOfCols; ++y) {
                value = pointslist.get(x).getEntries().get(y).getValue().doubleValue();
                if (!(value > max)) continue;
                max = value;
            }
            for (y = 0; y < numbOfCols; ++y) {
                value = pointslist.get(x).getEntries().get(y).getValue().doubleValue();
                value = value / max * 100.0;
                String ylabel = pointslist.get(x).getEntries().get(y).getLabel();
                AnalysisLogger.getLogger().info((Object)(xlabel + ":" + ylabel + "->" + value));
                dataset.setValue((Comparable)((Object)(xlabel + ":" + ylabel)), value);
            }
        }
        return dataset;
    }

    @Override
    protected GenericStandaloneGraph getInstance(String title) {
        return new PieGraph(title);
    }
}

