/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.lexicalmatcher.analysis.core;

import java.math.BigDecimal;
import java.util.ArrayList;

public class DataTypeRecognizer {
    private static String[] decimalType = new String[]{"decimal", "integer", "int", "ordinal", "length", "position", "real"};
    private static String[] booleanType = new String[]{"bool"};
    private static String[] stringType = new String[]{"varchar", "char", "string", "text"};

    public static String transformTypeFromDB(String DBType) {
        String type = null;
        try {
            type = DataTypeRecognizer.contains(DBType, stringType) ? String.class.getName() : (DataTypeRecognizer.contains(DBType, decimalType) ? BigDecimal.class.getName() : (DataTypeRecognizer.contains(DBType, booleanType) ? Boolean.class.getName() : String.class.getName()));
        }
        catch (Exception e) {
            type = String.class.getName();
        }
        return type;
    }

    public static Object guessType(String entry) {
        Object type = null;
        try {
            double d = Double.parseDouble(entry);
            type = BigDecimal.valueOf(d);
        }
        catch (Exception eD) {
            if (entry.equalsIgnoreCase("true") || entry.equalsIgnoreCase("false")) {
                boolean b = Boolean.parseBoolean(entry);
                type = b;
            }
            type = entry;
        }
        return type;
    }

    private static boolean contains(String element, String[] array) {
        element = element.toLowerCase();
        for (String arrayElem : array) {
            if (!element.contains(arrayElem)) continue;
            return true;
        }
        return false;
    }

    public static String guessType(ArrayList<String> elementlist) {
        int[] scores = new int[3];
        String[] types = new String[]{String.class.getName(), Boolean.class.getName(), BigDecimal.class.getName()};
        for (String element : elementlist) {
            Object guessedObj = DataTypeRecognizer.guessType(element);
            if (guessedObj instanceof String) {
                scores[0] = scores[0] + 1;
                continue;
            }
            if (guessedObj instanceof Boolean) {
                scores[1] = scores[1] + 1;
                continue;
            }
            if (!(guessedObj instanceof BigDecimal)) continue;
            scores[2] = scores[2] + 1;
        }
        int max = -1;
        int maxindex = -1;
        for (int i = 0; i < scores.length; ++i) {
            if (scores[i] <= max) continue;
            max = scores[i];
            maxindex = i;
        }
        String type = types[maxindex];
        return type;
    }

    public static void main(String[] args) throws ClassNotFoundException {
        ArrayList<String> prova = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            prova.add("1234");
        }
        String classtype = DataTypeRecognizer.guessType(prova);
        System.out.println(classtype);
    }
}

