/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.test.checks;

import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.interfaces.Modeler;
import org.gcube.dataanalysis.ecoengine.processing.factories.ModelersFactory;

public class TestsHSPENTraining {
    public static void main(String[] args) throws Exception {
        System.out.println("TEST 1");
        List<Modeler> modelers = ModelersFactory.getModelers(TestsHSPENTraining.testConfig());
        TestsHSPENTraining.train(modelers.get(0), TestsHSPENTraining.testConfig());
        modelers = null;
    }

    private static void train(Modeler modeler, AlgorithmConfiguration config) throws Exception {
        if (modeler != null) {
            TestsHSPENTraining tgs;
            TestsHSPENTraining testsHSPENTraining = tgs = new TestsHSPENTraining();
            testsHSPENTraining.getClass();
            ThreadCalculator tc = testsHSPENTraining.new ThreadCalculator(modeler, config);
            Thread t = new Thread(tc);
            t.start();
            while (modeler.getStatus() < 100.0f) {
                String resLoad = modeler.getResourceLoad();
                String ress = modeler.getResources();
                System.out.println("LOAD: " + resLoad);
                System.out.println("RESOURCES: " + ress);
                System.out.println("STATUS: " + modeler.getStatus());
                Thread.sleep(1000L);
            }
            System.out.println("FINAL STATUS: " + modeler.getStatus());
        } else {
            AnalysisLogger.getLogger().trace((Object)"Generator Algorithm Not Supported");
        }
    }

    private static AlgorithmConfiguration testConfig() {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setNumberOfResources(2);
        config.setModel("HSPEN");
        config.setParam("OuputEnvelopeTable", "hspen_trained");
        config.setParam("OccurrenceCellsTable", "occurrencecells");
        config.setParam("EnvelopeTable", "hspen_mini");
        config.setParam("CsquarecodesTable", "hcaf_d");
        config.setParam("CreateTable", "true");
        return config;
    }

    public class ThreadCalculator
    implements Runnable {
        Modeler dg;
        AlgorithmConfiguration config;

        public ThreadCalculator(Modeler dg, AlgorithmConfiguration config) {
            this.dg = dg;
            this.config = config;
        }

        @Override
        public void run() {
            try {
                this.dg.model(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

