package org.gcube.dataanalysis.ecoengine.test.checks;

import java.util.List;

import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.interfaces.Generator;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;

public class TestsDUMMYGeneration {
	/**
	 * example of parallel processing on a single machine the procedure will generate a new table for a distribution on suitable species
	 * 
	 */

public static void main(String[] args) throws Exception {
		
		System.out.println("TEST 1");
		List<Generator> generators = GeneratorsFactory.getGenerators(testConfig());
		generators.get(0).init();
		generate(generators.get(0));
		generators = null;
}

	
	private static void generate(Generator generator) throws Exception {

		if (generator != null) {
			TestsDUMMYGeneration tgs = new TestsDUMMYGeneration();
			ThreadCalculator tc = tgs.new ThreadCalculator(generator);
			Thread t = new Thread(tc);
			t.start();
			while (generator.getStatus() < 100) {

				String resLoad = generator.getResourceLoad();
				String ress = generator.getResources();
				String species = generator.getLoad();
				System.out.println("LOAD: " + resLoad);
				System.out.println("RESOURCES: " + ress);
				System.out.println("SPECIES: " + species);
				System.out.println("STATUS: " + generator.getStatus());
				Thread.sleep(1000);
			}
		} else
			AnalysisLogger.getLogger().trace("Generator Algorithm Not Supported");

	}

	public class ThreadCalculator implements Runnable {
		Generator dg;

		public ThreadCalculator(Generator dg) {
			this.dg = dg;
		}

		public void run() {
			try {

				dg.compute();

			} catch (Exception e) {
			}
		}

	}
	

	private static AlgorithmConfiguration testConfig() {
		AlgorithmConfiguration config = new AlgorithmConfiguration();
		config.setConfigPath("./cfg/");
		config.setPersistencePath("./");
		config.setNumberOfResources(10);
		config.setModel("DUMMY");
		return config;
	}
	
}
