package org.gcube.dataanalysis.ecoengine.processing.factories;

import java.util.ArrayList;
import java.util.List;

import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.Clusterer;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;

public class TransducerersFactory {

	public static Transducerer getTransducerer(AlgorithmConfiguration config) throws Exception {
		Transducerer tran = (Transducerer) ProcessorsFactory.getProcessor(config, config.getConfigPath() + AlgorithmConfiguration.transducererFile);
		return tran;
	}

	public static List<String> getAllTransducerers(String configPath) throws Exception {
		List<String> trans = ProcessorsFactory.getClasses(configPath + AlgorithmConfiguration.transducererFile);
		return trans;
	}

	public static List<StatisticalType> getTransducerParameters(String configPath, String algorithmName) throws Exception {
		List<StatisticalType> inputs = ProcessorsFactory.getParameters(configPath + AlgorithmConfiguration.transducererFile, algorithmName);
		return inputs;
	}

	public static String getDescription(String configPath, String algorithmName) throws Exception{
		String input = ProcessorsFactory.getDescription(configPath + AlgorithmConfiguration.transducererFile, algorithmName);
		return input;
		}
	
	public static List<Transducerer> getTransducerers(AlgorithmConfiguration config) throws Exception {
		List<Transducerer> clusterers = new ArrayList<Transducerer>();
		clusterers.add(getTransducerer(config));
		return clusterers;
	}

}
