/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.models.cores.pca;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.features.transformation.PCA;
import com.rapidminer.operator.features.transformation.PCAModel;
import com.rapidminer.tools.OperatorService;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.Operations;
import org.gcube.dataanalysis.ecoengine.utils.Transformations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalComponentAnalysis {
    private static Logger logger = LoggerFactory.getLogger(PrincipalComponentAnalysis.class);
    PCAModel innermodel;
    int numberOfComponents;

    public void init(AlgorithmConfiguration config) {
        config.initRapidMiner();
    }

    public PCAModel getModel() {
        return this.innermodel;
    }

    public double[] getEigenvector(int index) {
        return this.innermodel.getEigenvector(index);
    }

    public double getEigenvalue(int index) {
        return this.innermodel.getEigenvalue(index);
    }

    public double[] getEigenvalues() {
        double[] values = new double[this.numberOfComponents];
        for (int i = 0; i < this.numberOfComponents; ++i) {
            values[i] = this.getEigenvalue(i);
        }
        return values;
    }

    public double[] getNormalizedEigenvalues() {
        double[] values = new double[this.numberOfComponents];
        for (int i = 0; i < this.numberOfComponents; ++i) {
            values[i] = this.getEigenvalue(i);
        }
        double sumEigen = Operations.sumVector(values);
        for (int i = 0; i < this.numberOfComponents; ++i) {
            values[i] = values[i] / sumEigen;
        }
        return values;
    }

    public double[] getInverseEigenvalues() {
        double[] values = new double[this.numberOfComponents];
        for (int i = 0; i < this.numberOfComponents; ++i) {
            values[i] = 1.0 / this.getEigenvalue(i);
        }
        return values;
    }

    public double[] getInverseNormalizedEigenvalues() {
        double[] values = new double[this.numberOfComponents];
        double[] weightedEigens = this.getNormalizedEigenvalues();
        for (int i = 0; i < this.numberOfComponents; ++i) {
            values[i] = 1.0 / weightedEigens[i];
        }
        return values;
    }

    public double[][] getComponentsMatrix(double[][] vectors) throws Exception {
        int nsamples = vectors.length;
        double[][] components = new double[nsamples][];
        for (int i = 0; i < nsamples; ++i) {
            components[i] = this.getComponents(vectors[i]);
        }
        return components;
    }

    public double[] getComponents(double[] vector) throws Exception {
        double[] components = new double[this.numberOfComponents];
        for (int i = 0; i < this.numberOfComponents; ++i) {
            components[i] = Operations.scalarProduct(vector, this.getEigenvector(i));
        }
        return components;
    }

    protected double[][] getPCA(double[][] sampleVectors) throws Exception {
        ExampleSet set = Transformations.matrix2ExampleSet(sampleVectors);
        ExampleSet outset = this.innermodel.apply(set);
        return Transformations.exampleSet2Matrix(outset);
    }

    public void calcPCA(double[][] sampleVectors) throws Exception {
        logger.debug("STARTING PCA COMPUTATION");
        PCA pca = (PCA)OperatorService.createOperator((String)"PCA");
        pca.setParameter("variance_threshold", "0.95");
        pca.setParameter("dimensionality_reduction", "keep variance");
        pca.setParameter("number_of_components", "-1");
        ExampleSet set = Transformations.matrix2ExampleSet(sampleVectors);
        IOContainer innerInput = new IOContainer(new IOObject[]{set});
        IOContainer output = pca.apply(innerInput);
        IOObject[] outputvector = output.getIOObjects();
        this.innermodel = (PCAModel)outputvector[1];
        this.numberOfComponents = this.innermodel.getMaximumNumberOfComponents();
        logger.debug("MODEL APPLIED");
    }
}

