/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.clustering;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.gcube.dataanalysis.ecoengine.clustering.DBScan;
import org.gcube.dataanalysis.ecoengine.clustering.XMeans;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.CSVLoader;

public class XMeansWrapper
extends DBScan {
    private static Logger logger = LoggerFactory.getLogger(XMeansWrapper.class);
    private String maxIterations;
    private String minClusters;
    private String maxClusters;

    public XMeansWrapper() {
        this.initrapidminer = false;
    }

    @Override
    public List<StatisticalType> getInputParameters() {
        ArrayList<StatisticalType> parameters = new ArrayList<StatisticalType>();
        ArrayList<TableTemplates> templateOccs = new ArrayList<TableTemplates>();
        templateOccs.add(TableTemplates.GENERIC);
        InputTable p1 = new InputTable(templateOccs, "OccurrencePointsTable", "Occurrence Points Table. Max 4000 points", "occurrences");
        ColumnTypesList p2 = new ColumnTypesList("OccurrencePointsTable", "FeaturesColumnNames", "column Names for the features", false);
        PrimitiveType p0 = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, "OccurrencePointsClusterLabel", "table name of the resulting distribution", "OccCluster_");
        ServiceType p3 = new ServiceType(ServiceParameters.RANDOMSTRING, "OccurrencePointsClusterTable", "table name of the distribution", "occCluster_");
        PrimitiveType p4 = new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, "maxIterations", "XMeans max number of overall iterations of the clustering learning", "10");
        PrimitiveType p5 = new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, "minClusters", "minimum number of expected clusters", "1");
        PrimitiveType p12 = new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, "maxClusters", "maximum number of clusters to produce", "50");
        PrimitiveType p13 = new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, "min_points", "number of points which define an outlier set", "2");
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p0);
        parameters.add(p3);
        parameters.add(p4);
        parameters.add(p5);
        parameters.add(p12);
        parameters.add(p13);
        DatabaseType.addDefaultDBPars(parameters);
        return parameters;
    }

    @Override
    public String getDescription() {
        return "A clustering algorithm for occurrence points that relies on the X-Means algorithm, i.e. an extended version of the K-Means algorithm improved by an Improve-Structure part. A Maximum of 4000 points is allowed.";
    }

    @Override
    public void setConfiguration(AlgorithmConfiguration config) {
        if (config != null) {
            this.maxIterations = config.getParam("maxIterations");
            this.minClusters = config.getParam("minClusters");
            this.maxClusters = config.getParam("maxClusters");
            this.minPoints = config.getParam("min_points");
            this.OccurrencePointsTable = config.getParam("OccurrencePointsTable").toLowerCase();
            this.OccurrencePointsClusterLabel = config.getParam("OccurrencePointsClusterLabel");
            this.OccurrencePointsClusterTable = config.getParam("OccurrencePointsClusterTable").toLowerCase();
            this.FeaturesColumnNames = config.getParam("FeaturesColumnNames");
            this.config = config;
        }
    }

    @Override
    public void compute() throws Exception {
        try {
            if (this.config == null || this.maxIterations == null || this.minClusters == null || this.maxClusters == null) {
                throw new Exception("XMeans: Error incomplete parameters");
            }
            if (this.samplesVector != null && this.samplesVector.length > 0) {
                logger.debug("XMeans: Setting up the cluster");
                CSVLoader loader = new CSVLoader();
                StringBuffer sb = new StringBuffer();
                for (int i = -1; i < this.samplesVector.length; ++i) {
                    for (int j = 0; j < this.samplesVector[0].length; ++j) {
                        if (i == -1) {
                            sb.append("F" + j);
                        } else {
                            sb.append(this.samplesVector[i][j]);
                        }
                        if (j < this.samplesVector[0].length - 1) {
                            sb.append(",");
                            continue;
                        }
                        sb.append("\n");
                    }
                }
                ByteArrayInputStream tis = new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
                loader.setSource((InputStream)tis);
                Instances id = loader.getDataSet();
                long ti = System.currentTimeMillis();
                XMeans xmeans = new XMeans();
                xmeans.setMaxIterations(Integer.parseInt(this.maxIterations));
                xmeans.setMinNumClusters(Integer.parseInt(this.minClusters));
                xmeans.setMaxNumClusters(Integer.parseInt(this.maxClusters));
                xmeans.buildClusterer(id);
                logger.debug("XMEANS: ...ELAPSED CLUSTERING TIME: " + (System.currentTimeMillis() - ti));
                this.status = 50.0f;
                logger.debug("XMeans: Clustering ...");
                Instances is = xmeans.getClusterCenters();
                int nClusters = is.numInstances();
                logger.debug("XMeans: Found " + nClusters + " Centroids");
                for (Instance i : is) {
                    DenseInstance di = (DenseInstance)i;
                    int nCluster = di.numAttributes();
                    for (int k = 0; k < nCluster; ++k) {
                        logger.debug(di.toString(k));
                    }
                    logger.debug("-------------------------------");
                }
                int[] clusteringAssignments = xmeans.m_ClusterAssignments;
                int[] counters = new int[nClusters];
                int[] nArray = clusteringAssignments;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int cluster;
                    int n2 = cluster = nArray[i];
                    counters[n2] = counters[n2] + 1;
                }
                logger.debug("XMeans: Building Table");
                this.BuildClusterTable(clusteringAssignments, counters);
            } else {
                logger.debug("XMeans: Warning - Empty Training Set");
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shutdown();
            this.status = 100.0f;
        }
    }

    protected void BuildClusterTable(int[] clusteringAssignments, int[] counters) throws Exception {
        String columnsNames = this.FeaturesColumnNames + "," + clusterColumn + "," + outliersColumn;
        int minpoints = Integer.parseInt(this.minPoints);
        logger.debug("Analyzing Cluster -> minpoints " + minpoints);
        StringBuffer bufferRows = new StringBuffer();
        int nrows = this.samplesVector.length;
        int ncols = this.samplesVector[0].length;
        logger.debug("Analyzing Cluster ->Building Rows to Insert");
        for (int k = 0; k < nrows; ++k) {
            bufferRows.append("(");
            int cindex = clusteringAssignments[k];
            boolean isoutlier = counters[cindex] <= minpoints;
            for (int j = 0; j < ncols; ++j) {
                bufferRows.append(this.samplesVector[k][j]);
                bufferRows.append(",");
            }
            bufferRows.append(cindex + "," + isoutlier + ")");
            if (k >= nrows - 1) continue;
            bufferRows.append(",");
        }
        logger.debug("Analyzing Cluster ->Inserting rows");
        if (bufferRows.length() > 0) {
            logger.debug("XMeans: Writing into DB");
            logger.debug(DatabaseUtils.insertFromBuffer(this.OccurrencePointsClusterTable, columnsNames, bufferRows));
            DatabaseFactory.executeSQLUpdate(DatabaseUtils.insertFromBuffer(this.OccurrencePointsClusterTable, columnsNames, bufferRows), this.dbHibConnection);
            logger.debug("XMeans: Finished with writing into DB");
        } else {
            logger.debug("XMeans: Nothing to write in the buffer");
        }
        this.status = 95.0f;
        logger.debug("XMeans: Status: " + this.status);
    }

    public class CSV2Arff {
    }
}

