/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.connectors.livemonitor.ResourceLoad;
import org.gcube.dataanalysis.ecoengine.connectors.livemonitor.Resources;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.DatabaseParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.Model;
import org.gcube.dataanalysis.ecoengine.models.cores.aquamaps.AquamapsEnvelopeAlgorithm;
import org.gcube.dataanalysis.ecoengine.models.cores.aquamaps.EnvelopeSet;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.hibernate.SessionFactory;

public class ModelHSPEN
implements Model {
    private float version;
    protected SessionFactory connection;
    private static final String alterQuery = "UPDATE %HSPEN% SET %1$s WHERE speciesid = '%2$s'";
    private static final String dropHspenTable = "DROP TABLE %HSPEN%; ";
    private static final String createHspenTable = "CREATE TABLE %HSPEN% ( speccode integer, speciesid character varying NOT NULL, lifestage character varying NOT NULL, faoareas character varying(100), faoareasref character varying, faocomplete smallint, nmostlat real, smostlat real, wmostlong real,emostlong real, lme character varying(180), depthyn smallint, depthmin integer, depthmax integer,  depthprefmin integer,  depthprefmax integer,  meandepth smallint,  depthref character varying,  pelagic smallint,  tempyn smallint,  tempmin real,  tempmax real,  tempprefmin real,  tempprefmax real,  tempref character varying,  salinityyn smallint,  salinitymin real,  salinitymax real,  salinityprefmin real,  salinityprefmax real,  salinityref character varying,  primprodyn smallint,  primprodmin real,  primprodmax real,  primprodprefmin real,  primprodprefmax real,  primprodprefref character varying,  iceconyn smallint,  iceconmin real,  iceconmax real,  iceconprefmin real,  iceconprefmax real,  iceconref character varying,  landdistyn smallint,  landdistmin real,  landdistmax real,  landdistprefmin real,  landdistprefmax real,  landdistref character varying,  remark character varying,  datecreated timestamp without time zone,  datemodified timestamp without time zone,  expert integer,  dateexpert timestamp without time zone,  envelope smallint,  mapdata smallint,  effort smallint,  layer character(1),  usepoints smallint,  rank smallint,  CONSTRAINT %HSPEN%_pkey PRIMARY KEY (speciesid, lifestage))WITH (  OIDS=FALSE); CREATE INDEX envelope_%HSPEN%_idx   ON %HSPEN%  USING btree  (envelope); CREATE INDEX mapdata_%HSPEN%_idx  ON %HSPEN%  USING btree  (mapdata); CREATE INDEX speciesid_%HSPEN%_idx  ON %HSPEN%  USING btree  (speciesid);";
    private static final String populateNewHspen = "insert into %HSPEN% (select * from %HSPEN_ORIGIN%);";
    private static final String speciesListQuery = "select distinct speciesid from %HSPEN%;";
    private static final String hspenListQuery = "select speciesid, layer, iceconmin , iceconmax , iceconprefmin , iceconprefmax , salinitymin , salinitymax , salinityprefmin , salinityprefmax , landdistmin , landdistmax , landdistprefmin , landdistprefmax , tempmin , tempmax , tempprefmin , tempprefmax ,  primprodmin ,  primprodmax ,  primprodprefmin ,  primprodprefmax  from %HSPEN%;";
    String defaultDatabaseFile = "DestinationDBHibernate.cfg.xml";
    String defaultLogFile = "ALog.properties";
    private String dynamicAlterQuery;
    private String dynamicDropTable;
    private String dynamicCreateTable;
    private String dynamicPopulateNewHspen;
    private String dynamicSpeciesListQuery;
    private String dynamicHspenInformationQuery;
    private String currentHCAFTable;
    private String currentOccurrenceTable;
    private int numberOfthreads;
    private ExecutorService executorService;
    private boolean[] threadActivity;
    private int countDifferences;
    private boolean interruptProcessing;
    private float status;
    private int numbOfProcessedSpecies;
    HashMap<String, List<Object>> allSpeciesHspen;
    private int lastProcessedRecordsNumber;
    private long lastTime;
    AlgorithmConfiguration outconfig;
    private String outputTable;
    private String outputTableLabel;

    @Override
    public float getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return "HSPEN";
    }

    @Override
    public void init(AlgorithmConfiguration setup, Model previousModel) {
        this.outconfig = setup;
        this.defaultDatabaseFile = setup.getConfigPath() + this.defaultDatabaseFile;
        AnalysisLogger.setLogger(setup.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile);
        try {
            String defaultDatabaseFile = setup.getConfigPath() + AlgorithmConfiguration.defaultConnectionFile;
            setup.setDatabaseDriver(setup.getParam("DatabaseDriver"));
            setup.setDatabaseUserName(setup.getParam("DatabaseUserName"));
            setup.setDatabasePassword(setup.getParam("DatabasePassword"));
            setup.setDatabaseURL(setup.getParam("DatabaseURL"));
            this.connection = DatabaseFactory.initDBConnection(defaultDatabaseFile, setup);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().error((Object)"error intitializing", (Throwable)e);
        }
        this.outputTable = this.outconfig.getParam("OuputEnvelopeTable");
        this.outputTableLabel = this.outconfig.getParam("OuputEnvelopeTableLabel");
        this.dynamicAlterQuery = alterQuery.replace("%HSPEN%", this.outconfig.getParam("OuputEnvelopeTable"));
        this.dynamicDropTable = dropHspenTable.replace("%HSPEN%", this.outconfig.getParam("OuputEnvelopeTable"));
        this.dynamicCreateTable = createHspenTable.replace("%HSPEN%", this.outconfig.getParam("OuputEnvelopeTable"));
        this.dynamicPopulateNewHspen = populateNewHspen.replace("%HSPEN_ORIGIN%", this.outconfig.getParam("EnvelopeTable")).replace("%HSPEN%", this.outconfig.getParam("OuputEnvelopeTable"));
        this.dynamicSpeciesListQuery = speciesListQuery.replace("%HSPEN%", this.outconfig.getParam("EnvelopeTable"));
        this.dynamicHspenInformationQuery = hspenListQuery.replace("%HSPEN%", this.outconfig.getParam("EnvelopeTable"));
        this.currentHCAFTable = this.outconfig.getParam("CsquarecodesTable");
        this.currentOccurrenceTable = this.outconfig.getParam("OccurrenceCellsTable");
        this.numberOfthreads = this.outconfig.getNumberOfResources();
        this.interruptProcessing = false;
        this.status = 0.0f;
    }

    private List<Object> populateSpecies() {
        AnalysisLogger.getLogger().trace((Object)"Distribution Generator ->getting all species list from DB");
        List<Object> allspecies = DatabaseFactory.executeSQLQuery(this.dynamicSpeciesListQuery, this.connection);
        return allspecies;
    }

    private HashMap<String, List<Object>> populateHspen() {
        HashMap<String, List<Object>> allSpeciesHspen = new HashMap<String, List<Object>>();
        List<Object> SpeciesInfo = DatabaseFactory.executeSQLQuery(this.dynamicHspenInformationQuery, this.connection);
        int lenSpecies = SpeciesInfo.size();
        for (int i = 0; i < lenSpecies; ++i) {
            Object[] speciesArray = (Object[])SpeciesInfo.get(i);
            String speciesid = (String)speciesArray[0];
            ArrayList<Object[]> singleSpeciesInfo = new ArrayList<Object[]>();
            singleSpeciesInfo.add(speciesArray);
            allSpeciesHspen.put(speciesid, singleSpeciesInfo);
        }
        return allSpeciesHspen;
    }

    public void initializeThreads(int numberOfThreadsToUse) {
        this.executorService = Executors.newFixedThreadPool(numberOfThreadsToUse);
        this.threadActivity = new boolean[numberOfThreadsToUse];
        for (int j = 0; j < this.threadActivity.length; ++j) {
            this.threadActivity[j] = false;
        }
    }

    private void wait4Thread(int index) {
        while (this.threadActivity[index]) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void shutdownConnection() {
        this.connection.close();
    }

    private void generateTable(Object Input) throws Exception {
        AlgorithmConfiguration config = (AlgorithmConfiguration)Input;
        if (config.getParam("CreateTable").equalsIgnoreCase("true")) {
            AnalysisLogger.getLogger().trace((Object)("Distribution Generator->recreating new table " + this.dynamicCreateTable));
            try {
                DatabaseFactory.executeSQLUpdate(String.format(this.dynamicDropTable, config.getDatabaseUserName()), this.connection);
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().trace((Object)"Impossible to drop table - maybe not existing");
            }
            try {
                DatabaseFactory.executeSQLUpdate(String.format(this.dynamicCreateTable, config.getDatabaseUserName()), this.connection);
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().trace((Object)"Impossible to create table - maybe yet existing");
            }
        }
        AnalysisLogger.getLogger().trace((Object)("Distribution Generator->populating new table " + this.dynamicPopulateNewHspen));
        DatabaseFactory.executeSQLUpdate(this.dynamicPopulateNewHspen, this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void train(AlgorithmConfiguration Input, Model previousModel) {
        long tstart = System.currentTimeMillis();
        try {
            AnalysisLogger.getLogger().trace((Object)"ModelHSPENr->populating species");
            List<Object> allspecies = this.populateSpecies();
            this.allSpeciesHspen = this.populateHspen();
            AnalysisLogger.getLogger().trace((Object)"ModelHSPENr->ENVELOPES GENERATION STARTED");
            this.initializeThreads(this.numberOfthreads);
            this.generateTable(Input);
            int currentThread = 0;
            int globalcounter = 0;
            this.countDifferences = 0;
            long computationT0 = System.currentTimeMillis();
            int numberOfSpecies = allspecies.size();
            for (Object species : allspecies) {
                String speciesid = (String)species;
                if (speciesid.length() > 0) {
                    float s;
                    AnalysisLogger.getLogger().trace((Object)("ModelHSPENr->ANALIZING SPECIES: " + speciesid));
                    this.wait4Thread(currentThread);
                    this.startNewTCalc(currentThread, speciesid);
                    if (++currentThread >= this.numberOfthreads) {
                        currentThread = 0;
                    }
                    this.status = (s = (float)((int)((float)globalcounter * 100.0f / (float)numberOfSpecies * 100.0f)) / 100.0f) == 100.0f ? 99.0f : s;
                    AnalysisLogger.getLogger().trace((Object)("STATUS->" + this.status + "%"));
                    ++globalcounter;
                    AnalysisLogger.getLogger().warn((Object)("Number of Found Differences: " + this.countDifferences));
                }
                if (!this.interruptProcessing) continue;
                break;
            }
            for (int i = 0; i < this.numberOfthreads; ++i) {
                this.wait4Thread(i);
            }
            long computationT1 = System.currentTimeMillis();
            AnalysisLogger.getLogger().warn((Object)("All Envelopes Computation Finished in " + (computationT1 - computationT0) + " ms"));
            AnalysisLogger.getLogger().warn((Object)("Number of Overall Found Differences: " + this.countDifferences));
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().trace((Object)"Computation traminate prematurely: ", (Throwable)e);
        }
        finally {
            this.executorService.shutdown();
            this.shutdownConnection();
            this.status = 100.0f;
            long tstop = System.currentTimeMillis();
            AnalysisLogger.getLogger().warn((Object)("All Envelopes Computation Finished in " + (tstop - tstart) + " ms"));
        }
    }

    private void startNewTCalc(int index, String species) {
        this.threadActivity[index] = true;
        ThreadCalculator tc = new ThreadCalculator(index, species);
        this.executorService.submit(tc);
    }

    public void calcEnvelopes(String species) {
        long t0 = System.currentTimeMillis();
        try {
            List<Object> singleHspen = this.allSpeciesHspen.get(species);
            EnvelopeSet envSet = AquamapsEnvelopeAlgorithm.calculateEnvelopes(species, this.connection, this.currentOccurrenceTable, this.currentHCAFTable, (Object[])singleHspen.get(0));
            String instruction = envSet.getEnvelopeString();
            long t1 = System.currentTimeMillis();
            AnalysisLogger.getLogger().trace((Object)("Computation for species " + species + " finished in " + (t1 - t0) + " ms"));
            if (instruction.length() > 0) {
                ++this.countDifferences;
                String query = String.format(this.dynamicAlterQuery, instruction, species);
                try {
                    AnalysisLogger.getLogger().trace((Object)("Envelope Generated - executing query: " + query));
                    DatabaseFactory.executeSQLUpdate(query, this.connection);
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().trace((Object)"could not execute update");
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            AnalysisLogger.getLogger().trace((Object)"Computation traminated prematurely: ", (Throwable)ex);
        }
        ++this.numbOfProcessedSpecies;
    }

    @Override
    public StatisticalType getOutput() {
        ArrayList<TableTemplates> templateHspen = new ArrayList<TableTemplates>();
        templateHspen.add(TableTemplates.HSPEN);
        OutputTable p = new OutputTable(templateHspen, this.outputTableLabel, this.outputTable, "Output hspen table");
        return p;
    }

    @Override
    public void setVersion(float version) {
        this.version = version;
    }

    @Override
    public void postprocess(AlgorithmConfiguration Input, Model previousModel) {
    }

    @Override
    public String getResourceLoad() {
        String returnString = "";
        try {
            long tk = System.currentTimeMillis();
            double activity = Double.valueOf(this.numbOfProcessedSpecies - this.lastProcessedRecordsNumber) * 1000.0 / Double.valueOf(tk - this.lastTime);
            this.lastTime = tk;
            this.lastProcessedRecordsNumber = this.numbOfProcessedSpecies;
            ResourceLoad rs = new ResourceLoad(tk, activity);
            returnString = rs.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            long tk = System.currentTimeMillis();
            returnString = new ResourceLoad(tk, 0.0).toString();
        }
        return returnString;
    }

    @Override
    public String getResources() {
        Resources res = new Resources();
        try {
            for (int i = 0; i < this.numberOfthreads; ++i) {
                try {
                    double value = this.threadActivity[i] ? 100.0 : 0.0;
                    res.addResource("Thread_" + (i + 1), value);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res != null && res.list != null) {
            return HttpRequest.toJSon(res.list).replace("resId", "resID");
        }
        return "";
    }

    @Override
    public void stop() {
        this.interruptProcessing = true;
    }

    @Override
    public float getStatus() {
        return this.status;
    }

    @Override
    public ALG_PROPS[] getProperties() {
        ALG_PROPS[] props = new ALG_PROPS[]{ALG_PROPS.SPECIES_ENVELOPES};
        return props;
    }

    @Override
    public String getDescription() {
        return "The AquMaps HSPEN algorithm. A modeling algorithm that generates a table containing species envelops (HSPEN), i.e. models capturing species tolerance with respect to environmental parameters, to be used by the AquaMaps approach.";
    }

    @Override
    public List<StatisticalType> getInputParameters() {
        ArrayList<StatisticalType> parameters = new ArrayList<StatisticalType>();
        ArrayList<TableTemplates> templatesOccurrences = new ArrayList<TableTemplates>();
        templatesOccurrences.add(TableTemplates.OCCURRENCE_AQUAMAPS);
        ArrayList<TableTemplates> templateHspen = new ArrayList<TableTemplates>();
        templateHspen.add(TableTemplates.HSPEN);
        ArrayList<TableTemplates> templateHcaf = new ArrayList<TableTemplates>();
        templateHcaf.add(TableTemplates.HCAF);
        InputTable p1 = new InputTable(templateHspen, "EnvelopeTable", "The previous hspen table for regeneration", "hspen");
        InputTable p2 = new InputTable(templateHcaf, "CsquarecodesTable", "HCaf Table", "hcaf_d");
        InputTable p3 = new InputTable(templatesOccurrences, "OccurrenceCellsTable", "Ocurrence Cells Table", "occurrencecells");
        PrimitiveType p4 = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.CONSTANT, "CreateTable", "Create New Table for each computation", "true");
        PrimitiveType p5 = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, "OuputEnvelopeTableLabel", "Table name for the new hspen", "hspen_1");
        ServiceType p11 = new ServiceType(ServiceParameters.RANDOMSTRING, "OuputEnvelopeTable", "Table name for the new hspen", "hspen_");
        DatabaseType p6 = new DatabaseType(DatabaseParameters.DATABASEUSERNAME, "DatabaseUserName", "db user name");
        DatabaseType p7 = new DatabaseType(DatabaseParameters.DATABASEPASSWORD, "DatabasePassword", "db password");
        DatabaseType p8 = new DatabaseType(DatabaseParameters.DATABASEDRIVER, "DatabaseDriver", "db driver");
        DatabaseType p9 = new DatabaseType(DatabaseParameters.DATABASEURL, "DatabaseURL", "db url");
        DatabaseType p10 = new DatabaseType(DatabaseParameters.DATABASEDIALECT, "DatabaseDialect", "db dialect");
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p3);
        parameters.add(p4);
        parameters.add(p5);
        parameters.add(p6);
        parameters.add(p7);
        parameters.add(p8);
        parameters.add(p9);
        parameters.add(p10);
        parameters.add(p11);
        return parameters;
    }

    private class ThreadCalculator
    implements Callable<Integer> {
        int index;
        String species;

        public ThreadCalculator(int index, String species) {
            this.species = species;
            this.index = index;
        }

        @Override
        public Integer call() {
            try {
                ModelHSPEN.this.calcEnvelopes(this.species);
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().trace((Object)("" + e));
                e.printStackTrace();
            }
            ((ModelHSPEN)ModelHSPEN.this).threadActivity[this.index] = false;
            return 0;
        }
    }
}

