/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.DataTypeRecognizer;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data.Category;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data.Entry;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data.RelationEdge;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.hibernate.SessionFactory;

public class DBObjectTranslator {
    public ArrayList<RelationEdge> relations = new ArrayList();
    public ArrayList<Category> categories = new ArrayList();
    public BigInteger totalEntries;
    public BigInteger totalCatElements = BigInteger.ZERO;
    public BigInteger totalRelationElements = BigInteger.ZERO;

    public static void main(String[] args) {
    }

    public DBObjectTranslator() {
        this.totalEntries = BigInteger.ZERO;
    }

    public BigInteger calculateTotalEntries(SessionFactory dbSession, String timeSeriesName, String timeSeriesColumn) {
        BigInteger count = BigInteger.ZERO;
        String query = "select count(*) from (SELECT distinct " + timeSeriesColumn + " FROM " + timeSeriesName + ") r;";
        List<Object> resultSet = DatabaseFactory.executeSQLQuery(query, dbSession);
        for (Object result : resultSet) {
            try {
                BigInteger resultcount = (BigInteger)result;
                this.totalEntries = this.totalEntries.add(resultcount);
                count = resultcount;
                AnalysisLogger.getLogger().trace((Object)("DBObjectTranslator->calculateTotalEntries: Time Series " + timeSeriesName + " total " + this.totalEntries));
            }
            catch (Exception exception) {}
        }
        return count;
    }

    public ArrayList<String> retrieveTimeSeriesEntries(SessionFactory dbSession, String timeSeriesName, String timeSeriesColumn, BigInteger min, int numberOfElements) {
        String query = "SELECT distinct " + timeSeriesColumn + " FROM " + timeSeriesName + " r limit " + numberOfElements + " offset " + min;
        AnalysisLogger.getLogger().trace((Object)("DBObjectTranslator->query: " + query));
        List<Object> resultSet = DatabaseFactory.executeSQLQuery(query, dbSession);
        ArrayList<String> column = new ArrayList<String>();
        for (Object result : resultSet) {
            try {
                String value = "";
                if (result != null) {
                    value = result.toString();
                }
                column.add(value);
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().trace((Object)("DBObjectTranslator->retrieveTimeSeriesEntries: Error in adding entry :" + e.getLocalizedMessage()));
            }
        }
        AnalysisLogger.getLogger().trace((Object)("DBObjectTranslator->retrieveColumnRange: Column " + column.toString()));
        return column;
    }

    public ArrayList<Entry> retrieveEntries(SessionFactory dbSession, String timeSeriesName, BigInteger min, int numberOfElements) {
        ArrayList<Entry> currentEntries = new ArrayList<Entry>();
        ArrayList<String> descriptions = new ArrayList<String>();
        ArrayList<String> types = new ArrayList<String>();
        String queryDesc = "SELECT table_name,ordinal_position,column_name,data_type, is_nullable,character_maximum_length FROM information_schema.COLUMNS WHERE table_name ='" + timeSeriesName.toLowerCase() + "'";
        List<Object> resultSetDesc = DatabaseFactory.executeSQLQuery(queryDesc, dbSession);
        for (Object result : resultSetDesc) {
            Object[] resultArray = (Object[])result;
            descriptions.add((String)resultArray[2]);
            types.add(DataTypeRecognizer.transformTypeFromDB((String)resultArray[3]));
        }
        if (descriptions.size() > 0) {
            String query = "SELECT DISTINCT * FROM " + timeSeriesName + " r limit " + numberOfElements + " offset " + min;
            AnalysisLogger.getLogger().trace((Object)("DBObjectTranslator->retrieveEntries: query " + query));
            List<Object> resultSet = DatabaseFactory.executeSQLQuery(query, dbSession);
            for (Object result : resultSet) {
                Entry entry = new Entry();
                try {
                    Object[] resultArray = (Object[])result;
                    int i = 0;
                    for (Object res : resultArray) {
                        String value = "";
                        if (res != null) {
                            value = res.toString();
                        }
                        entry.addAttribute((String)descriptions.get(i), value);
                        entry.addType((String)descriptions.get(i), (String)types.get(i));
                        ++i;
                    }
                    currentEntries.add(entry);
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().trace((Object)("DBObjectTranslator->retrieveEntries: Error in adding entry :" + e.getLocalizedMessage()));
                }
            }
        }
        return currentEntries;
    }

    public void buildRelationsEdges(SessionFactory dbSession) {
        String query = "select * from relation_table;";
        List<Object> resultSet = DatabaseFactory.executeSQLQuery(query, dbSession);
        for (Object result : resultSet) {
            Object[] resultArray = (Object[])result;
            RelationEdge re = null;
            try {
                re = new RelationEdge((String)resultArray[2], "" + resultArray[0], "" + resultArray[1]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (re == null) continue;
            this.relations.add(re);
            AnalysisLogger.getLogger().trace((Object)("DBObjectTranslator->buildRelationsEdges: add relation " + re.toString()));
        }
    }

    public void buildCategories(SessionFactory dbSession, String referenceTable, String referenceColumn, String idColumn, String nameHuman, String description) {
        referenceTable = referenceTable == null ? "reference_table" : referenceTable;
        referenceColumn = referenceColumn == null ? "table_name" : referenceColumn;
        nameHuman = nameHuman == null ? "name_human" : nameHuman;
        idColumn = idColumn == null ? "id" : idColumn;
        description = description == null ? "description" : description;
        String query = "SELECT " + nameHuman + "," + idColumn + "," + referenceColumn + "," + description + " FROM " + referenceTable + " r;";
        List<Object> resultSet = DatabaseFactory.executeSQLQuery(query, dbSession);
        if (resultSet != null) {
            for (Object result : resultSet) {
                Object[] resultArray = (Object[])result;
                Category cat = null;
                try {
                    cat = new Category("" + resultArray[0], "" + resultArray[1], "" + resultArray[2], "" + resultArray[3]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (cat == null) continue;
                this.categories.add(cat);
                AnalysisLogger.getLogger().trace((Object)("DBObjectTranslator->buildCategories: add category " + cat.toString()));
            }
        }
    }

    public Category getCategoryfromIndex(String index) {
        Category cat = null;
        for (Category c : this.categories) {
            if (!c.getIndex().equals(index)) continue;
            cat = c;
            break;
        }
        return cat;
    }

    public void populateRelationWithCategories() {
        for (RelationEdge re : this.relations) {
            Category from = this.getCategoryfromIndex(re.getFrom());
            Category to = this.getCategoryfromIndex(re.getTo());
            re.setCategoryFrom(from.getName());
            re.setCategoryTo(to.getName());
            AnalysisLogger.getLogger().trace((Object)("DBObjectTranslator->populateRelationWithCategories: modified Relation " + re.toString()));
        }
    }

    public void calculateRelationWeights(SessionFactory dbSession) {
        for (RelationEdge re : this.relations) {
            String query = "SELECT count(*) FROM " + re.getName().toLowerCase();
            List<Object> resultSet = DatabaseFactory.executeSQLQuery(query, dbSession);
            for (Object result : resultSet) {
                try {
                    BigInteger resultcount = (BigInteger)result;
                    re.setWeigth(resultcount);
                    this.totalRelationElements = this.totalRelationElements.add(resultcount);
                    AnalysisLogger.getLogger().trace((Object)("DBObjectTranslator->calculateRelationWeights: Relation " + re.getName() + " weight " + re.getWeigth()));
                }
                catch (Exception exception) {}
            }
        }
    }

    public void calculateCategoriesWeights(SessionFactory dbSession) {
        for (Category cat : this.categories) {
            String query = "SELECT count(*) FROM " + cat.getTableName().toLowerCase();
            List<Object> resultSet = DatabaseFactory.executeSQLQuery(query, dbSession);
            for (Object result : resultSet) {
                try {
                    BigInteger resultcount = (BigInteger)result;
                    cat.setNumberOfElements(resultcount);
                    this.totalCatElements = this.totalCatElements.add(resultcount);
                    AnalysisLogger.getLogger().trace((Object)("DBObjectTranslator->calculateCategoriesWeights: Category " + cat.getName() + " weight " + cat.getNumberOfElements() + " total " + this.totalCatElements));
                }
                catch (Exception exception) {}
            }
        }
    }

    public void buildCategoriesStructure(SessionFactory dbSession, String referenceTable, String referenceColumn, String idColumn, String nameHuman, String description) {
        this.buildCategories(dbSession, referenceTable, referenceColumn, idColumn, nameHuman, description);
        this.calculateCategoriesWeights(dbSession);
        AnalysisLogger.getLogger().trace((Object)("DBObjectTranslator->buildWholeStructure: Total Categories Elements " + this.totalCatElements + " Total Relation Elements " + this.totalRelationElements));
    }

    public void buildWholeStructure(SessionFactory dbSession, String referenceTable, String referenceColumn, String idColumn, String nameHuman, String description) {
        this.buildRelationsEdges(dbSession);
        this.buildCategories(dbSession, referenceTable, referenceColumn, idColumn, nameHuman, description);
        this.populateRelationWithCategories();
        this.calculateRelationWeights(dbSession);
        this.calculateCategoriesWeights(dbSession);
        AnalysisLogger.getLogger().trace((Object)("DBObjectTranslator->buildWholeStructure: Total Categories Elements " + this.totalCatElements + " Total Relation Elements " + this.totalRelationElements));
    }
}

